var instance;
(function (instance) {
  var errorCodes = [
    "连接错误(0)",
    "请求超时(1)",
    "授权错误(2)",
    "数据类型错误(3)",
    "不安全的数据(4)",
  ];
  function showStatus (error) {
    var status = error.statusCode;
    var code = error.code;
    var msg = error.msg;
    var message = "";

    if (status) {
      switch (status) {
        case 400:
          message = "请求错误(400)";
          break;
        case 401:
          message = "未授权，请重新登录(401)";
          break;
        case 403:
          message = "拒绝访问(403)";
          break;
        case 404:
          message = "请求出错(404)";
          break;
        case 408:
          message = "请求超时(408)";
          break;
        case 500:
          message = "服务器错误(500)";
          break;
        case 501:
          message = "服务未实现(501)";
          break;
        case 502:
          message = "网络错误(502)";
          break;
        case 503:
          message = "服务不可用(503)";
          break;
        case 504:
          message = "网络超时(504)";
          break;
        case 505:
          message = "HTTP版本不受支持(505)";
          break;
        default:
          message = "连接出错(" + status + ")!";
      }
      return message + "，请检查网络或联系管理员！";
    }

    message = errorCodes[code];

    return message + "，" + msg;
  }

  function loginOut () {
    api.sendEvent({ name: "is_login_status" });
    api.sendEvent({ name: "userLoginOut" });
    api.sendEvent({ name: "updateUser" });
    api.alert({ title: "系统错误TOKEN无效",msg: "请退出重新登录" });
    user.loginOut();
    return false;
  }

  function validateLogin () {
    if (!user.is_login()) return loginOut();
    var token = user.getToken();
    if (token) return token;
    return loginOut();
  }

  function req (method) {
    return function (url,values,callback) {
      var token = validateLogin();
      var uid = user.getUid();
      if (!token) return;
      // token =
      //   "DR4BYABiAjFVbFQ1WT8ORAV/XGdXMFEQDzIOfwJlBmlVNQISUS5UblppVDMFYAguUDcJOFdEUBEFMwtuBRdVPQ1jAWoAFwIw";
      var params = {
        // url: serverurl + url,
        url: new_market_url + url,
        method: method,
        // timeout: 10,
        headers: {
          // token: token,
          // uid: uid,
          MZAPPUID: uid,
          MZAPPTOKEN: token,
        },
      };

      var callback = callback;
      if (typeof values === "function") {
        callback = values;
      } else {
        if (method === "post") params.data = { values: values };
        if (method === "get") params.url += "?" + Qs.stringify(values);
      }
      api.ajax(params,ajaxCallback(callback));
    };
  }

  function ajaxCallback (callback) {
    return function (ret,err) {
      if (ret) callback(ret && ret.data,ret);
      else api.toast({ msg: showStatus(err),duration: 5000 });
    };
  }

  instance.get = req("get");
  instance.post = req("post");
})(instance || (instance = {}));
