var doctorApi;
(function (doctorApi) {
  // 丁香首页
  function fetchDoctorIndex(callback) {
    instance.get("/vapi/doctor/index", callback);
  }

  // 医生列表
  function fetchDoctor(data, callback) {
    instance.get("/vapi/doctor/doctor", data, callback);
  }

  // 推荐科室
  function fetchRecommendDepartment(data, callback) {
    instance.post("/vapi/doctor/department_recommend", data, callback);
  }

  // 科室医生列表
  function fetchDepartmentDoctor(data, callback) {
    instance.get("/vapi/doctor/department_doctor", data, callback);
  }

  // 科室列表
  function fetchDepartment(data, callback) {
    instance.get("/vapi/doctor/department", data, callback);
  }

  // 医生详情
  function fetchDoctorDetail(data, callback) {
    instance.get("/vapi/doctor/doctor_detail", data, callback);
  }

  // 订单支付信息
  function fetchPayInfo(data, callback) {
    instance.get("/vapi/doctor/pay_info", data, callback);
  }

  // 订单立即支付
  function fetchOrderPay(data, callback) {
    instance.post("/vapi/doctor/order_pay", data, callback);
  }

  // 问诊详情
  function fetchQuestionDetail(data, callback) {
    instance.get("/vapi/doctor/question_detail", data, callback);
  }

  // 追加问题
  function fetchQuestionAppend(data, callback) {
    instance.post("/vapi/doctor/question_append", data, callback);
  }

  // 我的问诊
  function fetchQuestionList(data, callback) {
    instance.get("/vapi/doctor/question_list", data, callback);
  }

  // 投诉医生
  function fetchDoctorComplaint(data, callback) {
    instance.post("/vapi/doctor/doctor_complaint", data, callback);
  }

  // 取消订单
  function fetchDoctorOrderCancel(data, callback) {
    instance.post("/vapi/doctor/order_cancel", data, callback);
  }

  // 用户信息
  function fetchUserInfo(callback) {
    instance.get("/vapi/member/userInfo", callback);
  }

  // 医生评价列表
  function fetchDoctorComment(data, callback) {
    instance.post("/vapi/doctor/doctorComment", data, callback);
  }

  // 添加评价
  function fetchQuestionComment(data, callback) {
    instance.post("/vapi/doctor/questionComment", data, callback);
  }

  // 评价（问诊详情）
  function fetchRateQuestionDetail(data, callback) {
    instance.get("/vapi/doctor/question_detail", data, callback);
  }

  doctorApi.fetchDoctorIndex = fetchDoctorIndex;
  doctorApi.fetchDoctor = fetchDoctor;
  doctorApi.fetchRecommendDepartment = fetchRecommendDepartment;
  doctorApi.fetchDepartmentDoctor = fetchDepartmentDoctor;
  doctorApi.fetchDepartment = fetchDepartment;
  doctorApi.fetchDoctorDetail = fetchDoctorDetail;
  doctorApi.fetchPayInfo = fetchPayInfo;
  doctorApi.fetchOrderPay = fetchOrderPay;
  doctorApi.fetchQuestionDetail = fetchQuestionDetail;
  doctorApi.fetchQuestionAppend = fetchQuestionAppend;
  doctorApi.fetchQuestionList = fetchQuestionList;
  doctorApi.fetchDoctorComplaint = fetchDoctorComplaint;
  doctorApi.fetchDoctorOrderCancel = fetchDoctorOrderCancel;
  doctorApi.fetchUserInfo = fetchUserInfo;
  doctorApi.fetchDoctorComment = fetchDoctorComment;
  doctorApi.fetchQuestionComment = fetchQuestionComment;
  doctorApi.fetchRateQuestionDetail = fetchRateQuestionDetail;
})(doctorApi || (doctorApi = {}));
