///<reference path='../../../script/dayjs.min.js' />

var consultation = {
  template:
    '<div class="consultations" @click="goToConsultationDetail">\
      <van-row>\
        <van-col class="avatar" span="20">\
        <div class="clipboard">\
          <span>问诊号：{{props.question_id}}</span>\
          <span class="clipButton" @click.stop="copy(props.question_id)">复制</span>\
        </div>\
        </van-col>\
        <van-col span="4" style="height: 0.72rem; line-height: 0.72rem; font-size: 0.24rem; text-align: right; ">\
          <span :style="{color: color}"\
            >{{props.status_name}}</span\
          >\
        </van-col>\
      </van-row>\
      <van-row>\
        <van-col class="avatar" span="3">\
          <van-image\
            width="0.72rem"\
            height="0.72rem"\
            round\
            :src="props.doctor_avatar"\
          />\
          <div class="dot" v-if="props.is_read==1"></div>\
        </van-col>\
        <van-col span="17" style="height: 0.72rem; line-height: 0.72rem">\
          <b>{{props.doctor_name?props.doctor_name:"医生"}}&nbsp;</b>\
          <span style="color: #333; font-size: 0.28rem;">{{props.department_name}}</span>\
        </van-col>\
        <van-col span="4" style="height: 0.72rem; line-height: 0.72rem; font-size: 0.24rem; text-align: right; ">\
        </van-col>\
      </van-row>\
      <div class="decrease-width">\
        <span class="van-multi-ellipsis--l2" style="word-break:break-all;">{{props.content}}</span>\
      </div>\
      <van-row>\
        <span style="font-size: 0.26rem; color: #BDBCBC; line-height: 32px;">{{timeText}}</span>\
        <div v-if="!btnhidden" style="float: right; ">\
          <van-button v-if="isCancelOrder" plain round size="small" @click.stop="handleButton(\'cancle\')"\
            >取消订单</van-button\
          >\
          <van-button\
            v-if="isGoToPay"\
            style="width: 1.52rem;"\
            plain\
            round\
            size="small"\
            color="#FF5D71"\
            @click.stop="handleButton(\'pay\')"\
            >去支付</van-button\
          >\
          <van-button\
            v-if="isComplaint"\
            style="width: 1.52rem;"\
            plain\
            round\
            size="small"\
            color="#BDBCBC"\
            @click.stop="handleButton(\'complaint\')"\
            >投诉</van-button\
          >\
          <van-button\
            v-if="isEvaluation"\
            style="width: 1.52rem;"\
            plain\
            round\
            size="small"\
            color="#BDBCBC"\
            @click.stop="handleButton(\'evaluation\')"\
            >评价</van-button\
          >\
        </div>\
      </van-row>\
    </div>',
  name: "consultation",
  props: {
    props: {},
    btnhidden: false,
  },
  data: function () {
    return {};
  },
  created: function () {},
  computed: {
    color: function () {
      if (this.props.status_name === "待支付") {
        return "#ff5d71";
      }
      return "#BDBCBC";
    },
    timeText: function () {
      var timestamp = +this.props.create_time;
      if (this.isToday(timestamp))
        return dayjs(timestamp * 1000).format("HH:mm");
      return dayjs(timestamp * 1000).format("YYYY/MM/DD HH:mm");
    },
    isGoToPay: function () {
      return this.props.operation_btns.some(function (item) {
        return +item.no === 1;
      });
    },
    isCancelOrder: function () {
      return this.props.operation_btns.some(function (item) {
        return +item.no === 0;
      });
    },
    isComplaint: function () {
      return this.props.operation_btns.some(function (item) {
        return +item.no === 2;
      });
    },
    isEvaluation: function () {
      return this.props.order_status === 10 && this.props.is_comment === 0; //是否已经评价
    },
  },
  methods: {
    handleButton: function (val) {
      //判断状态是否为关闭或者结束的时候显示
      if (val === "evaluation")
        goWin("问诊详情", "consultation-detail", {
          question_id: this.props.question_id,
          is_comment: this.props.is_comment,
        });
      if (val === "cancle") this.$emit("cancleorder", this.props.question_id);
      if (val === "complaint")
        goWin("投诉医生", val, { question_id: this.props.question_id });
      if (val === "pay") {
        var that = this;
        instance.get(
          "/vapi/doctor/rePaycheckOrderStatus",
          { question_id: this.props.question_id },
          function (res, res1) {
            if (res1.code === 1) {
              if (!+that.props.pay_money) {
                that.$toast("支付金额不能为0元");
              } else {
                goWin("订单支付", val, {
                  question_id: that.props.question_id,
                  pay_money: that.props.pay_money,
                });
              }
            } else {
              that.$toast(res1.message);
              setTimeout(function () {
                that.$emit("refresh");
              }, 2000);
            }
          }
        );
      }
    },
    goToConsultationDetail: function (val) {
      goWin("问诊详情", "consultation-detail", {
        question_id: this.props.question_id,
        doctor_id: this.props.doctor_id,
      });
    },
    isToday: function (timestamp) {
      return (
        dayjs(new Date()).format("YYYYMMDD") ===
        dayjs(timestamp * 1000).format("YYYYMMDD")
      );
    },
    copy: function (id) {
      clipBoard.set(
        {
          value: id,
        },
        function (ret, err) {
          if (ret) {
            api.toast({
              msg: "复制成功",
              duration: 2000,
              location: "bottom",
            });
          } else {
            alert(JSON.stringify(err));
          }
        }
      );
    },
  },
};
