var disease = {
  template: '<div>' +
    '<div class="disease">' +
    '<div>' +
    '<span>{{disease.title}}</span>' +
    '<span class="howDescribe" @click="switchCase()">如何描述？</span>' +
    '</div>' +
    '<div class="case" :class="caseMark?showCase:hiddenCase">{{disease.content}}</div>' +
    '<div class="illness">' +
    '<textarea v-model="illness" @input="chIllness" placeholder="请在此处填写病情描述..."></textarea>' +
    '<dev class="limitNum">{{illness.length}}/400</dev>' +
    '</div>' +
    '</div>' +
    '</div> ',
  props: {
    illness: {
      type: String,
      default: "",
    },
    disease: {
      type: Object,
      default: "",
    }
  },
  data: function () {
    return {
      caseMark: false,
      showCase: 'showCase',
      hiddenCase: "",
    }
  },
  methods: {
    switchCase: function () {
      this.caseMark = !this.caseMark;
    },
    chIllness: function () {
      if (this.illness.length > 400) {
        api.toast({
          msg: '最多可以填写400个字',
          duration: 2000,
          location: 'bottom'
        });
        this.illness = this.illness.slice(0,400)
      }
      var params = {
        name: 'illness',
        value: this.illness
      }
      this.$emit('chinfo',params)
    }
  },
}