var doctorCard = {
  template:
    '<div style="padding: 0.3rem 0;margin: 0 0.3rem; -webkit-transform: translateZ(0px);" class="doctor-card van-hairline--bottom" @click="goDoctorDetail">' +
    '<div style="background-color: #fff; font-size: 0.26rem;">' +
    '<div style="display:flex">' +
    "<div style='padding-right: 0.2rem; flex:1'>" +
    " <van-image " +
    ' width= "1.2rem" ' +
    ' height= "1.2rem" ' +
    ' :src="doctorinfo.avatar" ' +
    "round" +
    ">" +
    "</van-image>" +
    "</div>" +
    "<div style='flex:5'>" +
    "<div>" +
    '<div style="height: 0.5rem; line-height: 0.5rem">' +
    "<b style='color: #151212; font-size: 0.32rem;'>{{doctorinfo.nickname}}</b>" +
    "<span style='color: #333; font-size: 0.28rem;'>&nbsp;{{doctorinfo.section_name}}</span>" +
    "<span style='color: #333; font-size: 0.28rem;'>&nbsp;{{doctorinfo.job_title_name}}</span>" +
    '<van-button color="#E4FCF9" round size="small" @click.stop="askDoctor()" class="askQuestion" ' +
    ">问问TA</van-button" +
    ">" +
    "</div>" +
    '<div style="margin-bottom: 0.1rem;font-size:0.26rem">' +
    "<span>{{doctorinfo.hospital_name}}</span>" +
    "</div>" +
    "<div style='font-size:0.24rem'>" +
    "<span>{{doctorinfo.introduction}}</span>" +
    "</div>" +
    '<div class="responseTime">' +
    '<van-icon name="star" color="#FFB621" style="line-height: 0.36rem;"></van-icon>' +
    "<span style='color: #333; margin-left: 0.1rem;font-size:0.24rem'>{{(+doctorinfo.star || 0).toFixed(2)}}</span>" +
    '<span style="color: #999;font-size:0.22rem">{{ doctorinfo.avg_reply_time | format }}响应</span>' +
    "</div>" +
    '<div style="color: #FFB621">' +
    '<van-tag style="padding: 0.04rem 0.12rem; border-radius: 0.08rem; margin-right: 0.1rem; margin-top: 0.1rem; " round text-color="#FFB621" color="#FFFAEB" size="small" v-for="tag in doctorinfo.tags">{{tag}}</van-tag > ' +
    "</div>" +
    '<div style="margin-top: 0.1rem;font-size:0.24rem">' +
    "<span>图文￥{{(+doctorinfo.ask_fee/100 || 0).toFixed(2)}}</span>" +
    '<div v-if="isVip != 3" style="background:#FFE9EC;border-radius: 9px 9px 9px 1px;color: #FF5D71;display:inline-block;padding:2px 5px;margin-left:10px"><span style="font-size:0.2rem">{{doctorinfo.is_vip ? "会员价":"优惠价"}}</span><span style="font-weight:bold;">￥{{doctorinfo.is_vip? ((+doctorinfo.member_price/100 || 0).toFixed(2)) : ((+doctorinfo.non_member_price/100 || 0).toFixed(2))}}</span></div>' +
    "</div>" +
    "</div>" +
    "</div>" +
    "</div>" +
    "</div>" +
    "</div>",
  name: "doctorCard",
  props: {
    doctorinfo: {
      type: Object,
      default: {},
    },
    illdetail: {
      type: Object,
      default: {},
    },
    department_id: {
      type: String,
      default: "",
    },
    isnormal: {
      type: Boolean,
      default: "",
    },
  },
  data: function () {
    return {
      picUrl: "https://img.yzcdn.cn/vant/cat.jpeg",
    };
  },
  computed: {
    isVip() {
      var isVip = 0;
      if (this.doctorinfo.is_vip == 0) {
        if (this.doctorinfo.non_member_price == this.doctorinfo.ask_fee) {
          isVip = 3;
        }
      } else if (this.doctorinfo.is_vip == 1) {
        if (this.doctorinfo.member_price == this.doctorinfo.ask_fee) {
          isVip = 3;
        }
      }
      return isVip;
    },
  },
  filters: {
    format: function (time) {
      var min = Math.ceil(time / 60);
      if (min > 60) {
        hour = Math.ceil(min / 60);
        return hour + "小时";
      }
      return min + "分钟";
    },
  },
  methods: {
    askDoctor: function () {
      var data = this.illdetail ? this.illdetail : {};

      data.department_id = this.department_id;
      data.doctor_id = this.doctorinfo.user_id;
      var that = this;
      instance.post("/vapi/doctor/checkDoctorStatus", data, function (res, res2) {
        // 错误处理
        if (res2.code !== 1) {
          that.$toast(res2.message);
          // setTimeout(function () {
          //   that.$emit("ref");
          // }, 2000);
        } else {
          $api.setStorage("illDetail", data);
          if (that.isnormal) {
            goWin("问医生", "consultant");
          } else {
            goWin("订单支付", "order");
          }
        }
      });
    },
    goDoctorDetail: function () {
      var data = this.illdetail ? this.illdetail : {};

      data.department_id = this.department_id;
      data.doctor_id = this.doctorinfo.user_id;
      $api.setStorage("illDetail", data);
      goWin("医生详情", "doctor-detail", { user_id: this.doctorinfo.user_id });
    },
  },
};
