var doctorResponse = {
  template:
    '<div class="doctorResponse">' +
    '<div class="consultationTime">{{doctorResponse.create_time | getTime}}</div>' +
    "<div>" +
    '<div style="display: flex">' +
    '<div style="width: 1.22rem">' +
    '<van-image width="0.72rem" height="0.6712rem" round :src="doctorResponse.user_avatar" style="padding: 0 0.2rem 0 0.3rem" >' +
    "</van-image>" +
    "</div>" +
    '<div class="doctorContentText">' +
    '<div style="padding: 0.3rem;white-space: pre-wrap;">{{doctorResponse.content}}</div>' +
    '<div style="padding: 0 0.3rem 0.3rem" v-if="doctorResponse.img_url && doctorResponse.img_url.length > 0" >' +
    '<van-image class="illPic" fit="cover" @click="previewPic(index)" v-for="(item,index) in doctorResponse.img_url" :src="item" >' +
    "</van-image>" +
    "</div>" +
    "</div>" +
    "</div>" +
    '<div style="display: flex; justify-content: center; margin-top: 0.3rem" >' +
    '<div v-if="showendtime" class="endTime"><slot></slot></div>' +
    "</div>" +
    "</div>" +
    "</div>",
  name: "doctorResponse",
  props: {
    doctorResponse: {
      type: Object,
      default: {},
    },
    showendtime: {
      type: Boolean,
      default: false
    }
  },
  data: function () {
    return {
      playTimes: 0,
      voicePause: false,
      sliderProgress: {},
      voiceTime: 0,
      audioStreamer: {},
      isIOS: false,
    };
  },
  created: function () {
    // this.getConsultetaionDetail(15);
    this.audioStreamer = api.require("audioStreamer");
    this.voiceControl(false);
    this.isIOS = api.systemType == "ios" ? true : false;
  },
  filters: {
    getTime: function (time) {
      if (
        dayjs(new Date()).format("YYYYMMDD") ===
        dayjs(time * 1000).format("YYYYMMDD")
      )
        return dayjs(time * 1000).format("HH:mm");
      return dayjs(time * 1000).format("YYYY/MM/DD HH:mm");
    },
  },
  computed: {
    getFormatTime: function () {
      return formatSeconds(this.voiceTime - this.playTimes);
    },
  },
  methods: {
    previewPic: function (index) {
      window.vant.ImagePreview({
        images: this.doctorResponse.img_url,
        closeable: true,
        startPosition: index,
      });
    },
    changeVoicePause: function (val) {
      this.voicePause = val;
      if (val) {
        this.voiceAutoPlay();
        //播放进度到达末尾时
        if (this.voiceTime - this.playTimes <= 0) {
          this.playTimes = 0;
          this.audioStreamer.seekToTime({
            time: 0,
          });
        }
        if (this.isIOS) {
          this.audioStreamer.resume();
          return;
        }
        this.voiceControl(true);
      } else {
        clearInterval(this.sliderProgress);
        this.audioStreamer.pause();
      }
    },
    voiceAutoPlay () {
      var that = this;
      this.sliderProgress = setInterval(function () {
        that.playTimes++;
        if (!that.voicePause) that.voicePause = true;
        if (that.voiceTime - that.playTimes <= 0) {
          that.voicePause = false;
          clearInterval(that.sliderProgress);
        }
      },1000);
    },
    voiceControl: function (val) {
      var that = this;
      this.audioStreamer.openPlayer(
        {
          path:
            "http://7xisq1.com1.z0.glb.clouddn.com/apicloud/0d0b81b8bd5ab81bda9ca54267eb9b98.mp3",
        },
        function (ret) {
          if (ret.status) {
            if (!val) {
              that.audioStreamer.pause();
              that.voiceTime = ret.duration;
            }
          }
        }
      );
    },
    sliderChange: function (val) {
      if (this.voiceTime - val <= 0) {
        this.voicePause = false;
        return;
      } else {
        this.voicePause = true;
      }
      this.audioStreamer.seekToTime({
        time: val,
      });

      clearInterval(this.sliderProgress);
      this.voiceAutoPlay();
      if (this.isIOS) {
        this.audioStreamer.resume();
        return;
      }
      this.voiceControl(true);
    },
  },
};
