var doctorVoice = {
  template:
    '<div class="doctorResponse">' +
    '<div class="consultationTime">{{doctorresponse.create_time | getTime}}</div>' +
    "<div>" +
    '<div style="display: flex">' +
    '<div style="width: 1.22rem">' +
    '<van-image width="0.72rem" height="0.6712rem" round :src="doctorresponse.user_avatar" style="padding: 0 0.2rem 0 0.3rem" >' +
    "</van-image>" +
    "</div>" +
    "<div>" +
    '<div class="doctorContentText"  style="border-radius: 0;" v-if="doctorresponse.content || doctorresponse.img_url">' +
    '<div style="padding: 0.3rem;white-space: pre-wrap;">{{doctorresponse.content}}</div>' +
    '<div style="padding: 0 0.3rem 0.3rem" v-if="doctorresponse.img_url && doctorresponse.img_url.length > 0" >' +
    '<van-image class="illPic" fit="cover" @click="previewPic(index)" v-for="(item,index) in doctorresponse.img_url" :src="item" >' +
    "</van-image>" +
    "</div>" +
    "</div>" +
    '<div style="width: 5.28rem" :class="doctorresponse.content || doctorresponse.img_url?\' doctorVoiceContents \':\'\'" class="doctorVoiceContent">' +
    '<div class="playVoice">' +
    '<div class="playIcon" v-show="!isPlaying" @click="changeVoicePause(true)" ></div>' +
    '<div class="pauseIcon" v-show="isPlaying" @click="changeVoicePause(false)" ></div>' +
    '<van-slider v-model="playTimes" active-color="#fff" step="1" button-size="0.16rem" inactive-color="#EFEFEF" max="100" @change="sliderChange" >' +
    "</van-slider>" +
    "<div>" +
    '<span style="font-size: 0.24rem; color: #fff" >{{ getFormatTime }}</span >' +
    "</div>" +
    "</div>" +
    "</div>" +
    "</div>" +
    "</div>" +
    '<div style="display: flex; justify-content: center; margin-top: 0.3rem" >' +
    '<div v-if="showendtime" class="endTime"><slot></slot></div>' +
    "</div>" +
    "</div>",
  name: "doctorVoice",
  props: {
    voice: {
      type: String,
      default: "",
    },
    doctorresponse: {
      type: String,
      default: {},
    },
    showendtime: {
      type: Boolean,
      default: false,
    },
    url: {
      type: String,
      default: "",
    },
  },
  data: function () {
    return {
      playTimes: 0,
      isPlaying: false,
      sliderProgress: null,
      voiceTime: this.voice.duration / 1000,
      audioStreamer: null,
      isIOS: api.systemType == "ios",
      text: false,
      isReady: false,
      isFinished: false,
    };
  },
  created: function () {
    this.audioStreamer = api.require("audioStreamer");
    var that = this;
    api.addEventListener(
      {
        name: "pause",
      },
      function () {
        that.audioStreamer.pause();
      }
    );
  },
  watch: {
    url: function (url, oldurl) {
      if (url !== oldurl && oldurl === this.voice.url) {
        this.isPlaying = false;
      }
    },
    playTimes: function (val) {
      var that = this;
      if (val == 100)
        setTimeout(function () {
          that.playTimes = 0;
        }, 500);
    },
  },
  filters: {
    getTime: function (time) {
      if (
        dayjs(new Date()).format("YYYYMMDD") ===
        dayjs(time * 1000).format("YYYYMMDD")
      )
        return dayjs(time * 1000).format("HH:mm");
      return dayjs(time * 1000).format("YYYY/MM/DD HH:mm");
    },
  },
  computed: {
    getFormatTime: function () {
      return formatSeconds(
        this.voiceTime - (this.voiceTime * this.playTimes) / 100
      );
    },
  },
  methods: {
    progressListenerAudioStreamer: function (ret) {
      if (this.isFinished) return;
      if (ret.progress === "100") {
        if (!this.isFinished) {
          this.playTimes = 100;
        }
        this.isFinished = true;
      }
      if (ret.progress > 0) this.playTimes = ret.progress;
    },
    listenerAudioStreamer: function (ret) {
      if (ret.state === "prepare") this.isReady = true;

      if (
        ["pause", "finished"].some(function (item) {
          return item === ret.state;
        })
      ) {
        this.isPlaying = false;
      } else {
        this.isPlaying = true;
      }
      if (ret.state === "finished") {
        if (!this.isFinished) {
          this.playTimes = 100;
        }
        this.isFinished = false;
      }
    },
    previewPic: function (index) {
      window.vant.ImagePreview({
        images: this.doctorresponse.img_url,
        closeable: true,
        startPosition: index,
      });
    },
    changeVoicePause: function (val) {
      this.$emit("child-voice-emit", this.voice);
      if (val) {
        if (this.isIOS && this.isReady) {
          this.voiceControl(true);
          this.audioStreamer.resume();
        } else {
          this.voiceControl(true);
        }
      } else {
        this.audioStreamer.pause();
      }
    },
    voiceControl: function (val, time) {
      var that = this;

      var as = this.audioStreamer;

      if (val) {
        var path = this.voice.url;
        if (this.url !== path) {
          this.isPlaying = false;
          this.audioStreamer && this.audioStreamer.stop();
        }

        as.addEventListener({}, this.listenerAudioStreamer);
        as.addProgressListener({}, this.progressListenerAudioStreamer);
        this.audioStreamer.openPlayer({ path: path }, function (ret) {
          if (ret.status) {
            if (time) that.seekToTime(time);
            if (that.playTimes)
              that.seekToTime((ret.duration * that.playTimes) / 100);
            that.voiceTime = ret.duration;
          }
        });
      } else {
        this.audioStreamer.pause();
      }
    },
    sliderChange: function (val) {
      this.$emit("child-voice-emit", this.voice);
      if (this.isReady && this.url === this.voice.url) {
        this.seekToTime((this.voiceTime * val) / 100);
        if (!this.isPlaying)
          this.voiceControl(true, (this.voiceTime * val) / 100);
      } else this.voiceControl(true, (this.voiceTime * val) / 100);
    },
    seekToTime: function (time) {
      this.audioStreamer.seekToTime({ time: time });
    },
  },
};
