/**
 * 文字过多折叠收起效果
 * 2020年9月25日 10:28:58  xzk  qq724087709
 */
Vue.component("fold-text", {
  props: {
    text: {
      // 文本
      type: String,
      default: "",
    },
    color: {
      // 折叠 收起的颜色
      type: String,
      default: "#1dcdb8",
    },
    limitNum: {
      // 限制的字数
      type: Number,
      require: true, // 限制折叠的字数
    },
    btnTexts: {
      // 操作文字
      type: Array,
      default: ["详情", "收起"],
    },
  },
  data: function () {
    return {
      limitText: "",
      btnText: "",
      limitNum: 0,
      isLimit: false, // 状态 是否展开
      isNeedLimit: false,
    };
  },
  created: function () {
    this.getLimitText();
  },
  methods: {
    getLimitPosition: function (text) {
      var position = text.indexOf("\n");
      if (position > 0) {
        position = text.indexOf("\n", position + 1);
      }
      return position;
    },
    getLimitText: function () {
      var length = this.text.length;
      if (length > this.limitNum) {
        this.isNeedLimit = true;
        var limtText = this.text.substring(0, this.limitNum);
        var position = this.getLimitPosition(limtText);
        if (position > 0) {
          limtText = this.text.substring(0, position);
        }
        this.limitText = limtText;
        this.isLimit = true;
        this.btnText = this.btnTexts[0];
      } else {
        var position = this.getLimitPosition(this.text);
        if (position > 0) {
          this.isNeedLimit = true;
          this.limitText = this.text.substring(0, position);
          this.btnText = this.btnTexts[0];
          this.isLimit = true;
        } else {
          this.limitText = this.text;
          this.isLimit = false;
          this.btnText = this.btnTexts[1];
        }
      }
    },
    exp: function () {
      if (this.isLimit) {
        // 展开
        this.limitText = this.text;
        this.btnText = this.btnTexts[1];
        this.isLimit = !this.isLimit;
      } else {
        this.getLimitText();
        this.btnText = this.btnTexts[0];
      }
    },
  },
  template:
    '<div class="fold-text">' +
    "{{limitText}}" +
    '<span class="btn-act" :style="{\'color\':color}" @click="exp" v-if="isNeedLimit">{{btnText}}</span>' +
    "</div>",
});
