var patientInfo = {
  template:
    '<div>' +
    '<div class="title">请填写患者信息</div>' +
    '<div class="cell">' +
    '<div class="cellTitle">性别</div>' +
    '<div class="cellContent">' +
    '<span class="sex"  @click="chSex(1)" :class="sex===1?checkedSex:checkedNone">男</span >' +
    '<span class="sex"  @click="chSex(2)" :class="sex===2?checkedSex:checkedNone">女</span>' +
    '</div >' +
    '</div >' +
    '<div class="cell">' +
    '<div class="cellTitle">年龄</div>' +
    '<div class="cellContent"><input v-model="age" @input="chAge()" placeholder="请输入患者年龄" /></div>' +
    '</div>' +
    '</div>',
  props: {
    sex: {
      type: Number,
      default: 1,
    },
    age: {
      type: Number,
      default: ''
    }
  },
  data: function () {
    return {
      checkedSex: "checkedSex",
      checkedNone: ""
    }
  },
  computed: {
    avatarFile: function () {

    }
  },
  methods: {
    chSex: function (sex) {
      var parmas = {
        name: 'sex',
        value: sex
      }
      this.$emit('chinfo',parmas)
    },
    chAge: function () {
      if (this.age.length > 10) {
        this.age = this.age.slice(0,10)
        return
      }
      this.age = this.age.replace(/[^\a-\z\A-\Z0-9\u4E00-\u9FA5]/g,'')

      var parmas = {
        name: 'age',
        value: this.age
      }
      this.$emit('chinfo',parmas)
    }
  }
}
