var uploadPic = {
  template:
    '<div>' +
    '<div class="pic">' +
    '<div class= "upload" v-for="(item,index) in imgList" >' +
    '<img class="close" @click="closePic(item)" src= "./img/close.png" />' +
    '<van-image class="illPic" fit="cover" @click="previewPic(index)" :src="item.src"/>' +
    '</div >' +
    '<div class="upload" @click="uploadPic" >' +
    '<div>' +
    '<img class="camera" src="./img/camera.png" alt="" />' +
    '<div>{{ imgList.length }}/9</div>' +
    '</div>' +
    '</div >' +
    '<div class="contentExplain" v-show="imgList.length === 0">上述内容仅对接诊医生可见</div>' +
    '</div >' +
    '</div>',
  name: 'uploadPic',
  props: {
    picList: {
      type: Array,
      default: []
    },
  },
  data: function () {
    return {
      imgList: []
    }
  },
  created: function () {
    this.imgList = this.picList
  },
  methods: {
    previewPic: function (index) {
      var list = [];
      for (var i = 0; i < picList.length; i++) {
        if (picList[i].src) {
          list.push(picList[i].src);
        }
      }
      window.vant.ImagePreview({
        images: list,
        closeable: true,
        startPosition: index,
      });
    },
    closePic: function (pic) {
      var i = picList.indexOf(pic);
      picList.splice(i,1);
      picSize -= picList.size;
    },
    uploadPic: function () {
      if (isLoading) {
        api.toast({
          msg: "请等待图片上传再操作哦",
          duration: 2000,
          location: "bottom",
        });
        return;
      }
      if (this.imgList.length >= 9) {
        api.toast({
          msg: "最多上传9张图片哦！",
        });
        return;
      }
      var sourceType = "album";
      var that = this;
      if (!isIOS) {
        sourceType = "library";
      }
      api.actionSheet(
        {
          // title: '选择图片来源',
          buttons: ["拍照","选择照片"],
        },
        function (ret,err) {
          var index = ret.buttonIndex;
          switch (index) {
            // 拍照
            case 1:
              // 打开拍照
              that.handleCamera();
              break;
            // 打开图片选择器
            case 2:
              choosePic(function (picList) {
                this.imgList = picList
                var params = {
                  name: 'picList',
                  value: picList
                }
                that.imgList = picList
                that.$emit('chinfo',params)
              });
              break;
          }
        }
      );
    },
    handleCamera: function () {
      var that = this
      api.getPicture(
        {
          sourceType: "camera",
          encodingType: "jpg",
          mediaValue: "pic",
          quality: 100,
          targetWidth: 768,
          targetHeight: 768,
          saveToPhotoAlbum: false,
          allowEdit: false,
        },
        function (ret,err) {
          if (ret && ret.data) {
            var returnUrl = ret.data;
            pressImg(returnUrl,1,function () {
              api.hideProgress();
              isLoading = false;
              var params = {
                name: 'picList',
                value: picList
              }
              that.imgList = picList
              that.$emit('chinfo',params)
            });
          }
        }
      );
    },
  }
}
