// Polyfill Object.assign
if (typeof Object.assign !== "function") {
  Object.defineProperty(Object, "assign", {
    value: function assign(target, varArgs) {
      "use strict";
      if (target === null || target === undefined) {
        throw new TypeError("Cannot convert undefined or null to object");
      }

      var to = Object(target);

      for (var index = 1; index < arguments.length; index++) {
        var nextSource = arguments[index];

        if (nextSource !== null && nextSource !== undefined) {
          for (var nextKey in nextSource) {
            if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
              to[nextKey] = nextSource[nextKey];
            }
          }
        }
      }
      return to;
    },
    writable: true,
    configurable: true,
  });
}

document.write(
  '<script src="./js/px2rem.js"></script>\
  <script src="./js/vue.min.js"></script>\
  <script src="./js/vant.min.js"></script>\
  <script src="./js/qs.min.js"></script>\
  <script type="text/javascript" src="./js/util.js"></script>\
  <script type="text/javascript" src="../../script/api.js"></script>\
  <script type="text/javascript" src="../../script/common.js"></script>\
  <script type="text/javascript" src="./api/config.js"></script>\
  <script type="text/javascript" src="./api/doctorApi.js"></script>\
  '
);
