// <referen />
var machineurl = "http://images.cookmami.com/"; //服务器路径，用于图片显示
var NewGuid = function () {
  function S4 () {
    return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
  }
  return (
    S4() +
    S4() +
    "-" +
    S4() +
    "-" +
    S4() +
    "-" +
    S4() +
    "-" +
    S4() +
    S4() +
    S4()
  );
};
var getNowFormatDate = function () {
  var date = new Date();
  var seperator1 = "-";
  var year = date.getFullYear();
  var month = date.getMonth() + 1;
  var strDate = date.getDate();
  if (month >= 1 && month <= 9) {
    month = "0" + month;
  }
  if (strDate >= 0 && strDate <= 9) {
    strDate = "0" + strDate;
  }
  var currentdate = year + seperator1 + month + seperator1 + strDate;
  return currentdate;
};

function choosePic (getPicList) {
  var limit = 9 - picList.length;
  UIAlbumBrowser.open(
    {
      type: "image",
      max: limit,
      styles: {
        bg: "#fff",
        mark: {
          icon: "",
          position: "bottom_left",
        },
        nav: {
          bg: "rgb(193, 149, 123)",
          titleColor: "#333",
          titleSize: 18,
          // cancelBg: 'rgba(0,0,0,0)',
          cancelColor: "#fff",
          cancelSize: 16,
          finishBg: "#f7da6d",
          finishColor: "rgb(151,110,63)",
          finishSize: 16,
        },
      },
    },
    function (ret) {
      if (ret) {
        if (ret.eventType == "confirm") {
          //修正取消隐藏显示对话框
          if (ret.list.length == 0 || isLoading) {
            if (is_debug) {
              api.toast({
                msg: "未选择图片",
              });
            }
            return;
          }
          isLoading = true;

          var publishList = ret.list;
          if (isIOS) publishList.reverse();
          var index = 0;
          async.eachSeries(
            publishList,
            function (item,callback) {
              index++;
              api.showProgress({
                title: "努力加载中",
                text: " 请稍等...",
                modal: false,
              });
              var selectImg = item;
              // 获取图片的路径
              var selectimgPath = selectImg.path;
              var selectimgThumbPath = selectImg.thumbPath;
              if (isIOS) {
                // 转换为真实路径
                UIAlbumBrowser.transPath(
                  {
                    path: selectimgPath,
                  },
                  function (transObj) {
                    pressImg(transObj.path,publishList.length,function () {
                      if (index === publishList.length) {
                        isLoading = false;
                        api.hideProgress();
                      }
                      getPicList(picList);
                      callback();
                    });
                  }
                );
              } else {
                pressImg(selectimgPath,publishList.length,function () {
                  if (index === publishList.length) {
                    isLoading = false;
                    api.hideProgress();
                  }
                  getPicList(picList);
                  callback();
                });
              }
            },
            function (err) { }
          );
        }
      }
    }
  );
}
function pressImg (src,length,callback) {
  api.showProgress({
    title: "处理中",
    text: "正在努力处理图片...",
    modal: false,
  });
  lrz(src,{
    width: 1024,
    quality: 0.5,
  })
    .then(function (rst) {
      var size = rst.fileLen / 1024 / 1024; //byte转化为M
      picSize += size;
      if (size >= 10 && length === 1) {
        api.toast({
          msg: "单张图片大小不允许超过10M哦~",
        });
        callback();
      } else if (size >= 10 && length >= 1) {
        api.toast({
          msg: "已过滤超过10M图片！",
        });
        callback();
      } else if (picSize >= 20) {
        picSize -= size;
        api.toast({
          msg: "总图片大小不允许超过20M哦~",
        });
        callback();
      } else {
        saveBase64Img(rst.base64,function (ret) {
          upload(ret,size,function () {
            callback();
          });
        });
      }
    })
    .catch(function (err) {
      api.toast({
        msg: "图片压缩失败",
        duration: 2000,
        location: "bottom",
      });
      isLoading = false;
      api.hideProgress();
    });
}

function upload (imgsrc,size,cb) {
  qiniuUpfile.upfile(
    {
      file: imgsrc,
      name: "uploadDoctor" + NewGuid() + ".jpg",
    },
    function (ret,err) {
      if (ret.status) {
        if (ret.oper == "complete") {
          var data = {
            size: size,
            src: machineurl + ret.info.key,
          };
          picList.push(data);
          cb();
        } else if (ret.oper == "progress") {
          api.showProgress({
            title: parseInt(ret.percent) + "%",
            text: "正在努力上传图片...",
            modal: false,
          });
          //上传过程中获取进度数据
        } else {
          api.hideProgress();
          isLoading = false;
          api.toast({
            msg: "请检查网络后重试",
            duration: 2000,
            location: "middle",
          });
        }
      } else {
        console.log(JSON.stringify(err));
      }
    }
  );
}

/*base64 保存文件*/
function saveBase64Img (base64,callback) {
  var savePath = api.cacheDir + "/" + getNowFormatDate() + "/";
  // 压缩文件生成的随机文件名称
  var savename = NewGuid() + ".png";
  var base64 = base64.replace("data:image/jpeg;base64,","");
  trans.saveImage(
    {
      base64Str: base64,
      album: false,
      imgPath: savePath,
      imgName: savename,
    },
    function (ret,err) {
      if (ret.status) {
        callback(savePath + savename);
      } else {
        api.alert({
          title: "提示",
          msg: "压缩保存图片失败",
        });
        isLoading = false;
      }
    }
  );
}
