function goWin(header, name, data, reload) {
  if (!data) {
    data = "";
  }
  if (!reload) {
    reload = false;
  }
  api.openWin({
    name: "win_" + name,
    url: api.wgtRootDir + "/html/doctor/win_common.html",
    reload: reload,
    pageParam: {
      header: header,
      name: name,
      url: api.wgtRootDir + "/html/doctor/" + name + ".html",
      data: data,
      reload: reload,
    },
  });
}

//将秒数转换为时分秒格式
function formatSeconds(times) {
  if (typeof times === "number") {
    if (times <= 0) {
      return "00:00";
    } else {
      var hh = parseInt(times / 3600); //小时
      var shh = times - hh * 3600;
      var ii = parseInt(shh / 60);
      var ss = parseInt(shh - ii * 60);
      return (ii < 10 ? "0" + ii : ii) + ":" + (ss < 10 ? "0" + ss : ss);
    }
  } else {
    return "00:00";
  }
}
