/**
数据验证（表单验证）
*/
function formValidate (data,rule) {
  for (var i = 0; i < rule.length; i++) {
    if (!rule[i].checkType) {
      return true;
    }
    if (!rule[i].name) {
      return true;
    }
    if (!rule[i].errorMsg) {
      return true;
    }
    if (!data[rule[i].name]) {
      this.error = rule[i].errorMsg;
      return false;
    }
    var reg;
    var minMax =
      rule[i] &&
      rule[i].checkRule &&
      rule[i].checkRule.split(",");
    switch (rule[i].checkType) {
      case "custom":
        if (typeof rule[i].validate == "function") {
          if (!rule[i].validate(data[rule[i].name])) {
            this.error = rule[i].errorMsg;
            return false;
          }
        }
        break;
      case "required":
        reg = new RegExp("/[S]+/");
        if (reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "string":
        reg = new RegExp("^.{" + rule[i].checkRule + "}$");
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "int":
        reg = new RegExp("^(-[1-9]|[1-9])[0-9]{" + rule[i].checkRule + "}$");
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "between":
        if (!isNumber(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        minMax[0] = Number(minMax[0]);
        minMax[1] = Number(minMax[1]);
        if (data[rule[i].name] > minMax[1] || data[rule[i].name] < minMax[0]) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "betweenD":
        reg = /^-?[1-9][0-9]?$/;
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        minMax[0] = Number(minMax[0]);
        minMax[1] = Number(minMax[1]);
        if (data[rule[i].name] > minMax[1] || data[rule[i].name] < minMax[0]) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "betweenF":
        reg = /^-?[0-9][0-9]?.+[0-9]+$/;
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        minMax[0] = Number(minMax[0]);
        minMax[1] = Number(minMax[1]);
        if (data[rule[i].name] > minMax[1] || data[rule[i].name] < minMax[0]) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "betweenS":
        if (!isNumber(data[rule[i].name].length)) {
          this.error = rule[i].errorMsg;
          return false;
        }
        minMax[0] = Number(minMax[0]);
        minMax[1] = Number(minMax[1]);
        if (data[rule[i].name].length > minMax[1] || data[rule[i].name].length < minMax[0]) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "same":
        if (data[rule[i].name] != rule[i].checkRule) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "notsame":
        if (data[rule[i].name] == rule[i].checkRule) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "email":
        reg = /^[a-z0-9]+([._\\-]*[a-z0-9])*@([a-z0-9]+[-a-z0-9]*[a-z0-9]+.){1,63}[a-z0-9]+$/;
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "phoneno":
        reg = /^1(3|4|5|6|7|8|9)\d{9}$/;
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "zipcode":
        reg = /^[0-9]{6}$/;
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "reg":
        reg = new RegExp(rule[i].checkRule);
        if (!reg.test(data[rule[i].name])) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "in":
        if (rule[i].checkRule.indexOf(data[rule[i].name]) == -1) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "notnull":
        if (
          data[rule[i].name] == 0 ||
          data[rule[i].name] == undefined ||
          data[rule[i].name] == null ||
          data[rule[i].name].length < 1
        ) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "lengthMin":
        if (data[rule[i].name].length < rule[i].checkRule) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
      case "lengthMax":
        if (data[rule[i].name].length > rule[i].checkRule) {
          this.error = rule[i].errorMsg;
          return false;
        }
        break;
    }
  }
  return true;
}

function isNumber (checkVal) {
  const reg = /^-?[1-9][0-9]?.?[0-9]*$/;
  return reg.test(checkVal);
}
