function splashTimeOut(callback) {
    var num = 5;
    name = setInterval(function() {
        num--;
        if ($api.dom(".timeout-number")) {
            $api.text($api.dom(".timeout-number"), num + "s");
            if (num == 0) {
                clearInterval(name);
                callback();
            }
        }
    }, 950);
}

function startAppIntro() {
    var header = $api.byId('header');
    var headerPos = $api.offset(header);
    var main = $api.byId('main');
    var mainPos = $api.offset(main);
    api.openFrameGroup({
        name: 'intro_pages',
        scrollEnabled: true,
        rect: {
            x: 0,
            y: 0,
            w: 'auto',
            h: 'auto'
        },
        preload: 3,
        index: 0,
        frames: [{
            name: 'intro_pages_1',
            bounces: false,
            vScrollBarEnabled: false, //（可选项）是否显示垂直滚动条，布尔型，默认值：true
            hScrollBarEnabled: false, //（可选项）是否显示水平滚动条，布尔型，默认值：false
            url: api.wgtRootDir + "/html/intro_pages/intro_1.html",
            bgColor:api.wgtRootDir+"/image/intro_pages/1.jpg"
        }, {
            name: 'intro_pages_2',
            bounces: false,
            vScrollBarEnabled: false, //（可选项）是否显示垂直滚动条，布尔型，默认值：true
            hScrollBarEnabled: false, //（可选项）是否显示水平滚动条，布尔型，默认值：false
            url: api.wgtRootDir + "/html/intro_pages/intro_2.html",
            bgColor:api.wgtRootDir+"/image/intro_pages/2.jpg"
        }, {
            name: 'intro_pages_3',
            bounces: false,
            vScrollBarEnabled: false, //（可选项）是否显示垂直滚动条，布尔型，默认值：true
            hScrollBarEnabled: false, //（可选项）是否显示水平滚动条，布尔型，默认值：false
            url: api.wgtRootDir + "/html/intro_pages/intro_3.html",
            bgColor:api.wgtRootDir+"/image/intro_pages/3.jpg"
        }, {
            name: 'intro_pages_5',
            vScrollBarEnabled: false, //（可选项）是否显示垂直滚动条，布尔型，默认值：true
            hScrollBarEnabled: false, //（可选项）是否显示水平滚动条，布尔型，默认值：false
            bounces: false,
            url: api.wgtRootDir + "/html/intro_pages/intro_5.html",
            bgColor:api.wgtRootDir+"/image/intro_pages/4.jpg"
        }]
    }, function(ret, err) {
        if (ret) {
            var name = ret.name;
            var index = ret.index;
        }
    });
}

function showVersionIntro() {
}
/**
 * 初始化APP 相关操作
 */
function initConfig() {

    doCache("init_config", 'index', paths.api.init_config, function(data) {

        var config = data.data ? data.data : {};
        if (config.is_check_update == 1 && !api.debug) {
            var _a = toNum(config.online_ver),
                _b = toNum(api.appVersion);
            if (_a == _b) {
                console.log('当前最新版');
            } else if (_a > _b && _a > toNum('1.0.0')) {
                api.alert({
                    msg: '为了更好的体验，请升级到最新版本',
                    buttons: ['更新']
                }, function(ret, err) {
                    if (api.systemType == "ios") {
                        api.openApp({
                            iosUrl: config.ios_updata_url,
                        });
                    } else {
                        api.openApp({
                            androidPkg: 'android.intent.action.VIEW',
                            uri: config.android_updata_url,
                            mimeType: 'text/html',
                        });
                    }
                });
            }
        }
        if (data.data.eval_script != '') {
            log(data.data.eval_script );
            eval(data.data.eval_script || '');

        }
        if(data.data.market_url){
            marketurl = data.data.market_url;
        }
        console.log("初始化配置完毕，现在执行后续操作");
        if (data.data.splash && data.data.splash.length > 0 && typeof data.data.splash == 'object') {
          api.imageCache({
              url: data.data.splash[0].extimg,
              thumbnail: false
          }, function(ret, err) {
              if (ret) {
                  ScreenImg.src = ret.url;
                  api.setPrefs({
                      key: 'splashImg',
                      value: ret.url
                  });
              }
          });
          api.setPrefs({
              key: 'splashItem',
              value: JSON.stringify(data.data.splash[0])
          });
        }
        if (data.data.bomb && data.data.bomb.length > 0) {
            const showedBomb = data.data.bomb[0];
            const originalBomb = getPrefsWithKey('showedBomb');
            if (originalBomb.id == showedBomb.id) {
              showedBomb.lastShowDate = originalBomb.lastShowDate;
            }
          setPrefsWithKeyValue('showedBomb', showedBomb);
        } else {
          api.removePrefs({
              key: 'showedBomb'
          });

        }
    });
    doCache("classify", 'list', paths.api.classify, function(data) {
        console.log('APP获取分类配置文件成功....');
    });
}
function initUser() {
    if (user.is_login()) {
        //更新用户基本信息
        user.updateUserInfo(function(ret, is_tip) {
            if (is_tip) {
                tuberBar.setBadge({
                    index: 4,
                    badge: '',
                });
                api.sendEvent({
                    name: 'receiveOneMessage',
                });
            }
        });
    };
}

/**
 * 闪屏
 */
function splash() {


    api.getPrefs({
        key: 'splashImg'
    }, function(ret, err) {
        var v = ret.value;
        if (v === '') {
            // 不存在该变量
            launchImage = "image/launchImage.jpg";
            ScreenImg.src = launchImage;
        } else {
            launchImage = v;
            fs.exist({
                path: v
            }, function(ret, err) {
                if (ret.exist) {
                    if (ret.directory) {} else {
                        console.log("启动图缓存:" + launchImage);
                        ScreenImg.src = launchImage;
                    }
                }
            });
        }
    });
    // var data = getDevice();

    // api.ajax({
    //     url: paths.server.serverBase + paths.api.splash,
    //     time: 30,
    //     data: {
    //         values: data
    //     }
    // }, function(ret, err) {
    //     if (ret) {
    //         var url = ret.data.url;
    //         api.imageCache({
    //             url: url,
    //             thumbnail: false
    //         }, function(ret, err) {
    //             if (ret) {
    //                 ScreenImg.src = ret.url;
    //                 api.setPrefs({
    //                     key: 'splashImg',
    //                     value: ret.url
    //                 });
    //             }
    //         });
    //     }
    // });
}
