/*
 * Cookmami JavaScript Library
 * Copyright (c) 2017 ruby
 */
// 1、app审核结果i
// 3、服务器优化参数i
// 4、优化服务器接口代码
// 5、执行满分妈妈
// 6、数据库相关优化i

var serverurl = "https://www.cookmami.com"; //服务器接口路径

var marketurl = "https://yanxuan.cookmami.com";

var new_market_url = "https://shop.cookmami.com";

var machineurl = "http://images.cookmami.com/"; //服务器路径，用于图片显示

var is_debug = false; //debug 开关

var is_Test = false; //

var socketHost = "115.29.78.45"; //tcp 通讯地址

var socketPort = "0721"; //tcp port

if (is_Test) {
  serverurl = "http://demo.cookmami.com";
  new_market_url = "http://shop.demo.cookmami.com";
  meiQiaAppKey = "266d13f5235906e7ae51326a25508b7b";

  // serverurl = "http://192.168.199.105";
  //	  serverurl = "http://www.cookmami.com";
}
var $app_config = {
  setRefreshSystel: {
    visible: true,
    loadingImg: "widget://image/loading_sprite_white.png",
    bgColor: "#f4f5f9",
    textColor: "#333",
    textDown: "下拉刷新...",
    textUp: "松开刷新...",
    showTime: true,
  },
};

var paths = {
  server: {
    userBase: serverurl + "/user",
    serverBase: serverurl + "/api",
    serverLog: serverurl + "/log",
    serverCompete: serverurl + "/compete",
    machineurl: "http://images.cookmami.com",
    activity: serverurl + "/activity",
    itemIncomeLog: serverurl + "/itemIncomeLog",
    userWebBase: serverurl + "/user_web",
  },
  api: {
    head: "/head",
    deviceInfo: "/deviceInfo",
    init_config: "/init_config",
    get_daren_list: "/get_daren_list",
    splash: "/splash",
    error: "/error",
    message: "/message",
    theme: "/theme",
    news: "/news",
    newsDetails: "/newsDetails",
    search: "/search",
    topic: "/topic",
    cook: "/cook",
    tag: "/tag",
    details: "/details",
    topicDetails: "/topicDetails",
    shareFinish: "/shareFinish",
    userIndex: "/userIndex",
    classify: "/classify",
    major: "/major",
    cookComment: "/cookComment",
    systemMsg: "/systemMsg",
    dayCook: "/dayCook",
    search_byauthor: "/search_byauthor",
    getLable: "/get_label",
  },
  good: {
    cate: "/good/cates",
    good: "/good",
    hit: "/good/hits",
  },
  compete: {
    ad: "/ad",
    share_school_log: "/share_school_log",
    visit_user_log: "/visit_user_log",
    share_user_log: "/share_user_log",
    visit_cook_log: "/visit_cook_log",
    share_cook_log: "/share_cook_log",
  },
  activity: {
    index: "/index",
    get_work: "/get_work",
    get_work_rank: "/get_work_rank",
    get_award: "/get_award",
    add_works: "/add_works",
  },
  itemIncomeLog: {
    preIncome: "/preIncome",
    orderIncomeList: "/orderIncomeList",
    monthIncome: "/monthIncome",
    incomeLogList: "/incomeLogList",
    drawbackList: "/drawbackList",
    drawback: "/drawback",
    drawback_info: "/drawback_info",
    month_list: "/month_list",
    incomeLogList_log: "/incomeLogList_log",
    incomeLogList_list: "/incomeLogList_list",
  },
  log: {
    device: "/deviceAction",
    send: "/send",
    log: "/upload",
    report: "/report",
  },
  tools: {
    view: "/view",
  },
  school: {
    index: "/index",
    details: "/details",
    pay: "/user_web/pay",
    comment: "/comment",
    log: "/log",
    share: "/share",
    RandCount: "/rand",
  },
  user: {
    getAllBabyInfo: "/getAllBabyInfo",
    userLogin: "/login",
    userLoginout: "/userLoginout",
    getUserInfo: "/getUserinfo",
    updateUserAvatar: "/updateUserAvatar",
    updateUserInfo: "/updateUserinfo",
    updateCityInfo: "/updateCityInfo",
    likesCook: "/likesCook",
    likesSchool: "/likesSchool",
    sendSum: "/sumSend",
    sendSms: "/sendsms",
    auth: "/auth",
    uploadCook: "/uploadCook",
    uploadCookDraft: "/uploadCookDraft",
    getCookDraftList: "/getCookDraftList",
    deleteCookDraft: "/deleteCookDraft",
    closeCook: "/closeCook",
    myCookList: "/getCookList",
    myLikes: "/myLikes",
    myFans: "/myFans",
    myFollow: "/myFollow",
    getCookEdit: "/getCookEdit",
    upadteCook: "/updateCook",
    maker: "/maker",
    follow: "/follow",
    unfollow: "/unfollow",
    myInfo: "/myInfo",
    myMsg: "/myMsg",
    userLoginOut: "/loginOut",
    wifiDevice: "/bindingWifiDevice",
    wifiLog: "/WifiDeviceLog",
    unbindWifiDevice: "/unbindWifiDevice",
    myCookMsg: "/myCookMsg",
    myComment: "/myComment",
    comment: "/comment",
    historyCook: "/historyCook",
    historyCookList: "/historyCookList",
    myLikesCook: "/myLikesCook",
    myLikesTopic: "/myLikesTopic",
    myLikesSchool: "/myLikesSchool",
    trends: "/trends",
    updateBabyInfo: "/updateBabyInfo",
    getBabyInfo: "/getBabyInfo",
    checkUserName: "/checkUserName", //检测用户吗是否唯一
    checkUserInfo: "/checkUserInfo", //检测用户吗是否唯一
    commentSchool: "/commentSchool",
    schoolOrder: "/mySchoolOrder",
    pay: "/pay",
    payNotify: "/payNotify",
    income: "/income_list",
    income_list: "/link_item_list",
    income_cash: "/cash_add",
    search: "/search",
    unreadMsgCount: "/myMsgCount",
    readCookMsg: "/readCookMsg",
    payment: "/payment",
    reportMallError: "/report_mall_error",
    checkBindPhone: "/checkBindPhone",
  },
  statusCode: {
    10000: "\u767b\u9646\u6210\u529f",
    10001: "\u672a\u6388\u6743toekn",
    10003: "\u767b\u9646\u8d85\u65f6",
    10004: "\u7528\u6237\u4e0d\u5b58\u5728",
    10005: "\u7528\u6237\u5df2\u88ab\u7981\u7528",
    10006: "\u6821\u9a8c\u6743\u9650\u5931\u8d25",
    10007: "\u7528\u6237\u5df2\u5b58\u5728",
  },
  miniProgram: {
    orderList: "/pages/user/index",
  },
  market: {
    userCenter: "/user/index",
  },
  moment: {
    upload: "/moment/upload",
    latest: "/moment/latest",
    likes: "/moment/likes",
    detail: "/moment/details",
    createComment: "/moment/create_comment",
    comments: "/moment/comments",
    removeComment: "/moment/remove_comment",
    trends: "/moment/trends",
    nearby: "/moment/nearby",
    my: "/moment/my",
    hot: "/moment/hot",
    related: "/moment/related",
  },
  taobao: {
    addCode: "/taobao/relation_auth",
    getRelation: "/taobao/show_relation_btn",
  },
};

/**
 * 空消息
 * @returns
 */
function empty_tpl () {
  return (
    '<div class="empty"><div class="logo"><img src="' +
    api.wgtRootDir +
    '/image/more_devices.png"></div><div class="msg">暂无内容</div> </div>'
  );
}
/**
 * 跳到顶部
 *
 */
function returnTop () {
  setTimeout(function () {
    api.pageUp(
      {
        top: true,
      },
      function (ret,err) {
        if (!ret.scrolled) {
          //已经滚动到顶部
        }
      }
    );
  },20);
}

/**
 * 缓存数据
 * @param  {[type]}   folder   [类型]
 * @param  {[type]}   id       [id]
 * @param  {[type]}   url      [请求地址]
 * @param  {Function} callback [回调]
 * @return {[type]}            [回调方法]
 */
function doCache (folder,id,url,callback,update_now,is_only_read) {
  var update_now = arguments[4] ? arguments[4] : false;
  var is_only_read = arguments[5] ? arguments[5] : false;
  var birth = arguments[6] ? arguments[6] : "";

  if (birth == "") {
    if (user.is_login()) {
      var babyInfo = user.getBabyInfo()
        ? user.getBabyInfo()
        : {
          name: "",
          birth: "",
        };
      birth = babyInfo.birth;
    }
  }
  readFile("/" + folder + "/" + id + ".data",function (ret,err) {
    if (ret.status) {
      if (typeof ret == "undefined") {
        ajaxRequest(
          url,
          "GET",
          {
            birth: birth,
          },
          function (ret,err) {
            if (ret) {
              callback(ret);
            }
          }
        );
      }
      var cacheData = ret.data;
      console.log("--------------------");
      console.log(
        "加载缓存文件:" +
        "/" +
        folder +
        "/" +
        id +
        ".data" +
        "页面:" +
        api.frameName
      );
      console.log("加载API URL:" + paths.server.serverBase + url);
      // console.log("加载缓存数据:"+cacheData);
      console.log("--------------------");
      //如果成功，说明有本地存储，读取时转换下数据格式
      //拼装json代码
      //alert('取到缓存');
      if (cacheData !== null) {
        try {
          callback(JSON.parse(cacheData));
        } catch (e) {
          // console.log("加载数据异常了:" + e.message);
          // console.log("缓存数据为:" + cacheData);
          //如果失败则从服务器读取，利用上面的那个ajaxRequest方法从服务器GET数据
          ajaxRequest(
            url,
            "GET",
            {
              birth: birth,
            },
            function (ret,err) {
              if (ret) {
                callback(ret);
                //缓存数据
                writeFile(ret,id,folder);
              }
            }
          );
        }
      }
      //再远程取一下数据，防止有更新
      if (is_only_read) {
        return;
      }
      ajaxRequest(
        url,
        "GET",
        {
          birth: birth,
        },
        function (ret,err) {
          if (ret) {
            if (cacheData != JSON.stringify(ret)) {
              //有更新处理返回数据
              // alert('更新缓存')

              if (update_now) {
                callback(ret);
                // console.log('------update' + JSON.stringify(ret));
              }
              //缓存数据
              writeFile(ret,id,folder);
              //iCache($('.cache'));
            }
          } else {
            showErrMgs(err.code,err.msg);
          }
        }
      );
    } else {
      //如果失败则从服务器读取，利用上面的那个ajaxRequest方法从服务器GET数据
      var handleErr = folder == "cookDetails";
      ajaxRequest(
        url,
        "GET",
        {
          birth: birth,
        },
        function (ret,err) {
          handleErr && callback(ret,err);
          if (ret) {
            callback(ret);
            //缓存数据
            writeFile(ret,id,folder);
          }
        },
        handleErr
      );
    }
  });
}

/**
 * 微商城接口服务器请求
 * @param  {[type]} url      [description]
 * @param  {[type]} method   [description]
 * @param  {[type]} datas    [description]
 * @param  {[type]} callBack [description]
 * @param  Boolean  handleErr 是否在回调中进行错误处理
 * @param {Boolean} server 是否使用serverurl
 * @return {[type]}          [description]
 */
function ajaxRequestMall (url,method,datas,callBack,handleErr,server) {
  var params = datas;
  // var datas = arguments[2] ? arguments[2] : {};
  var requestUrl = new_market_url + "/index.php?s=/vapi";
  datas.deviceModel = api.deviceModel;
  datas.systemType = api.systemType;
  datas.connectionType = api.connectionType;
  datas.deviceId = api.deviceId;
  datas.appVer = api.appVersion; // 比如： 1.0.0
  datas.app_uid = user.getUid();
  if (user.is_login()) {
    datas.login_uid = parseInt(user.getUid());
  }
  var sign = "";
  if (typeof params === "object") {
    Object.keys(params)
      .sort()
      .forEach(function (key) {
        sign += key + params[key];
      });
  }
  api.ajax(
    {
      url: requestUrl + url,
      method: method,
      cache: true,
      timeout: 30,
      dataType: "json",
      data: { values: datas },
      headers: {
        app_uid: user.getUid(),
        sign: MD5(sign),
      },
    },
    function (ret,err) {
      if (ret) {
        callBack(ret,err);
      } else {
        if (
          url == paths.api.cook ||
          url.indexOf(paths.api.details) > -1 ||
          handleErr
        ) {
          callBack(ret,err);
        } else {
          showErrMgs(err.code,err.msg);
        }
        console.log(
          "微商城接口：" + requestUrl + url + ";返回状态:" + err.code + err.msg
        );
      }
    }
  );
}

/**
 * 通用服务器请求
 * @param  {[type]} url      [description]
 * @param  {[type]} method   [description]
 * @param  {[type]} datas    [description]
 * @param  {[type]} callBack [description]
 * @param  Boolean  handleErr 是否在回调中进行错误处理
 * @param {Boolean} server 是否使用serverurl
 * @return {[type]}          [description]
 */
function ajaxRequest (url,method,datas,callBack,handleErr,server) {
  var datas = arguments[2] ? arguments[2] : {};
  var requestUrl = server ? serverurl : paths.server.serverBase;
  datas.deviceModel = api.deviceModel;
  datas.systemType = api.systemType;
  datas.connectionType = api.connectionType;
  datas.deviceId = api.deviceId;
  datas.appVer = api.appVersion; // 比如： 1.0.0
  if (user.is_login()) {
    datas.login_uid = parseInt(user.getUid());
  }
  console.log(
    "接口请求：" + paths.server.serverBase + url + "?" + urlEncode(datas)
  );
  api.ajax(
    {
      url: requestUrl + url,
      method: method,
      cache: true,
      timeout: 30,
      dataType: "json",
      data: {
        values: datas,
      },
    },
    function (ret,err) {
      if (ret) {
        callBack(ret,err);
      } else {
        if (
          url == paths.api.cook ||
          url.indexOf(paths.api.details) > -1 ||
          handleErr
        ) {
          callBack(ret,err);
        } else {
          // hideHomeIndicator 属性
          // api.hideHomeIndicator()
          showErrMgs(err.code,err.msg);
        }
        console.log(
          "请求URL:" +
          paths.server.serverBase +
          url +
          ";返回状态:" +
          err.code +
          err.msg
        );
      }
    }
  );
}

/**
 * 读取文件
 * @param  {[type]} path     [description]
 * @param  {[type]} callBack [description]
 * @return {[type]}          [description]
 */
function readFile (path,callBack) {
  var cacheDir = api.cacheDir;
  api.readFile(
    {
      path: cacheDir + path,
    },
    function (ret,err) {
      callBack(ret,err);
    }
  );
}
/**
 * 写入文件
 * @param  {[type]} json [description]
 * @param  {[type]} id   [description]
 * @param  {[type]} path [description]
 * @return {[type]}      [description]
 */
function writeFile (json,id,path) {
  //缓存目录
  var cacheDir = api.cacheDir;
  api.writeFile(
    {
      //保存路径
      path: cacheDir + "/" + path + "/" + id + ".data",
      //保存数据，记得转换格式
      data: JSON.stringify(json),
    },
    function (ret,err) { }
  );
}
/**


/*判断数组值是否存在*/
function isCon (arr,val) {
  for (var i = 0; i < arr.length; i++) {
    if (arr[i] == val) return true;
  }
  return false;
}
/*
 * CookClass
 * ruby
 * 2016/01/23
 */
(function () {
  "use strict";
  var cook = {};
  cook.major = function (name) {
    if (name == "") {
      api.alert({
        title: "系统提示",
        msg: "没有匹配到食材内容",
      });
      return;
    }
    api.openWin({
      name: "major_view_" + name,
      url: api.wgtRootDir + "/html/win_cook_major.html",
      delay: 300,
      pageParam: {
        name: name,
      },
    });
  };
  cook.dayCook = function () {
    // api.openWin({
    // 	name: 'daydayCook',
    // 	url: api.wgtRootDir + '/html/day/win_index.html',
    // 	delay: 300,
    // 	pageParam: {

    // 	}
    // });
    api.openFrame({
      name: "daydayCook",
      url: api.wgtRootDir + "/html/day/frm_index.html",
      bounces: false,
      delay: 200,
      rect: {
        x: 0,
        y: 0,
        w: "auto",
        h: "auto",
      },
    });
  };

  cook.myCooksTemp = function () {
    api.openWin({
      name: "winMyCooksTemp",
      url: api.wgtRootDir + "/html/user/win_drafts.html",
      delay: 300,
      pageParam: {},
    });
  };

  cook.edit = function (id) {
    var fromDraft = arguments[1] || false;
    var fromCacheCook = arguments[2] || false;
    if (typeof id === undefined) {
      api.alert({
        title: "提示",
        msg: "编辑初始化失败",
      });
      return;
    }
    if (!user.is_login()) {
      user.login("publish");
      return;
    }
    api.openWin({
      name: "cookUpload",
      url: api.wgtRootDir + "/html/cook/win_upload.html",
      bounces: false,
      pageParam: {
        id: id,
        fromDraft: fromDraft,
        fromCacheCook: fromCacheCook,
      },
      slidBackEnabled: false,
      delay: 300,
    });
  };
  cook.delete = function (id,callback) {
    if (typeof id === undefined) {
      api.alert({
        title: "提示",
        msg: "非法删除，无效操作",
      });
      return;
    }
    if (!user.is_login()) {
      user.login();
      return;
    }
    user.request(
      paths.user.closeCook,
      {
        id: id,
      },
      function (ret,err) {
        console.log("删除菜谱成功:" + id);
        if (typeof callback === "function") {
          callback(ret,err);
        }
      },
      true
    );
  };
  cook.upload = function () {
    if (!user.is_login()) {
      user.login("publish");
      return;
    }
    var classify = false;
    if (api.systemType != "ios") {
      classify = true;
    }
    var UIAlbumBrowser = api.require("UIAlbumBrowser");
    setApp("photos",function () {
      UIAlbumBrowser.open(
        {
          type: "image",
          styles: {
            bg: "#fff",
            mark: {
              icon: "",
              position: "bottom_left",
            },
            nav: {
              bg: "rgb(193, 149, 123)",
              titleColor: "#333",
              titleSize: 18,
              cancelColor: "#fff",
              cancelSize: 16,
              finishBg: "#f7da6d",
              finishColor: "rgb(151,110,63)",
              finishSize: 16,
            },
          },
        },
        function (ret) {
          if (ret) {
            if (ret.eventType == "confirm") {
              api.openWin({
                name: "cookUpload",
                url: api.wgtRootDir + "/html/cook/win_upload.html",
                bounces: false,
                pageParam: {
                  data: ret,
                },
                slidBackEnabled: false,
                delay: 300,
              });
              console.log("初始化上传，相册图片加载完毕");
            }
          }
        }
      );
    });
  };
  cook.finished = function (id) {
    api.openWin({
      name: "cook_finished",
      url: api.wgtRootDir + "/html/cook/win_fulfil.html",
      bounces: false,
      bgColor: "#fff",
      slidBackEnabled: false,
      pageParam: {
        id: id,
      },
      delay: 300,
    });
  };
  cook.look = function (id) {
    api.openWin({
      name: "cook_finished",
      url: api.wgtRootDir + "/html/cook/win_fulfil.html",
      bounces: false,
      bgColor: "#fff",
      slidBackEnabled: false,
      pageParam: {
        id: id,
      },
      delay: 300,
    });
  };
  cook.forapp = function () {
    api.openWin({
      name: "spot_screenshot_forapp_red",
      url: api.wgtRootDir + "/html/cook_frm_details_img.html",
      hScrollBarEnabled: false,
      vScrollBarEnabled: false,
      bounces: false,
      pageParam: {
        key: "value",
      },
    });
  };

  cook.history = function () {
    api.openWin({
      name: "cookHistory",
      url: api.wgtRootDir + "/html/win_history.html",
      hScrollBarEnabled: false,
      vScrollBarEnabled: false,
      bounces: false,
      pageParam: {},
    });
  };

  cook.addHistory = function (item) {
    var uid = user.getUid();
    if (typeof item === "undefined" || !uid) {
      console.log("非法菜谱");
      return;
    }
    var _history_cook = $api.getStorage("_history_cook_" + uid) || [];
    if (_history_cook.length == 0) {
      _history_cook.push(item);
      $api.setStorage("_history_cook_" + uid,_history_cook);
    } else {
      for (var i = 0; i < _history_cook.length; i++) {
        if (_history_cook[i].id == item.id) {
          _history_cook.splice(i,1);
          // $api.setStorage("_history_cook", temp);
        }
      }
      _history_cook.push(item);
      $api.setStorage("_history_cook_" + uid,_history_cook);
    }
    // user.request(paths.user.historyCook, {
    // 	cook_id: item,
    // }, function(ret) {
    // 	console.log('访问菜谱记录成功菜谱ID:' + id);
    // });
  };
  cook.is_like = function (id) {
    if (id === undefined) {
      console.log("不存在的菜谱");
      return false;
    }
    var likeCookList = $api.getStorage("_like_cook") || [];
    for (var i = 0; i < likeCookList.length; i++) {
      if (likeCookList[i].id == id) {
        return true;
      }
    }
  };
  cook.addLike = function (obj) {
    if (obj.id === undefined) {
      console.log("不存在的菜谱");
      return false;
    }
    var likeCookList = $api.getStorage("_like_cook") || [];
    for (var i = 0; i < likeCookList.length; i++) {
      if (likeCookList[i].id == obj.id) {
        cook.delLike(obj.id);
        api.toast({
          msg: "取消收藏成功",
          duration: 2000,
          location: "top",
        });
        return false;
      }
    }
    likeCookList.push(obj);
    api.sendEvent({
      name: "likeFinish",
    });
    $api.setStorage("_like_cook",likeCookList);
    return true;
  };
  cook.delLike = function (id) {
    if (id !== undefined) {
      var likeCookList = $api.getStorage("_like_cook") || [];
      var list = [];
      for (var i = 0; i < likeCookList.length; i++) {
        if (likeCookList[i].id != id) {
          list.push(likeCookList[i]);
        }
      }
      api.sendEvent({
        name: "likeCancel",
      });
      $api.setStorage("_like_cook",list);
    }
  };
  cook.getLike = function (obj) {
    return $api.getStorage("_like_cook") || [];
  };

  cook.tag = function (id,is_cloud) {
    var rand = arguments[0] ? arguments[0] : "";
    var is_cloud = arguments[1] ? arguments[1] : 0;
    var is_age = arguments[2] ? arguments[2] : false;
    var age_id = arguments[3] ? arguments[3] : 0;
    var age_name = arguments[4] ? arguments[4] : null;
    api.openWin({
      name: "cook_win_tag" + rand,
      url: api.wgtRootDir + "/html/cook_win_tag.html",
      delay: 250,
      bounces: false,
      pageParam: {
        id: id,
        is_cloud: is_cloud,
        is_age: is_age,
        age_id: age_id,
        age_name: age_name,
      },
    });
  };

  cook.topic = function (id) {
    api.openWin({
      name: "cooklist",
      url: api.wgtRootDir + "/html/cook_win_list.html",
      delay: 300,
      bounces: false,
      pageParam: {
        id: id,
      },
    });
  };

  cook.view = function (id) {
    if (!id) return;
    var is_tools = arguments[1] ? arguments[1] : false;
    var is_jump = arguments[2] ? arguments[2] : false;
    api.openWin({
      name: "cookWinDetails_" + id,
      url: api.wgtRootDir + "/html/cook_win_details.html",
      delay: 250,
      bounces: false,
      hideHomeIndicator: true,
      pageParam: {
        id: id,
        is_tools: is_tools,
        is_jump: is_jump,
      },
    });
  };
  cook.replyComment = function (comment) {
    api.openWin({
      name: "cookReplyComment",
      url: api.wgtRootDir + "/html/msg/win_reply_comment.html",
      delay: 250,
      bounces: false,
      hideHomeIndicator: true,
      pageParam: {
        comment: comment,
      },
    });
  };
  window.cook = cook;
})();

/*
 * school
 * ruby
 * 2016/01/23
 */
(function () {
  "use strict";
  var school = {};

  school.index = function (age) {
    api.openWin({
      name: "schoolIndex",
      url: api.wgtRootDir + "/html/school/win_index.html",
      bounces: false,
      pageParam: {
        age: age,
      },
    });
  };

  school.view = function (id,r) {
    // api.closeWin({
    //   name: 'WebView'
    // });
    var data = {
      id: id,
    };
    r && (data.read = r);
    api.openWin({
      name: "schoolDetailWin",
      delay: 100,
      url: api.wgtRootDir + "/html/school/win_detail.html",
      bounces: false,
      pageParam: data,
    });
  };

  school.pay = function (id,code) {
    var y = 40;
    if (api.systemType == "ios") {
      y = 60;
    }
    api.openFrame({
      name: "paySchoolFrm",
      url: api.wgtRootDir + "/html/school/frm_pay.html",
      rect: {
        x: 0,
        y: y,
        w: "auto",
        h: "auto",
      },
      pageParam: {
        id: id,
        isCode: !!code,
        // price: price
      },
      bounces: false,
    });
  };
  /**
   * 收藏和取消喜欢的
   * @return {[type]} [description]
   */
  school.comment = function (id,content,atuid,callback) {
    if (typeof id !== undefined) {
      user.request(
        paths.user.commentSchool,
        {
          school_id: id,
          content: content,
          atuid: atuid,
        },
        function (ret) {
          callback(ret);
          console.log("评论萌酱酱选学院成功:" + id);
        }
      );
    } else {
      api.alert({
        title: "提示",
        msg: "评论失败",
      });
    }
  };
  school.share = function (id) { };

  school.order = function () {
    if (!user.is_login()) {
      return;
    }
    api.openWin({
      name: "schoolOrderWin",
      url: api.wgtRootDir + "/html/user/win_school_order.html",
      bounces: false,
      pageParam: {},
    });
  };

  window.school = school;
})();

/*
 * school
 * ruby
 * 2016/01/23
 */
(function () {
  "use strict";
  var goods = {};

  goods.view = function (id,r) {
    api.openWin({
      name: "goodsDetailWin",
      delay: 300,
      url: api.wgtRootDir + "/html/goods/win_detail.html",
      bounces: false,
      pageParam: {
        id: id,
      },
    });
  };

  goods.hit = function (cookId,goodId,id,type) {
    api.ajax(
      {
        url: serverurl + paths.good.hit,
        method: "post",
        timeout: 30,
        dataType: "json",
        returnAll: false,
        data: {
          values: {
            deviceId: api.deviceId,
            cookId: cookId,
            goodId: goodId,
            field: "hits",
            id: id,
            type: type,
          },
        },
      },
      function (ret,err) {
        if (ret) {
          // TODO
          console.log(ret.message);
        } else {
          // showErrMgs(err.code, err.msg);
        }
      }
    );
  };

  goods.order = function () {
    if (!user.is_login()) {
      return;
    }
    api.openWin({
      name: "schoolOrderWin",
      url: api.wgtRootDir + "/html/goods/win_school_order.html",
      bounces: false,
      pageParam: {},
    });
  };

  window.goods = goods;
})();

function get_tpl_html (ret,tpl,dom,callback) {
  var update_now = arguments[4] ? arguments[4] : false;
  if (ret) {
    var gettpl = document.getElementById(tpl).innerHTML;
    var data = ret.data || [];
    laytpl(gettpl).render(data,function (html) {
      var doc = $api.byId(dom);
      if (!update_now) {
        $api.append(doc,html);
      } else {
        doc.innerHTML = html;
      }

      LazyLoad.init();
      callback(html);
      if (!typeof api === "undefined") {
        api.parseTapmode();
      }
      //防止图片因网络不好导致加载失败，再次加载图片
      setTimeout(function () {
        LazyLoad.init();
      },5000);
      // alert(html);
    });
  } else {
    api.alert({
      title: "出现错误，请联系APP官方人员",
    });
  }
}

/**
 * 网络错误通用提示框
 */
function showErrMgs (code,msg) {
  var message;
  switch (parseInt(code)) {
    case 0:
      message = "网络无法连接\n请检查网络配置";
      break;
    case 1:
      message = "网络请求超时\n";
      break;
  }
  api.toast({
    msg: msg || message,
    duration: 2000,
    location: "top",
  });
}
/*
 * 向控制台输出日志
 * @param  data data  要输出的日志
 * @return string
 */
function log (data) {
  if (!is_debug) {
    return;
  }
  if (typeof data == "string") {
    console.log(data);
  } else {
    alert(JSON.stringify(data));
    console.log(JSON.stringify(data));
  }
}

//替换所有的回车换行
function TransferString (content) {
  var string = content;
  try {
    string = string.replace(/\r\n/g,"<BR>");
    string = string.replace(/\n/g,"<BR>");
  } catch (e) {
    // alert(e.message);
  }
  return string;
}

/*
 * webview Class
 * ruby
 * 2016/01/23
 */
(function () {
  "use strict";

  var webview = {};

  webview.init = function (url) {
    if (!user.is_login()) {
      user.main();
      return;
    }
    // var browser = api.require('webBrowser');
    // browser.open({
    //   url: url,
    //   titleBar: {
    //     bg: '#fff',
    //     textColor: '#333'
    //   }
    // });
    var url = arguments[0] ? arguments[0] : "https://www.cookmami.com";
    api.openWin({
      name: "WebView_x5",
      url: api.wgtRootDir + "/html/win_webview_x5.html",
      bounces: false,
      bgColor: "#fff",
      slidBackEnabled: false,
      pageParam: {
        url: url,
      },
    });
  };
  webview.view = function () {
    // if (!user.is_login()) {
    //     user.main();
    //     return;
    // }
    var url = arguments[0] ? arguments[0] : "https://www.cookmami.com";
    if (url.indexOf(new_market_url) >= 0) {
      webview.init(url);
      return;
    }
    api.openWin({
      name: "WebView",
      url: api.wgtRootDir + "/html/win_webview.html",
      bounces: false,
      bgColor: "#fff",
      slidBackEnabled: false,
      pageParam: {
        url: url,
      },
    });
  };

  webview.back = function () { };

  window.webview = webview;
})();

/*
 * Log Class
 * 2016/12/05
 */
(function () {
  "use strict";

  var l = {};

  log.get_device_base = function () {
    var device = {};
    device.version = api.version;
    device.systemType = api.systemType;
    device.systemVersion = api.systemVersion;
    device.deviceId = api.deviceId;
    device.appVersion = api.appVersion;
    device.deviceToken = api.deviceToken;
    device.deviceModel = api.deviceModel;
    device.deviceName = api.deviceName;
    device.connectionType = api.connectionType;
    device.operator = api.operator;
    device.screenWidth = api.screenWidth;
    device.screenHeight = api.screenHeight;
    device.winName = api.winName;
    device.frameName = api.frameName; //比如： trans-con
    device.pageParam = api.pageParam;
    device.channel = api.channel;
    //获取相关信息
    if (user.is_login()) {
      device.username = user.getUsername();
      device.useruid = user.getUid();
      device.login_uid = device.useruid;
    }
    return device;
  };

  log.send = function (text,extra,status,callback) {
    if (typeof callback === "function") {
      api.sendEvent({
        name: "log",
        extra: {
          data: data,
        },
      });
    }
  };
  log.error = function () { };

  window.log4 = log;
})();

/*
 * User Class
 * ruby
 * 2016/02/20
 */
(function () {
  "use strict";

  var user = {};

  /**
   * 判断用户是否登陆
   */
  user.is_login = function () {
    var uid = api.getPrefs({
      sync: true,
      key: "uid",
    });
    if (!uid) {
      return false;
    } else {
      return true;
    }
  };

  user.local = function () {
    var ls_prefix = "mengzhu_";
    var ls = window.localStorage;
    if (arguments.length == 1) {
      var v = ls.getItem(ls_prefix + arguments[0]);
      if (!v) {
        return;
      }
      if (v.indexOf("obj-") === 0) {
        v = v.slice(4);
        return JSON.parse(v);
      } else if (v.indexOf("str-") === 0) {
        return v.slice(4);
      }
    } else if (arguments.length == 2) {
      var key = ls_prefix + arguments[0];
      var v = arguments[1];
      if (typeof v == "object") {
        v = JSON.stringify(v);
        v = "obj-" + v;
      } else {
        v = "str-" + v;
      }
      if (ls) {
        ls.setItem(key,v);
      }
    }
  };

  user.is_login_callback = function (callback) {
    api.getPrefs(
      {
        key: "uid",
      },
      function (ret,err) {
        if (ret) {
          var uid = ret.value;
          if (uid) {
            api.getPrefs(
              {
                key: "token",
              },
              function (ret,err) {
                if (ret) {
                  callback(uid,ret.value);
                }
              }
            );
          }
        }
      }
    );
  };

  /**
   * 用户请求处理
   * @param  {[type]}   type      请求地址
   * @param  {[type]}   pageParam [数据]
   * @param  {Function} callback  [回调方法]
   * @return {[type]}             [返回值]
   */
  user.require = function (
    type,
    pageParam,
    callback,
    files,
    forbidHideProcess
  ) {
    var that = this;
    if (user.is_login()) {
      var token = this.getToken();
      var uid = this.getUid();
      console.log("用户请求:" + paths.server.userBase + type);
      if (token !== undefined) {
        var datas = pageParam;
        datas.appVer = api.appVersion;
        datas.systemType = api.systemType;
        datas.deviceId = api.deviceId;
        datas.token = token;
        datas.uid = uid;
        datas.deviceModel = api.deviceModel;
        datas.systemVersion = api.systemVersion;
        datas.systemType = api.systemType;
        datas.appVersion = api.appVersion;
        datas.operator = api.operator; // 比如:中国移动
        datas.connectionType = api.connectionType; //比如: wifi
        datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
        // log(datas);

        api.ajax(
          {
            url: paths.server.userBase + type,
            method: "post",
            timeout: 90,
            dataType: "json",
            returnAll: false,
            data: {
              values: datas,
              files: files,
            },
          },
          function (ret,err) {
            if (!forbidHideProcess) {
              api.hideProgress();
            }
            if (ret) {
              console.log("-------------请求接口开始-------------");
              console.log(
                "用户请求:" +
                paths.server.userBase +
                type +
                "?" +
                urlEncode(datas)
              );
              // console.log(JSON.stringify(ret));
              console.log("-------------请求接口成功-------------");
              //请求成功时
              if (ret.status == 10010) {
                if (typeof callback === "function") {
                  var userInfo = ret.data;
                  if (type == paths.user.updateUserInfo) {
                    userInfo.token = that.getToken();
                  }
                  //设置APP 登陆状态
                  that.setUser(userInfo);
                  api.sendEvent({
                    name: "updateUser",
                  });
                  callback(ret);
                }
              } else if (ret.status == 10001) {
                api.sendEvent({
                  name: "userLoginPut",
                });
                console.log("更新数据出错，请稍后重试，错误状态" + ret.status);
                api.hideProgress();
                // } else if (ret.status == 10011) {
              } else {
                api.hideProgress();
                api.alert({
                  title: "提示",
                  msg: ret.message,
                });
              }
            } else {
              // console.log(JSON.stringify(ret));
              // showErrMgs(err.code, err.msg);
              console.log("-------------请求接口失败-------------");
              console.log(
                "用户请求:" +
                paths.server.userBase +
                type +
                "?" +
                urlEncode(datas)
              );
              console.log(JSON.stringify(err));
              console.log("-------------请求接口失败-------------");
              api.alert({
                title: "系统提示",
                msg: "更新数据出错，请稍后重试" + err.msg,
              });
              api.hideProgress();
            }
            api.sendEvent({
              name: "isUploadIngChangge",
            });
          }
        );
      } else {
        api.sendEvent({
          name: "is_login_status",
        });
        api.alert({
          title: "系统错误TOKEN无效",
          msg: "请退出重新登录",
        });
        that.loginOut();
        api.sendEvent({
          name: "userLoginOut",
        });
        api.sendEvent({
          name: "updateUser",
        });
      }
    } else {
      console.log("未登录用户，更新失败");
    }
  };

  user.taobaoRequire = function (type,pageParam,callback,forbidHideProcess) {
    var that = this;
    if (user.is_login()) {
      var token = this.getToken();
      var uid = this.getUid();
      if (token !== undefined) {
        var datas = pageParam;
        datas.user_id = uid;
        console.log(JSON.stringify(datas),"登录信息数据实时更新");
        api.ajax(
          {
            url: serverurl + type,
            method: "post",
            timeout: 90,
            dataType: "json",
            returnAll: false,
            data: {
              values: datas,
            },
          },
          function (ret,err) {
            console.log(JSON.stringify(ret));
            if (!forbidHideProcess) {
              api.hideProgress();
            }
            if (ret) {
              //请求成功时
              callback(ret);
            } else {
              // console.log(JSON.stringify(ret));
              // showErrMgs(err.code, err.msg);
              console.log("-------------请求接口失败-------------");
              console.log(
                "用户请求:" +
                paths.server.userBase +
                type +
                "?" +
                urlEncode(datas)
              );
              console.log(JSON.stringify(err));
              console.log("-------------请求接口失败-------------");
              api.alert({
                title: "系统提示",
                msg: "更新数据出错，请稍后重试" + err.msg,
              });
              api.hideProgress();
            }
            api.sendEvent({
              name: "isUploadIngChangge",
            });
          }
        );
      } else {
        api.sendEvent({
          name: "is_login_status",
        });
        api.alert({
          title: "系统错误TOKEN无效",
          msg: "请退出重新登录",
        });
        that.loginOut();
        api.sendEvent({
          name: "userLoginOut",
        });
        api.sendEvent({
          name: "updateUser",
        });
      }
    } else {
      console.log("未登录用户，更新失败");
    }
  };

  /**
   * 用户请求处理
   * @param  {[type]}   type      请求地址
   * @param  {[type]}   pageParam [数据]
   * @param  {Function} callback  [回调方法]
   * @return {[type]}             [返回值]
   */
  user.requireForDraft = function (type,pageParam,callback,files) {
    var that = this;
    if (user.is_login()) {
      var token = this.getToken();
      var uid = this.getUid();
      console.log(JSON.stringify(pageParam),"fdfndfhuhu");
      console.log("用户请求:" + paths.server.userBase + type);
      if (token !== undefined) {
        var datas = pageParam;
        datas.appVer = api.appVersion;
        datas.systemType = api.systemType;
        datas.deviceId = api.deviceId;
        datas.token = token;
        datas.uid = uid;
        datas.deviceModel = api.deviceModel;
        datas.systemVersion = api.systemVersion;
        datas.systemType = api.systemType;
        datas.appVersion = api.appVersion;
        datas.operator = api.operator; // 比如:中国移动
        datas.connectionType = api.connectionType; //比如: wifi
        datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
        // log(datas);

        api.ajax(
          {
            url: paths.server.userBase + type,
            method: "post",
            timeout: 90,
            dataType: "json",
            returnAll: false,
            data: {
              values: datas,
              files: files,
            },
          },
          function (ret,err) {
            api.hideProgress();
            if (ret) {
              //请求成功时
              if (ret.status == 1) {
                callback(ret);
              } else if (ret.status == 10010) {
                if (typeof callback === "function") {
                  var userInfo = ret.data;
                  if (type == paths.user.updateUserInfo) {
                    userInfo.token = that.getToken();
                  }
                  //设置APP 登陆状态
                  that.setUser(userInfo);
                  api.sendEvent({
                    name: "updateUser",
                  });
                }
              } else if (ret.status == 10001) {
                api.sendEvent({
                  name: "userLoginPut",
                });
                console.log("更新数据出错，请稍后重试，错误状态" + ret.status);
                api.hideProgress();
                // } else if (ret.status == 10011) {
              } else {
                api.alert({
                  title: "提示",
                  msg: ret.message,
                });
              }
            } else {
              // console.log(JSON.stringify(ret));
              // showErrMgs(err.code, err.msg);
              console.log("-------------请求接口失败-------------");
              console.log(
                "用户请求:" +
                paths.server.userBase +
                type +
                "?" +
                urlEncode(datas)
              );
              console.log(JSON.stringify(err));
              console.log("-------------请求接口失败-------------");
              api.alert({
                title: "系统提示",
                msg: "更新数据出错，请稍后重试" + err.msg,
              });
              api.hideProgress();
            }
            api.sendEvent({
              name: "isUploadIngChangge",
            });
          }
        );
      } else {
        api.sendEvent({
          name: "is_login_status",
        });
        api.alert({
          title: "系统错误TOKEN无效",
          msg: "请退出重新登录",
        });
        that.loginOut();
        api.sendEvent({
          name: "userLoginOut",
        });
        api.sendEvent({
          name: "updateUser",
        });
      }
    } else {
      console.log("未登录用户，更新失败");
    }
  };

  /**
   * 用户通用请求处理
   * @param  {[type]}   type      请求地址
   * @param  {[type]}   pageParam [数据]
   * @param  {Function} callback  [回调方法]
   * @param  {[type]}   err       [是否自行做处理]
   * @param {string} url [baseurl是否更改]
   * @return {[type]}             [返回值]
   */
  user.request = function (type,pageParam,callback,errSelf,baseurl) {
    var that = this;
    if (!user.is_login()) {
      console.log("非法本次请求：" + token);
      console.log("非法本次请求：" + uid);
      api.alert({
        title: "提示",
        msg: "未登录用户，非法请求" + type + ",frameName：" + api.frameName,
      });
      api.hideProgress();
      return;
    }
    console.log(paths.server.userBase + type);
    console.log(baseurl);
    var token = this.getToken();
    var uid = this.getUid();
    // console.log(baseurl);
    if (typeof token != "undefined") {
      var datas = pageParam;
      datas.deviceId = api.deviceId;
      datas.token = token;
      datas.uid = uid;
      datas.deviceModel = api.deviceModel;
      datas.systemVersion = api.systemVersion;
      datas.systemType = api.systemType;
      datas.appVersion = api.appVersion;
      datas.operator = api.operator; // 比如:中国移动
      datas.connectionType = api.connectionType; //比如: wifi
      datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
      api.ajax(
        {
          url: baseurl ? baseurl + type : paths.server.userBase + type,
          method: "get",
          timeout: 30,
          cache: true,
          dataType: "json",
          returnAll: false,
          data: {
            values: datas,
          },
        },
        function (ret,err) {
          if (ret) {
            console.log("-------------请求接口开始-------------");
            console.log(
              "请求地址:" +
              paths.server.userBase +
              type +
              "?" +
              urlEncode(datas)
            );
            // console.log(JSON.stringify(ret));
            console.log("-------------请求接口成功-------------");
            //请求成功时
            // 更新用户信息时， 更新缓存中的用户信息
            if (type == paths.user.updateUserInfo) {
              var userInfo = ret.data;
              if (userInfo) {
                userInfo.token = that.getToken();
                //设置APP 登陆状态
                that.setUser(userInfo);
                api.sendEvent({
                  name: "updateUser",
                });
              }
            }
            if (ret.status == 10010 || ret.status == 1) {
              if (typeof callback === "function") {
                callback(ret);
              }
            } else if (ret.status == 10001) {
              api.sendEvent({
                name: "userLoginPut",
              });
              api.hideProgress();
            } else if (ret.status == 10011) {
              api.sendEvent({
                name: "request_fail",
                extra: {
                  code: 10011,
                  type: type,
                  msg: ret.message,
                },
              });
              if (errSelf) {
                callback(ret,true);
              }
            } else if (ret.status == 10013) {
              api.sendEvent({
                name: "request_fail",
                extra: {
                  code: 10011,
                  type: type,
                  msg: ret.message,
                },
              });
            } else {
              api.hideProgress();
              if (type == paths.user.follow || type == paths.user.unfollow) {
              }
              if (ret.status == 0 && type == paths.user.getBabyInfo) {
                return;
              }
              api.toast({
                msg: ret.message,
                duration: 2000,
                location: "top",
              });
              console.log("更新数据出错，请稍后重试，错误状态" + ret.status);
            }
          } else {
            // api.toast({
            // 	msg: "由于以" + err.msg + "原因，请求失败",
            // 	duration: 3000,
            // 	location: 'bottom'
            // });
            console.log("-------------请求接口出错开始-------------");
            console.log(JSON.stringify(err));
            console.log("-------------请求接口出错结束-------------");
            errSelf && callback(ret,err);
            if (!errSelf) {
              api.toast({
                msg: err.msg,
                duration: 3000,
                location: "bottom",
              });
            }
            //上报服务器
            api.hideProgress();
            api.sendEvent({
              name: "request_fail",
              extra: {
                code: err.code,
                type: type,
              },
            });
          }
        }
      );
    } else {
      api.sendEvent({
        name: "userLoginOut",
      });
    }
  };

  /**
   * 用户通用请求处理
   * @param  {[type]}   type      请求地址
   * @param  {[type]}   pageParam [数据]
   * @param  {Function} callback  [回调方法]
   * @return {[type]}             [返回值]
   */
  user.wkRequest = function (type,pageParam,callback) {
    var that = this;
    var token = pageParam.token;
    var uid = pageParam.uid;
    if (typeof token != "undefined") {
      var datas = pageParam;
      datas.deviceId = api.deviceId;
      datas.token = token;
      datas.uid = uid;
      datas.deviceModel = api.deviceModel;
      datas.systemVersion = api.systemVersion;
      datas.systemType = api.systemType;
      datas.appVersion = api.appVersion;
      datas.operator = api.operator; // 比如:中国移动
      datas.connectionType = api.connectionType; //比如: wifi
      datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
      api.ajax(
        {
          url: paths.server.userBase + type,
          method: "get",
          timeout: 30,
          cache: true,
          dataType: "json",
          returnAll: false,
          data: {
            values: datas,
          },
        },
        function (ret,err) {
          if (ret) {
            console.log("-------------请求接口开始-------------");
            console.log(
              "请求地址:" +
              paths.server.userBase +
              type +
              "?" +
              urlEncode(datas)
            );
            // console.log(JSON.stringify(ret));
            console.log("-------------请求接口成功-------------");
            //请求成功时
            if (ret.status == 10010) {
              if (typeof callback === "function") {
                callback(ret);
              }
            } else if (ret.status == 10001) {
              api.sendEvent({
                name: "userLoginPut",
              });
              api.hideProgress();
            } else if (ret.status == 10011) {
              api.sendEvent({
                name: "request_fail",
              });
            } else {
              if (type == paths.user.follow || type == paths.user.unfollow) {
              }
              api.toast({
                msg: ret.message,
                duration: 2000,
                location: "top",
              });
              console.log("更新数据出错，请稍后重试，错误状态" + ret.status);
              api.hideProgress();
            }
          } else {
            // api.toast({
            // 	msg: "由于以" + err.msg + "原因，请求失败",
            // 	duration: 3000,
            // 	location: 'bottom'
            // });
            console.log("-------------请求接口出错开始-------------");
            console.log(JSON.stringify(err));
            console.log("-------------请求接口出错结束-------------");
            //上报服务器
            api.hideProgress();
            api.sendEvent({
              name: "request_fail",
              extra: {
                code: err.code,
                type: type,
              },
            });
          }
        }
      );
    } else {
      api.sendEvent({
        name: "userLoginOut",
      });
    }
  };

  /**
   * 用户通用请求处理
   * @param  {[type]}   type      请求地址
   * @param  {[type]}   pageParam [数据]
   * @param  {Function} callback  [回调方法]
   * @return {[type]}             [返回值]
   */
  user.avatarImg = function (file,callback) {
    var that = this;
    if (user.is_login()) {
      var token = this.getToken();
      var uid = this.getUid();
      console.log(
        "用户请求:" + paths.server.userBase + paths.user.updateUserAvatar
      );
      if (token !== undefined) {
        var datas = {};
        datas.deviceId = api.deviceId;
        datas.token = token;
        datas.uid = uid;

        console.log(JSON.stringify(datas));
        // alert(file);
        api.ajax(
          {
            url: paths.server.userBase + paths.user.updateUserAvatar,
            method: "post",
            timeout: 30,
            dataType: "json",
            returnAll: false,
            data: {
              values: datas,
              files: {
                upfile: file,
              },
            },
          },
          function (ret,err) {
            if (ret) {
              // TODO
              //请求成功时
              if (ret.status == 10010) {
                var userInfo = ret.data;
                if (typeof callback === "function") {
                  //设置APP 登陆状态
                  that.setUser(userInfo);
                  api.toast({
                    msg: "更新成功",
                    duration: 2000,
                    location: "top",
                  });
                  api.sendEvent({
                    name: "updateUser",
                  });
                  callback(ret);
                }
              } else {
                api.alert({
                  title: "系统提示",
                  msg: "更新数据出错，请稍后重试" + ret.message,
                });
              }
            } else {
              showErrMgs(err.code,err.msg);
            }
          }
        );
      } else {
        api.alert({
          title: "系统提示",
          msg: "请退出重新登录",
        });
        that.loginOut();
      }
    } else {
      console.log("未登录用户，更新失败");
    }
  };

  /**
   * 关注和取消喜欢的
   * @return {[type]} [description]
   */
  user.likesCook = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    var id = arguments[0] ? arguments[0] : "";
    var type = arguments[1] ? arguments[1] : "cook";
    if (typeof id !== undefined) {
      user.request(
        paths.user.likesCook,
        {
          id: id,
          type: type,
        },
        function (ret,err) {
          if (err) {
            api.alert(
              {
                title: "提示",
                msg: "设置收藏失败",
              },
              function (ret,err) { }
            );
            api.sendEvent({
              name: "like_request_fail",
            });
            return;
          }
          if (ret.data.likes == 0) {
            api.sendEvent({
              name: "likeCancel",
              extra: {
                id: id,
              },
            });
          } else {
            api.sendEvent({
              name: "likeFinish",
              extra: {
                id: id,
              },
            });
          }
          console.log("收藏菜谱成功:" + id);
        },
        true
      );
    } else {
      api.alert({
        title: "提示",
        msg: "设置收藏失败",
      });
      api.sendEvent({
        name: "like_request_fail",
      });
    }
  };
  /**
   * 关注和取消喜欢的
   * @return {[type]} [description]
   */
  user.likesSchool = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    var id = arguments[0] ? arguments[0] : "";
    var type = arguments[1] ? arguments[1] : "school";
    if (typeof id !== undefined) {
      user.request(
        paths.user.likesSchool,
        {
          id: id,
          type: type,
        },
        function (ret,err) {
          if (err) {
            api.alert(
              {
                title: "提示",
                msg: "设置收藏失败," + err.msg || "",
              },
              function (ret,err) { }
            );
            api.sendEvent({
              name: "like_request_fail",
            });
            return;
          }
          if (ret.data.likes == 0) {
            api.sendEvent({
              name: "likeCancel",
            });
          } else {
            api.sendEvent({
              name: "likeFinish",
            });
          }
          console.log("收藏菜谱成功:" + id);
        },
        true
      );
    } else {
      api.alert({
        title: "提示",
        msg: "设置收藏失败",
      });
      api.sendEvent({
        name: "like_request_fail",
      });
    }
  };

  /**
   * 关注和取消喜欢的
   * @return {[type]} [description]
   */
  user.commentCook = function (cook_id,content,atuid,callback) {
    // var cook_id = arguments[0] ? arguments[0] : '';
    // var content = arguments[1] ? arguments[1] : '';
    // var atuid = arguments[2] ? arguments[2] : '';
    if (typeof cook_id !== undefined) {
      user.request(
        paths.user.comment,
        {
          cook_id: cook_id,
          content: content,
          atuid: atuid,
        },
        function (ret,err) {
          callback(ret,err);
          console.log("评论成功:" + cook_id);
        },
        true
      );
    } else {
      api.alert({
        title: "提示",
        msg: "评论失败",
      });
    }
  };

  user.edit = function (title,type,field) {
    api.openWin({
      name: "winUserEdit",
      url: api.wgtRootDir + "/html/user/win_userEdit.html",
      bounces: false,
      delay: 300,
      pageParam: {
        title: title,
        type: type,
        field: field,
      },
    });
  };

  user.level = function () {
    api.openWin({
      name: "myLevenWin",
      url: api.wgtRootDir + "/html/level/win_my_level.html",
      bounces: false,
      delay: 300,
    });
  };

  /**
   * 判断用户是否登陆
   */
  user.is_mobile = function () {
    var userInfo = $api.setStorage("userInfo",userInfo);
    if (userInfo.mobile === undefined) {
      return false;
    } else {
      return true;
    }
  };

  /**
   * token 失效重新获取
   */
  user.getUpdateToken = function () { };

  /**
   * 获取用户
   */
  user.getUid = function () {
    var uid = api.getPrefs({
      sync: true,
      key: "uid",
    });
    // var uid = $api.getStorage('uid');
    return parseInt(uid);
  };

  /**
   * 获取用户
   */
  user.getUsername = function () {
    return $api.getStorage("username");
  };

  user.getProfile = function () {
    var userInfo =
      $api.getStorage("userInfo") || "http://images.cookmami.com/avatar.jpg";
    return userInfo.avatar;
  };

  /**
   * 设置用户
   */
  user.setUid = function (uid) {
    api.setPrefs({
      key: "uid",
      value: uid,
    });
    $api.setStorage("uid",uid);
  };

  user.countPayment = function (type,url) {
    if (user.is_login()) {
      var token = this.getToken();
      var uid = this.getUid();
      console.log("用户请求:" + paths.server.userBase + paths.user.payment);
      if (token !== undefined) {
        var datas = {
          type: type,
          url: url,
        };
        datas.appVer = api.appVersion;
        datas.systemType = api.systemType;
        datas.deviceId = api.deviceId;
        datas.token = token;
        datas.uid = uid;
        datas.deviceModel = api.deviceModel;
        datas.systemVersion = api.systemVersion;
        datas.systemType = api.systemType;
        datas.appVersion = api.appVersion;
        datas.operator = api.operator; // 比如:中国移动
        datas.connectionType = api.connectionType; //比如: wifi
        datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
        api.ajax({
          url: paths.server.userBase + paths.user.payment,
          method: "post",
          timeout: 30,
          cache: true,
          dataType: "json",
          returnAll: false,
          data: { values: datas },
        });
      }
    }
  };

  user.reportMallError = function (url) {
    if (user.is_login()) {
      var token = this.getToken();
      var uid = this.getUid();
      console.log(
        "用户请求:" + paths.server.userBase + paths.user.reportMallError
      );
      if (token !== undefined) {
        var datas = {
          url: url,
        };
        datas.appVer = api.appVersion;
        datas.systemType = api.systemType;
        datas.deviceId = api.deviceId;
        datas.token = token;
        datas.uid = uid;
        datas.deviceModel = api.deviceModel;
        datas.systemVersion = api.systemVersion;
        datas.systemType = api.systemType;
        datas.appVersion = api.appVersion;
        datas.operator = api.operator; // 比如:中国移动
        datas.connectionType = api.connectionType; //比如: wifi
        datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
        api.ajax({
          url: paths.server.userBase + paths.user.reportMallError,
          method: "post",
          timeout: 30,
          cache: true,
          dataType: "json",
          returnAll: false,
          data: { values: datas },
        });
      }
    }
  };

  user.is_baby = function () {
    var babyVer = "baby_info_" + api.appVersion;
    var babySet = api.getPrefs({
      sync: true,
      key: babyVer,
    });
    // var babySet = $api.getStorage(babyVer);
    if (babySet === "") {
      return false;
    } else {
      return true;
    }
  };

  user.getBabyInfo = function () {
    var babyInfo = api.getPrefs({
      sync: true,
      key: "babyInfo",
    });
    if (babyInfo == "")
      return {
        name: "",
        id: "",
        avatar: "",
      };

    return $api.strToJson(babyInfo);
    //$api.getStorage('babyInfo');
  };
  user.getBabyInfoCallback = function (callback) {
    api.getPrefs(
      {
        key: "babyInfo",
      },
      function (ret,err) {
        callback(ret,err);
      }
    );
    // return $api.getStorage('babyInfo');
  };

  /**
   * 设置宝宝信息
   */
  user.setBaby = function () {
    var babyInfo = arguments[0] ? arguments[0] : {};
    api.setPrefs({
      key: "babyInfo",
      value: babyInfo,
    });
    $api.setStorage("babyInfo",babyInfo);
  };

  /**
   * 设置登录状态
   */
  user.setUser = function () {
    var userInfo = arguments[0] ? arguments[0] : {};
    // if (is_debug) {
    // userInfo.uid = 1910;
    // userInfo.token = 'ykq123';
    // }
    console.log("----------------------------------------");
    console.log("登陆信息存储：" + JSON.stringify(userInfo));
    console.log("uid:" + userInfo.uid);
    console.log("token:" + userInfo.token);
    console.log("username:" + userInfo.username);
    console.log("----------------------------------------");
    this.setUid(userInfo.uid);
    $api.setStorage("username",userInfo.username);
    $api.setStorage("userInfo",userInfo);
    $api.setStorage("token",userInfo.token);
    api.setPrefs({
      key: "uid",
      value: userInfo.uid,
    });
    api.setPrefs({
      key: "token",
      value: userInfo.token,
    });
    api.setPrefs({
      key: "userInfo",
      value: userInfo,
    });
    if (userInfo.avatar) {
      api.imageCache(
        {
          url: userInfo.avatar,
          thumbnail: false,
        },
        function (ret,err) {
          var url = ret.url;
        }
      );
    }
    console.log("记录用户登录配置完毕");
  };

  user.getUserinfo = function () {
    return $api.getStorage("userInfo");
  };

  user.getToken = function () {
    var token = api.getPrefs({
      sync: true,
      key: "token",
    });
    // console.log($api.getStorage("token"));
    // return $api.getStorage("token");
    return token;
  };

  user.updateUserInfo = function (callback) {
    this.request(paths.user.myInfo,{},function (ret) {
      console.log("更新信息",JSON.stringify($api.getStorage("userInfo")))
      var tempUserInfo = $api.getStorage("userInfo")
        ? $api.getStorage("userInfo")
        : {
          fans: 0,
        };
      var is_tip = false;
      if (ret.data.fans > tempUserInfo.fans) {
        api.setPrefs({
          key: "fans_changge",
          value: ret.data.fans,
        });
        api.sendEvent({
          name: "fans_changge",
          extra: {
            fansNum: ret.data.fans,
          },
        });
        is_tip = true;
      }
      var userInfo = ret.data ? ret.data : {};
      userInfo.label = 2;
      $api.setStorage("userInfo",userInfo);
      api.setPrefs({
        key: "userInfo",
        value: userInfo,
      });
      if (typeof callback === "function") {
        callback(ret,is_tip);
      }
      console.log("用户登录配置完毕");
    });
  };
  /**
   * 登陆入口
   */
  user.main = function () {
    api.openWin({
      name: "userMain",
      url: api.wgtRootDir + "/html/user/win_main.html",
      bounces: false,
      delay: 100,
      slidBackEnabled: false,
      bgColor: "widget://image/login_bg.png",
      animation: {
        type: "none", //动画类型（详见动画类型常量）
      },
    });
  };

  /**
   * 宝宝信息编辑
   */
  user.babyEdit = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    api.openWin({
      name: "babyMain",
      url: api.wgtRootDir + "/html/user/win_baby.html",
      bounces: false,
      delay: 300,
      pageParam: {},
    });
  };

  /**
   * 用户收入income
   */
  user.income = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    // alert('tse');
    api.openWin({
      name: "incomeMain",
      url: api.wgtRootDir + "/html/user/win_income.html",
      bounces: false,
      delay: 300,
      slidBackEnabled: false,
      pageParam: {},
    });
  };

  /**
   * 用户分销商品列表
   */
  user.incomeGoods = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    api.openWin({
      name: "incomeMain",
      url: api.wgtRootDir + "/html/user/win_income_goods.html",
      bounces: false,
      delay: 300,
      pageParam: {},
    });
  };

  user.myTeam = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    api.openWin({
      name: "fxTeamWin",
      url: api.wgtRootDir + "/html/fx/win_fx_team.html",
      bounces: false,
      delay: 300,
      pageParam: {},
    });
  };

  user.showSalesData = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    api.openWin({
      name: "fxSalesWin",
      url: api.wgtRootDir + "/html/fx/win_fx_sales.html",
      bounces: false,
      delay: 300,
      pageParam: {},
    });
  };

  user.showSubusers = function (type) {
    api.openWin({
      name: "fxSubusersWin",
      url: api.wgtRootDir + "/html/fx/win_fx_subusers.html",
      bounces: false,
      delay: 300,
      pageParam: { type: type },
    });
  };

  /**
   * 资料补全入口
   */
  user.enter = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    api.openWin({
      name: "userEnter",
      url: api.wgtRootDir + "/html/user/win_enter.html",
      bounces: false,
      delay: 300,
      slidBackEnabled: false,
      animation: {
        type: "none", //动画类型（详见动画类型常量）
      },
    });
  };

  user.login = function (type) {
    // if (is_debug) {
    //   api.openWin({
    //     name: 'uid',
    //     url: api.wgtRootDir + '/html/test_login.html',
    //     bounces: false,
    //     delay: 300,
    //     pageParam: {}
    //   });
    //   return;
    // }
    // api.openWin({
    //     name: 'userLogin',
    //     url: api.wgtRootDir + '/html/user/win_login.html',
    //     bounces: false,
    //     delay: 300,
    //     pageParam: {
    //         type: type
    //     }
    // });
    if (!user.is_login()) {
      user.main();
      return;
    }
  };

  user.auth = function (mobile,code) {
    var that = this;
    var value = {
      deviceId: api.deviceId,
      mobile: mobile,
      code: code,
    };
    api.showProgress({
      style: "default",
      animationType: "fade",
      text: "正在登录...",
      modal: false,
    });
    api.ajax(
      {
        url: paths.server.userBase + paths.user.auth, //你的服务器地址
        method: "post",
        cache: false,
        timeout: 60,
        dataType: "json",
        returnAll: false,
        data: {
          values: value,
        },
      },
      function (ret,err) {
        api.hideProgress();
        that.handleLoginRet(ret,err,1);
      }
    );
  };

  user.loginApp = function () {
    var that = this;
    var type = arguments[0] ? arguments[0] : "mobile";
    var openId = arguments[1] ? arguments[1] : "";
    var user = arguments[2] ? arguments[2] : {};
    if (openId === "") {
      api.alert({
        title: "登录失败",
        msg: "非法登录",
      });
      return "";
    }
    var value = {
      openId: openId,
      type: type,
      user: user,
      deviceId: api.deviceId,
    };
    api.showProgress({
      style: "default",
      animationType: "fade",
      text: "正在登录...",
      modal: false,
    });
    console.log(
      "用户请求2:" +
      paths.server.userBase +
      paths.user.userLogin +
      "?" +
      urlEncode(value)
    );
    //将信息同步至服务器
    api.ajax(
      {
        url: paths.server.userBase + paths.user.userLogin, //你的服务器地址
        method: "post",
        cache: false,
        timeout: 60,
        dataType: "json",
        returnAll: false,
        data: {
          values: value,
        },
      },
      function (ret,err) {
        api.hideProgress();
        that.handleLoginRet(ret,err,10000);
      }
    );
  };

  user.handleLoginRet = function (ret,err,successCode) {
    var that = this;
    if (ret) {
      if (ret.status == successCode) {
        var userInfo = ret.data;
        //设置APP 登陆状态
        that.setUser(userInfo);
        //登录完毕初始化信息
        // log(userInfo)
        api.sendEvent({
          name: "loginFinish",
          extra: {
            finish: true,
            userInfo: userInfo,
          },
        });
        var timeNum = 300;
        if (api.systemType == "android") {
          timeNum = 500;
        }
        setTimeout(function () {
          api.hideProgress();
        },timeNum);
      } else if (ret.status == 10008) {
        api.toast({
          msg: "您的账号已被禁用，请联系微信客服cookmami3",
        });
      } else {
        api.alert({
          msg: "" + ret.message + "",
        });
        api.sendEvent({
          name: "loginFail",
        });
      }
    } else {
      api.hideProgress();
      api.sendEvent({
        name: "loginFail",
      });
      api.alert({
        title: "登录失败",
        msg: "请检查您的网络配置",
      });
      console.log(JSON.stringify(err));
    }
  };

  user.getMyLikes = function (callback) {
    this.request(paths.user.myLikes,{},function (ret) {
      if (ret.data) {
        // log(ret.data);
        $api.setStorage("_like_cook",ret.data);
        if (typeof callback === "function") {
          callback();
        }
      }
    });
  };

  user.loginOut = function () {
    api.removePrefs({
      key: "uid",
    });
    api.removePrefs({
      key: "token",
    });
    api.removePrefs({
      key: "userInfo",
    });
    api.setPrefs({
      key: "fans_changge",
      value: 0,
    });
    $api.rmStorage("uid");
    $api.rmStorage("username");
    $api.rmStorage("token");
    $api.rmStorage("userInfo");
    $api.rmStorage("_like_cook");
    $api.rmStorage("babyInfo");
    var babyVer = "baby_info_" + api.appVersion;
    api.removePrefs({
      key: babyVer,
    });
    api.removePrefs({
      key: "babyInfo",
    });
    return true;
  };

  user.wx_login = function () {
    var that = this;
    var wx = api.require("wx");
    var result = {};

    var wxPlus = api.require("wxPlus");
    wxPlus.auth(
      {
        apiKey: "", //在此输入你的微信apikey
      },
      function (ret1,err1) {
        if (ret1.status) {
          api.showProgress({
            style: "default",
            animationType: "fade",
            title: "登录中...",
            text: "请稍后...",
            modal: false,
          });
          wxPlus.getToken(
            {
              code: ret1.code,
            },
            function (ret,err) {
              if (ret.status) {
                //获取用户信息
                var accessToken = ret.accessToken;
                var openId = ret.openId;
                wxPlus.getUserInfo(
                  {
                    accessToken: ret.accessToken,
                    openId: ret.openId,
                  },
                  function (ret,err) {
                    if (ret.status) {
                      //这里需要对用户做处理
                      result = ret;
                      result.nickname = ret.nickname;
                      setPrefsWithKeyValue("test_wx_unionid",result.unionid);
                      setPrefsWithKeyValue("cache_wx_userinfo",ret);
                      that.loginApp("wx",openId,result);
                    }
                  }
                );
              }
            }
          );
        } else {
          if (api.systemType == "android" && err1.code == 3) {
            api.alert({
              title: "登录失败",
              msg: "请安装微信客户端",
            });
          }
        }
      }
    );
  };

  user.wx_auth_for_unionid = function () {
    var that = this;
    var wxPlus = api.require("wxPlus");
    var result = {};
    wxPlus.auth(
      {
        apiKey: "", //在此输入你的微信apikey
      },
      function (ret,err) {
        if (ret.status) {
          api.showProgress({
            style: "default",
            animationType: "fade",
            title: "登录中...",
            text: "请稍后...",
            modal: false,
          });
          wxPlus.getToken(
            {
              code: ret.code,
            },
            function (ret,err) {
              if (ret.status) {
                //获取用户信息
                var accessToken = ret.accessToken;
                var openId = ret.openId;
                wxPlus.getUserInfo(
                  {
                    accessToken: ret.accessToken,
                    openId: ret.openId,
                  },
                  function (ret,err) {
                    if (ret.status) {
                      //这里需要对用户做处理
                      setPrefsWithKeyValue("test_wx_unionid",result.unionid);
                      setPrefsWithKeyValue("test_wx_openid",openId);
                    }
                  }
                );
              }
            }
          );
        } else {
          if (api.systemType == "android" && err.code == 3) {
            api.alert({
              title: "登录失败",
              msg: "请安装微信客户端",
            });
          }
        }
      }
    );
  };

  user.get_wx_unionid = function (callback,url) {
    var userInfo = getPrefsWithKey("cache_wx_userinfo");
    if (userInfo) {
      callback(userInfo);
    } else {
      var that = this;
      var wxPlus = api.require("wxPlus");
      var result = {};
      wxPlus.auth(
        {
          apiKey: "", //在此输入你的微信apikey
        },
        function (ret1,err1) {
          if (ret1.status) {
            api.showProgress({
              style: "default",
              animationType: "fade",
              title: "登录中...",
              text: "请稍后...",
              modal: false,
            });
            wxPlus.getToken(
              {
                code: ret1.code,
              },
              function (ret2,err2) {
                api.hideProgress();
                if (ret2.status) {
                  //获取用户信息
                  var accessToken = ret2.accessToken;
                  var openId = ret2.openId;
                  wxPlus.getUserInfo(
                    {
                      accessToken: ret2.accessToken,
                      openId: ret2.openId,
                    },
                    function (ret,err) {
                      if (ret.status) {
                        //这里需要对用户做处理
                        setPrefsWithKeyValue("cache_wx_userinfo",ret);
                        callback(ret);
                      }
                    }
                  );
                }
              }
            );
          } else {
            api.alert({
              title: "友情提示",
              msg: "请先安装信客户端",
            });
          }
        }
      );
    }
  };

  user.qq_login = function () {
    var qq = api.require("QQPlus");
    var that = this;
    qq.installed(function (ret,err) {
      if (ret.status) {
        qq.login(function (ret,err) {
          if (ret) {
            var openId = ret.openId;
            var userInfo = {};

            qq.getUserInfo(function (ret,err) {
              if (ret.status) {
                userInfo.unionid = openId;
                userInfo.nickname = ret.info.nickname;
                userInfo.headimgurl = ret.info.figureurl_qq_2;
                if (ret.info.gender == "男") {
                  userInfo.sex = "1";
                } else {
                  userInfo.sex = "2";
                }
                that.loginApp("qq",openId,userInfo);
              } else {
                console.log("登录失败：" + err.msg);
              }
            });
          }
        });
      } else {
        api.alert({
          title: "登录失败",
          msg: "没有安装QQ客户端",
        });
      }
    });
  };

  user.sinaWeiBo_login = function () {
    var that = this;
    var weiBo = api.require("weibo");
    weiBo.auth(function (ret,err) {
      if (ret.status) {
        var userInfo = {};
        userInfo.accessToken = ret.token;
        userInfo.openId = ret.userId;

        weiBo.getUserInfo(function (ret,err) {
          if (ret.status) {
            //登录APP
            userInfo.name = ret.userInfo.name;
            userInfo.profile_image_url = ret.userInfo.avatar_hd;
            userInfo.idstr = ret.userInfo.idstr;
            userInfo.screen_name = ret.userInfo.screen_name;
            userInfo.name = ret.userInfo.name;
            that.loginApp("weibo",ret.userInfo.id,userInfo);
          } else {
            api.alert({
              msg: err.msg,
            });
          }
        });
      } else {
        var errmsg = err.msg || "";
        api.alert({
          msg: "授权失败" + errmsg,
        });
      }
    });
  };

  user.creatCode = function (len) {
    var seed = new Array("0123456789");
    var idx,i;
    var result = "";
    for (i = 0; i < len; i++) {
      idx = Math.floor(Math.random() * 1);
      result += seed[idx].substr(
        Math.floor(Math.random() * seed[idx].length),
        1
      );
    }
    return result;
  };

  user.sumSend = function (mobile,verifyCode,callback) {
    //开始短信请求
    api.ajax(
      {
        url: paths.server.userBase + paths.user.sendSms,
        method: "post",
        timeout: 30,
        dataType: "json",
        returnAll: false,
        data: {
          values: {
            deviceId: api.deviceId,
            mobile: mobile,
            verify_code: verifyCode,
          },
        },
      },
      function (ret,err) {
        if (ret) {
          // TODO
          callback(ret);
          console.log(ret.message);
        } else {
          api.alert(
            {
              title: "提示",
              msg: "发送验证码失败，请检查网络",
            },
            function (ret,err) {
              if (ret) {
              }
            }
          );
          // showErrMgs(err.code, err.msg);
        }
      }
    );
  };

  user.default = function () {
    if (this.is_login()) {
      api.openFrame({
        name: "win_user_default",
        url: api.wgtRootDir + "/html/user/win_user.html",
        bounces: false,
        slidBackEnabled: false,
        rect: {
          x: 0,
          y: 0,
          w: "auto",
          h: "auto",
        },
      });
    } else {
      this.login();
    }
  };

  user.myLikes = function () {
    api.openWin({
      name: "userMyLike",
      url: api.wgtRootDir + "/html/user/win_likes.html",
      bounces: false,
      pageParam: {},
    });
  };

  user.myCooks = function (type) {
    api.openWin({
      name: "userMyCooks",
      url: api.wgtRootDir + "/html/user/win_cooks.html",
      delay: 300,
      bounces: false,
      pageParam: {
        type: type,
      },
    });
  };
  user.myfans = function () {
    if (this.is_login()) {
      api.openWin({
        name: "userMyFans",
        url: api.wgtRootDir + "/html/user/win_fans.html",
        bounces: false,
        delay: 300,
        pageParam: {},
      });
    } else {
      this.login("fans");
    }
  };

  user.myfollow = function () {
    if (this.is_login()) {
      api.openWin({
        name: "userMyFans",
        delay: 300,
        url: api.wgtRootDir + "/html/user/win_follow.html",
        bounces: false,
        pageParam: {},
      });
    } else {
      this.login("follow");
    }
  };

  user.follow = function () {
    if (this.is_login()) {
      var follow_uid = arguments[0] ? arguments[0] : 0;
      if (follow_uid == this.getUid()) return;
      if (follow_uid == 0) return;
      user.request(
        paths.user.follow,
        {
          follow_uid: follow_uid,
        },
        function (ret) {
          api.sendEvent({
            name: "follow_success",
            extra: {
              follow_uid: follow_uid,
            },
          });
        }
      );
    } else {
      this.login();
    }
  };

  user.unfollow = function () {
    if (this.is_login()) {
      var unfollow_uid = arguments[0] ? arguments[0] : 0;
      if (unfollow_uid == this.getUid()) return;
      if (unfollow_uid == 0) return;
      user.request(
        paths.user.unfollow,
        {
          unfollow_uid: unfollow_uid,
        },
        function (ret) {
          api.sendEvent({
            name: "unfollow_success",
            extra: {
              unfollow_uid: unfollow_uid,
            },
          });
        }
      );
    } else {
      this.login();
    }
  };

  user.view = function () {
    if (!user.is_login()) {
      user.main();
      return;
    }
    var view_uid = arguments[0] ? arguments[0] : "";
    if (view_uid == "") {
      // api.alert({
      //     title: '提示',
      //     msg: '无法访问该用户内容'
      // });
      return;
    }
    api.openWin({
      name: "winUserView",
      url: api.wgtRootDir + "/html/user/win_userView.html",
      bounces: false,
      delay: 300,
      slidBackEnabled: false,
      pageParam: {
        view_uid: view_uid,
      },
    });
  };

  user.nearbyMoment = function (latitude,longitude,position) {
    api.openWin({
      name: "momentNearbyWin",
      url: api.wgtRootDir + "/html/moment/win_moment_nearby.html",
      bounces: false,
      delay: 300,
      slidBackEnabled: false,
      pageParam: {
        latitude: latitude,
        longitude: longitude,
        position: position,
      },
    });
  };

  user.pattern = function () {
    api.openWin({
      name: "winPattner",
      url: api.wgtRootDir + "/html/user/win_pattner.html",
      hScrollBarEnabled: false,
      vScrollBarEnabled: false,
      bounces: false,
      pageParam: {},
    });
  };
  window.user = user;
})(window);

/*
 * UINews Class
 * ruby
 * 2016/11/02
 */
(function () {
  "use strict";

  var UINews = {};

  UINews.open = function () {
    // alert("打开新闻");
    var id = arguments[0] ? arguments[0] : "";
    var title = arguments[1] ? arguments[1] : "新闻";
    api.openWin({
      name: "UINewsWin",
      url: api.wgtRootDir + "/html/win_news.html",
      delay: 300,
      bounces: false,
      pageParam: {
        id: id,
        title: title,
      },
    });
  };

  UINews.cancel = function () {
    api.closeWin({
      name: "UINewsWin",
      animation: {
        type: "none", //动画类型（详见动画类型常量）
        subType: "from_top", //动画子类型（详见动画子类型常量）
        duration: 0, //动画过渡时间，默认300毫秒
      },
    });
  };

  UINews.clear = function () { };

  Array.prototype.indexOf = function (val) {
    for (var i = 0; i < this.length; i++) {
      if (this[i] == val) return i;
    }
    return -1;
  };

  Array.prototype.remove = function (val) {
    var index = this.indexOf(val);
    if (index > -1) {
      this.splice(index,1);
    }
  };
  window.UINews = UINews;
})();
/*
 * UITips Class
 * ruby
 * 2017/06/15
 */
(function () {
  "use strict";

  var UITips = {};

  UITips.show = function (param) {
    var param = arguments[0]
      ? arguments[0]
      : {
        text: "加载中...",
        time: 2000,
      };
    api.sendEvent({
      name: "tipNotice",
      extra: param,
    });
  };

  UITips.log = function (data) {
    if (!is_debug) return;

    if (typeof data == "string") {
      var text = data;
    } else {
      var text = JSON.stringify(param.text);
    }
    var param = {
      text: text,
      time: 3000,
    };

    api.sendEvent({
      name: "tipNotice",
      extra: param,
    });
  };
  window.UITips = UITips;
})();
/*
 * Pattern Class
 * Teresa
 * 2017/11/8
 */
(function () {
  "use strict";
  var p = {};
  /**
   * 合伙人通用请求处理
   * @param  {[type]}   type      请求地址
   * @param  {[type]}   pageParam [数据]
   * @param  {Function} callback  [回调方法]
   * @param  {[type]}   method    请求方法
   * @return {[type]}             [返回值]
   */
  p.request = function (type,pageParam,callback,method) {
    var that = this;
    if (!user.is_login()) {
      // console.log("非法本次请求：" + token);
      console.log("非法本次请求：" + uid);
      api.alert({
        title: "提示",
        msg: "未登录用户，非法请求" + type + ",frameName：" + api.frameName,
      });
      api.hideProgress();
      return;
    }
    var token = user.getToken();
    var uid = user.getUid();
    if (typeof uid != "undefined") {
      var datas = pageParam;
      datas.deviceId = api.deviceId;
      datas.token = token;
      datas.uid = uid;
      datas.deviceModel = api.deviceModel;
      datas.systemVersion = api.systemVersion;
      datas.systemType = api.systemType;
      datas.appVersion = api.appVersion;
      // datas.operator = api.operator; // 比如:中国移动
      datas.connectionType = api.connectionType; //比如: wifi
      // datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
      api.ajax(
        {
          url: paths.server.itemIncomeLog + type,
          method: method || "get",
          timeout: 30,
          cache: true,
          dataType: "json",
          returnAll: false,
          data: {
            values: datas,
          },
        },
        function (ret,err) {
          console.log(
            "请求地址:" +
            paths.server.itemIncomeLog +
            type +
            "?" +
            urlEncode(datas) +
            "-----" +
            ret
          );
          if (ret) {
            console.log("-------------请求接口开始-------------");
            console.log(
              "请求地址:" +
              paths.server.itemIncomeLog +
              type +
              "?" +
              urlEncode(datas)
            );
            console.log("-------------请求接口成功-------------");
            console.log(res.status);
            //请求成功时
            if (ret.status == 1) {
              if (typeof callback === "function") {
                callback(ret);
              }
            } else if (ret.status == 10001) {
              api.sendEvent({
                name: "userLoginPut",
              });
              api.hideProgress();
            } else if (ret.status == 10011) {
              api.sendEvent({
                name: "request_fail",
                extra: {
                  code: 10011,
                  type: type,
                  msg: ret.message,
                },
              });
            } else {
              api.hideProgress();
              // console.log("错误提示" + ret.message);
              console.log("更新数据出错，请稍后重试，错误状态" + ret.status);
              api.toast({
                msg: ret.message,
                duration: 2000,
                location: "top",
              });
            }
          } else {
            console.log("-------------请求接口出错开始-------------");
            console.log(JSON.stringify(err));
            console.log("-------------请求接口出错结束-------------");
            //上报服务器
            // api.hideProgress();
            // api.sendEvent({
            // 		name: 'request_fail',
            // 		extra: {
            // 				code: err.code,
            // 				type: type
            // 		}
            // });
            if (err && typeof callback === "function") {
              callback(ret,err);
            }
          }
        }
      );
    } else {
      api.sendEvent({
        name: "userLoginOut",
      });
    }
  };
  p.index = function () {
    api.openWin({
      name: "partnerWin",
      url: api.wgtRootDir + "/html/user/win_partner.html",
      delay: 300,
      bounces: false,
      pageParam: {},
    });
  };
  p.order = function () {
    // if (isApp) {
    api.openWin({
      name: "orderWin",
      slidBackEnabled: false,
      url: api.wgtRootDir + "/html/user/win_partner_order.html",
      delay: 300,
      bounces: false,
      pageParam: {},
    });
    // }else{
    // }
  };
  p.incomeLog = function (incomeLogId) {
    api.openWin({
      name: "incomeLogWin",
      url: api.wgtRootDir + "/html/user/win_partner_income.html",
      delay: 300,
      bounces: false,
      pageParam: {
        id: incomeLogId,
      },
    });
  };
  p.apply = function () {
    api.openWin({
      name: "applyWin",
      url: api.wgtRootDir + "/html/user/win_partner_apply.html",
      delay: 300,
      bounces: false,
      pageParam: {},
    });
  };
  p.salary = function () {
    api.openWin({
      name: "salaryWin",
      url: api.wgtRootDir + "/html/user/win_partner_salary.html",
      delay: 300,
      bounces: false,
      pageParam: {},
    });
  };
  window.partner = p;
})();

function getDevice () {
  var device = {};
  device.version = api.version;
  device.appVersion = api.appVersion;
  device.systemType = api.systemType;
  device.systemVersion = api.systemVersion;
  device.deviceId = api.deviceId;
  // devdce.dToken = api.deviceToken;
  device.deviceModel = api.deviceModel;
  device.deviceName = api.deviceName;
  device.connectionType = api.connectionType;
  //获取相关信息
  return device;
}
/*
 * Tools Class
 * 2016/4/07
 */
(function () {
  "use strict";

  var l = {};

  /**
   * 埋点
   */
  l.talkingData = function (td,label,parameters) {
    if (!td) {
      td = api.require("talkingData");
    }
    td.onEvent({
      eventId: api.appVersion,
      eventLabel: label,
      parameters: parameters,
    });
  };
  /**
   * 页面分析 埋点
   */
  l.onPageStart = function (td,name) {
    if (!td) {
      td = api.require("talkingData");
    }
    td.onPageStart({
      pageName: name,
    });
  };
  l.onPageEnd = function (td,name) {
    if (!td) {
      td = api.require("talkingData");
    }
    if (typeof name != "string") {
      name.map(function (item) {
        td.onPageEnd({
          pageName: item,
        });
      });
    } else {
      td.onPageEnd({
        pageName: name,
      });
    }
  };
  l.isUrl = function (str) {
    var reg = new RegExp(
      "https?://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]"
    );
    return reg.test(str);
  };
  /**
   * 判断是否存在表情
   */
  l.isEmojiCharacter = function (substring,hideAlert) {
    if (!substring || substring.replace(/(^s*)|(s*$)/g,"").length == 0) {
      //是否为空
      return false;
    } else {
      var reg = /\ud83c[\udc00-\udfff]|\ud83d[\udc00-\udfff]|[\u2000-\u2fff]|\ud83e[\udd00-\uddff]|[\u3030-\u3299]\ufe0f|\ua9|\uae|\u3030/g;
      // if (api.systemType == "ios") {
      //   reg = /(\ud83c[\udf00-\udfff])|(\ud83d[\udc00-\ude4f])|(\ud83d[\ude80-\udeff])/g;
      // }
      var ignoreChar = ["“",",","’","，","”","…"];
      var verifiedStr = substring;
      ignoreChar.forEach(function (item) {
        var ignoreReg = new RegExp(item,"g");
        verifiedStr = verifiedStr.replace(ignoreReg,"");
      });
      // return false;
      // console.log(substring);
      // console.log(verifiedStr);
      var has = reg.test(verifiedStr);
      if (!hideAlert && has) {
        // console.log(verifiedStr);
        alert(verifiedStr.match(reg) + " 为特殊字符，请不要使用哦~");
      }
      return has;
    }
  };

  /**
   * 获取日期格式化
   * 例:2016-02-06
   */
  l.getNowFormatDate = function () {
    var date = new Date();
    var seperator1 = "-";
    var year = date.getFullYear();
    var month = date.getMonth() + 1;
    var strDate = date.getDate();
    if (month >= 1 && month <= 9) {
      month = "0" + month;
    }
    if (strDate >= 0 && strDate <= 9) {
      strDate = "0" + strDate;
    }
    var currentdate = year + seperator1 + month + seperator1 + strDate;
    return currentdate;
  };

  l.getMonthNum = function (date2) {
    date2 = date2.split("-");
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth() + 1;
    var year = d.getFullYear();
    var byear = parseInt(date2[0]);
    var bmonth = parseInt(date2[1]);
    var bday = parseInt(date2[2]);
    var bi =
      parseInt(date2[0]) * 10000 +
      parseInt(date2[1]) * 100 +
      parseInt(date2[2]);
    var ni = parseInt(year) * 10000 + parseInt(month) * 100 + parseInt(day);
    var not_birth = 0;
    if (bi > ni) {
      not_birth = 1;
      var temp = bi;
      bi = ni;
      ni = temp;
      temp = year;
      year = byear;
      byear = temp;
      temp = month;
      month = bmonth;
      bmonth = temp;
      temp = day;
      day = bday;
      bday = temp;
    }
    var years = 0;
    while (bi + 10000 < ni || bi + 10000 == ni) {
      //先取岁数
      bi += 10000;
      years++;
      byear++;
    } //得到岁数后 抛弃年
    var params1 = [year,month,day];
    var params2 = [byear,bmonth,bday];
    var tempArr = getMD(params1,params2);
    var m = tempArr.month + years * 12;
    return m;
  };
  /**
   * 只能用于一年内计算
   * @param type $ymd
   * @param type $bymd
   */
  function getMD (ymd,bymd) {
    var y = ymd[0];
    var m = ymd[1];
    var d = ymd[2];
    var by = bymd[0];
    var bm = bymd[1];
    var bd = bymd[2];
    if (m * 100 + d < bm * 100 + bd) {
      m += 12;
    }
    var month = 0;
    while (bm * 100 + bd + 100 <= m * 100 + d) {
      bm++;
      month++;
    }
    if (bd <= d) {
      //同处一个月
      var day = d - bd;
    } else {
      //少一个月
      var mdays = bm > 12 ? _getMothDay(++by,bm - 12) : _getMothDay(by,bm);
      day = mdays - bd + d;
    }
    var tempArr = {
      month: month,
      day: day,
    };
    return tempArr;
  }

  function _getMothDay (year,month) {
    var day = 0;
    switch (month) {
      case 1:
      case 3:
      case 5:
      case 7:
      case 8:
      case 10:
      case 12:
        day = 31;
        break;
      case 2:
        day = parseInt(year % 4) ? 28 : 29; //能被4除尽的为28天其他29天
        break;
      default:
        day = 30;
        break;
    }
    return day;
  }

  /**
   * 获取文件名后缀
   *
   * @param      {string}  fileName  The file name
   * @return     {string}  jpg,png,bmp
   */
  l.getExt = function (fileName) {
    return fileName.substring(fileName.lastIndexOf(".") + 1);
  };

  /**
   * 生成GUID编号
   *
   * @class      NewGuid (name)
   * @return     {number}  { description_of_the_return_value }
   */
  l.NewGuid = function () {
    function S4 () {
      return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    }
    return (
      S4() +
      S4() +
      "-" +
      S4() +
      "-" +
      S4() +
      "-" +
      S4() +
      "-" +
      S4() +
      S4() +
      S4()
    );
  };

  l.uploadImage = function (path,dir,is_progress,callback) {
    var is_progress = is_progress ? is_progress : true;
    var that = this;
    var qiniuUpfile = api.require("qiniuUpfile");
    var dir = dir ? dir : "cook";
    qiniuUpfile.upfile(
      {
        file: path,
        name: "data_upload_" + dir + "_" + that.NewGuid() + ".jpg",
      },
      function (ret,err) {
        if (ret.status) {
          if (ret.oper == "complete") {
            if (is_progress) {
              api.hideProgress();
            }
            console.log("----------------------------------");
            console.log("七牛上传文件:" + JSON.stringify(ret));
            console.log(machineurl + ret.info.key);
            console.log("----------------------------------");
            if (typeof callback === "function") {
              ret.path = machineurl + ret.info.key;
              callback(ret);
            }
          } else if (ret.oper == "progress") {
            if (is_progress) {
              api.showProgress({
                title: parseInt(ret.percent) + "%",
                text: "正在努力上传图片...",
                modal: false,
              });
            }
          }
        } else {
          // api.toast({
          // 	msg: '上传失败，请重试'
          // });
          console.log("----------------------------------");
          console.log("七牛上传文件：" + JSON.stringify(err));
          console.log("----------------------------------");
          api.sendEvent({
            name: "imageUploadFail",
            extra: {
              valueName1: "value1",
              valueName2: "value2",
            },
          });
        }
      }
    );
  };

  window.tools = l;
})();

/**
 * 用于把用utf16编码的字符转换成实体字符，以供后台存储
 * @param  {string} str 将要转换的字符串，其中含有utf16字符将被自动检出
 * @return {string}     转换后的字符串，utf16字符将被转换成&#xxxx;形式的实体字符
 */
function utf16toEntities (str) {
  var patt = /[\ud800-\udbff][\udc00-\udfff]/g; // 检测utf16字符正则
  str = str.replace(patt,function (char) {
    var H,L,code;
    if (char.length === 2) {
      H = char.charCodeAt(0); // 取出高位
      L = char.charCodeAt(1); // 取出低位
      code = (H - 0xd800) * 0x400 + 0x10000 + L - 0xdc00; // 转换算法
      return "&#" + code + ";";
    } else {
      return char;
    }
  });
  return str;
}

function emoji2Str (str) {
  return unescape(escape(str).replace(/\%uD.{3}/g,""));
}
// alert(entitiestoUtf16(name));
function entitiestoUtf16 (str) {
  // 检测出形如&#12345;形式的字符串
  var strObj = utf16toEntities(str);
  var patt = /&#\d+;/g;
  var H,L,code;
  var arr = strObj.match(patt) || [];
  for (var i = 0; i < arr.length; i++) {
    code = arr[i];
    code = code.replace("&#","").replace(";","");
    // 高位
    H = Math.floor((code - 0x10000) / 0x400) + 0xd800;
    // 低位
    L = ((code - 0x10000) % 0x400) + 0xdc00;
    code = "&#" + code + ";";
    var s = String.fromCharCode(H,L);
    strObj.replace(code,s);
  }
  return strObj;
}
if (!is_debug) {
  onerror = handleErr;
}
/**
 *错误劫持
 */
function handleErr (msg,url,l) {
  var error = {};
  txt = "There was an error on this page.\n\n";
  txt += "Error: " + msg + "\n";
  txt += "URL: " + url + "\n";
  txt += "Line: " + l + "\n\n";
  if (user.is_login()) {
    error.login_uid = user.getUid();
  }
  error.msg = msg;
  error.url = url;
  error.l = l;
  error.txt = txt;
  error.deviceId = api.deviceId;
  error.deviceModel = api.deviceModel;
  error.systemVersion = api.systemVersion;
  error.systemType = api.systemType;
  error.appVersion = api.appVersion;
  error.operator = api.operator; // 比如:中国移动
  error.connectionType = api.connectionType; //比如: wifi
  error.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
  console.log(JSON.stringify(error));
  if (is_debug) {
    api.alert(
      {
        title: "错误",
        msg: JSON.stringify(error),
      },
      function (ret,err) {
        if (ret) {
        }
      }
    );
    return;
  }
  api.sendEvent({
    name: "log",
    extra: error,
  });
  api.ajax(
    {
      url: paths.server.serverBase + paths.api.error,
      method: "post",
      timeout: 30,
      dataType: "json",
      returnAll: false,
      data: {
        values: error,
      },
    },
    function (ret,err) {
      if (ret) {
        // TODO
        // if (ret.status == 1) {
        // 	api.alert({
        // 		title: '程序出现错误，上报错误成功'
        // 	});
        // };
      } else {
        // showErrMgs(err.code, err.msg);
      }
    }
  );
  // alert(txt)
  return true;
}
/**
 * 获取分类
 */
function get_classify (name,callback) {
  if (name === "") {
    return;
  }
  doCache("classify","list",paths.api.classify,function (data) {
    // var data = {"data":[{"name":"\u70ed\u95e8","id":"334","cook_major":[{"is_show":"1","alias":"\u829d\u58eb,\u8d77\u53f8,\u5e72\u916a","cate_id":"334,344","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c798a656883.jpg","id":"69","name":"\u5976\u916a","title":"","subtitle":""},{"is_show":"1","alias":"\u4f18\u683c,yogurt","cate_id":"334,344","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7997326eab.jpg","id":"154","name":"\u9178\u5976","title":"","subtitle":""},{"is_show":"1","alias":"\u4e09\u6587\u9c7c","cate_id":"334,343","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7aa3fc22c0.jpg","id":"2316","name":"\u9c91\u9c7c","title":"","subtitle":""}],"cook_tag":[]},{"name":"\u6c34\u679c\u575a\u679c","id":"345","cook_major":[{"is_show":"1","alias":"\u7ea2\u5fc3\u706b\u9f99\u679c,\u7ea2\u9f99\u679c,\u9752\u9f99\u679c,\u4ed9\u871c\u679c,\u7389\u9f99\u679c","cate_id":"345","cover":"","id":"337","name":"\u706b\u9f99\u679c","title":"","subtitle":""}],"cook_tag":[]},{"name":"\u86cb\u5976\u8c46\u5236\u54c1","id":"344","cook_major":[{"is_show":"1","alias":"","cate_id":"344","cover":"","id":"38","name":"\u9e21\u86cb","title":"","subtitle":""},{"is_show":"1","alias":"\u829d\u58eb,\u8d77\u53f8,\u5e72\u916a","cate_id":"334,344","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c798a656883.jpg","id":"69","name":"\u5976\u916a","title":"","subtitle":""},{"is_show":"1","alias":"\u4f18\u683c,yogurt","cate_id":"334,344","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7997326eab.jpg","id":"154","name":"\u9178\u5976","title":"","subtitle":""},{"is_show":"1","alias":"\u6c34\u8c46\u8150,\u5185\u916f\u8c46\u8150,\u5357\u8c46\u8150,\u5317\u8c46\u8150,\u8001\u8c46\u8150,\u51bb\u8c46\u8150","cate_id":"344","cover":"","id":"193","name":"\u8c46\u8150","title":"","subtitle":""}],"cook_tag":[]},{"name":"\u6c34\u4ea7\u7c7b","id":"343","cook_major":[{"is_show":"1","alias":"\u4e09\u6587\u9c7c","cate_id":"334,343","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7aa3fc22c0.jpg","id":"2316","name":"\u9c91\u9c7c","title":"","subtitle":""}],"cook_tag":[]},{"name":"\u8089\u7c7b","id":"342","cook_major":[{"is_show":"0","alias":"\u7f8a\u8089\u6ce5,\u7f8a\u8089\u6c64,\u7f8a\u8089,","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7d27f99ce0.jpg","id":"2433","name":"\u7f8a\u8089","title":"","subtitle":""},{"is_show":"0","alias":"\u9e45\u809d,\u9e45\u809d\u6ce5","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7d14933078.jpg","id":"2439","name":"\u9e45\u809d","title":"","subtitle":""},{"is_show":"0","alias":"\u79d1\u5c14\u6c81\u725b\u8089,\u725b\u8089\u788e,\u725b\u8089\u6c64\u51b0\u5757,\u51b0\u51bb\u725b\u8089\u6ce5,\u725b\u8089\u672b,\u716e\u719f\u7684\u725b\u8089\u4e01,\u6fb3\u6d32\u5c0f\u725b\u8089,\u6fb3\u6d32\u5c0f\u725b\u8089,\u725b\u8089\u7c92,\u725b\u8089\u91cc\u810a,\u719f\u9171\u725b\u8089\uff08\u59e5\u7237\u724c\uff09,\u725b\u8089\u7c89,\u725b\u8089\u5473\u62cc\u996d\u6599,\u725b\u8089\uff08\u725b\u8169\uff09,\t\u7096\u70c2\u7684\u725b\u8089,\t\u814c\u597d\u7684\u725b\u8089,\u725b\u8089\u677e,\u5ae9\u91cc\u810a\u725b\u8089,\u5207\u7247\u725b\u8089,\u725b\u8089\u6216\u5176\u5b83\u8089\u7c7b,\u81ea\u5236\u725b\u8089\u677e,\t\u725b\u8089\u4e38,\u725b\u8089\u9985,\u725b\u8089\u9ad8\u6c64\u5757,\u725b\u8089\u6ce5,\u719f\u725b\u8089,\u725b\u8089\u7247,\u725b\u8089","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7ce1d9c1b9.jpg","id":"2429","name":"\u725b\u8089","title":"","subtitle":""},{"is_show":"0","alias":"\u9e2d\u8840","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7d1561d419.jpg","id":"2440","name":"\u9e2d\u8840","title":"","subtitle":""},{"is_show":"0","alias":"\u9e21\u809d","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7d0ec05383.jpg","id":"2438","name":"\u9e21\u809d","title":"","subtitle":""},{"is_show":"0","alias":"\u9e21\u8089\u9ad8\u6c64,\t\u9e21\u8089\u852c\u83dc,\u81ea\u5236\u9e21\u8089\u80a0,\t\u9e21\u8089\u788e,\u86cb\u76ae\u6d77\u82d4\u9e21\u8089\u5377,\u9e21\u8089\u6ce5,\u897f\u5170\u82b1\u9e21\u8089\u6ce5,\u9e21\u8089\u4e1d,\u80e1\u841d\u535c\u9e21\u8089\u6ce5,\t\u9e21\u8089\u4e01,\u5927\u4eba\u9e21\u8089\u80a0,\u9e21\u8089\u672b,\u9e21\u8089\u9999\u83c7\u51bb,\u9e21\u8089,\u9e21\u8089\u5207\u4e01","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7ce153f923.jpg","id":"2423","name":"\u9e21\u8089","title":"","subtitle":""},{"is_show":"0","alias":"\u732a\u809d\u6ce5\u51b0\u7816,\u732a\u809d\u9762,\u732a\u809d","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7d0dfd79f4.jpg","id":"2437","name":"\u732a\u809d","title":"","subtitle":""},{"is_show":"0","alias":"\u732a\u8089\uff088\u76262\u80a5\uff09,\u7626\u732a\u8089\u5207\u4e1d,\u732a\u8089\u788e,\u732a\u8089\u9985 \u4e5f\u53ef\u4ee5\u732a\u8089,\u732a\u8089\u6ce5,\u732a\u8089\uff08\u80a5\u7626\u76f8\u95f4\uff09,\t\u732a\u8089\u8171\u5b50\u8089,\u9999\u8349\u732a\u8089\u677e,\u732a\u8089\u7cdc,\u6d77\u82d4\u732a\u8089\u677e,\u732a\u8089\u9985,\u732a\u8089\u677e,\u732a\u8089\u672b,\t\u9ed1\u5c71\u732a\u8089,\t\u81ea\u5236\u732a\u8089\u677e,\u571f\u5bb6\u732a\u8089,\u732a\u8089","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7ce0c27648.jpg","id":"2422","name":"\u732a\u8089","title":"","subtitle":""},{"is_show":"0","alias":"\u9ad8\u6c64(\u9e2d\u8089\u6c64),\u9e2d\u8089","cate_id":"342","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7d0d23919f.jpg","id":"2436","name":"\u9e2d\u8089","title":"","subtitle":""}],"cook_tag":[]},{"name":"\u852c\u83dc\u7c7b","id":"341","cook_major":[{"is_show":"1","alias":"\u85af\u84e3,\u571f\u85af,\u5c71\u85af\u84e3,\u6000\u5c71\u836f,\u6dee\u5c71,\u767d\u5c71\u836f,\u94c1\u68cd\u5c71\u836f,\u6c34\u5c71\u836f,\u6bdb\u5c71\u836f,\u5149\u5c71\u836f,\u5927\u5c71\u836f,\u5c71\u836f\u68cd,\u5c71\u836f\u6ce5,\u7c97\u5c71\u836f,\u5c71\u836f\u6392\u9aa8\u6c64","cate_id":"341","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7d83d13c8d.jpg","id":"59","name":"\u5c71\u836f","title":"","subtitle":""},{"is_show":"0","alias":"\u65b0\u9c9c\u9ec4\u74dc, \u5c0f\u9ec4\u74dc,\u6c34\u679c\u9ec4\u74dc,\u9ec4\u74dc\u76ae,\u9ec4\u74dc\u6c41,\u9ec4\u74dc\u4e01,\u65e5\u672c\u9ec4\u74dc,\u9ec4\u74dc\u4e1d,\u80e1\u74dc","cate_id":"341","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_tag_57c7c572c700b.jpg","id":"2421","name":"\u9ec4\u74dc","title":"\u9ec4\u74dc\u7684\u8425\u517b\u4ef7\u503c\u548c\u8f85\u98df\u5236\u4f5c\u6280\u5de7","subtitle":""},{"is_show":"1","alias":"\u9ea6\u74dc,\u756a\u74dc,\u502d\u74dc,\u91d1\u51ac\u74dc,\u5317\u74dc, \u5c0f\u5357\u74dc,\u8d1d\u8d1d\u5357\u74dc,\u8d1d\u8d1d\u679c,\u5ae9\u5357\u74dc,\u751f\u5357\u74dc,\u7a9d\u74dc,\u996d\u74dc,\u53bb\u76ae\u5357\u74dc, \u5357\u74dc\u9762,\u9752\u5357\u74dc,\u81ea\u5236\u5357\u74dc\u9992\u5934,\u5357\u74dc\u4e01, \u5357\u74dc\u84c9\u51b0\u7816,\u5357\u74dc\u82b1,\u84b8\u719f\u5357\u74dc,\u8001\u5357\u74dc\r\n","cate_id":"341","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_major_57c7b27f0c518.jpg","id":"2420","name":"\u5357\u74dc","title":"\u5357\u74dc\u7684\u8425\u517b\u4ef7\u503c\u548c\u8f85\u98df\u5236\u4f5c\u6280\u5de7","subtitle":"\u4fc3\u8fdb\u5b9d\u5b9d\u751f\u957f\u548c\u53d1\u80b2"},{"is_show":"0","alias":"\u5e26\u571f\u80e1\u841d\u535c,\u88c5\u9970\u80e1\u841d\u535c,\u80e1\u841d\u535c\u7c92,\u80e1\u841d\u535c\u7ec6\u9762,\u6c34\u679c\u80e1\u841d\u535c,\u80e1\u841d\u535c\u9762,\u7389\u7c73\u80e1\u841d\u535c,\u80e1\u841d\u535c\u9762\u6761,\u7389\u7c73\u80e1\u841d\u535c\u9752\u8c46\u7c92,\u6bdb\u8c46\u80e1\u841d\u535c\u7c92, \u80e1\u841d\u535c\u4e1d ,\u5c0f\u80e1\u841d\u535c,\u80e1\u841d\u535c\u788e,\u80e1\u841d\u535c\u6ce5,\u84b8\u719f\u80e1\u841d\u535c,\u80e1\u841d\u535c\u4e01,\u80e1\u841d\u535c\u64e6\u4e1d\u58eb,\u80e1\u841d\u535c\u64e6\u4e1d, \u80e1\u841d\u535c\u6c41","cate_id":"341","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_major_57c7d30cb0c13.jpg","id":"2442","name":"\u80e1\u841d\u535c","title":"","subtitle":""},{"is_show":"0","alias":"\u8543\u8304,\u897f\u7ea2\u67ff,\u5723\u5973\u679c,\u80e1\u841d\u535c\u756a\u8304\u6ce5,\u756a\u8304\u4e01","cate_id":"341","cover":"http:\/\/7xlmz4.com1.z0.glb.clouddn.com\/data_upload_cook_major_57c7d1cfd5075.jpg","id":"2441","name":"\u756a\u8304","title":"\u756a\u8304\u7684\u8425\u517b\u4ef7\u503c\u548c\u8f85\u98df\u5236\u4f5c\u6280\u5de7","subtitle":""}],"cook_tag":[]},{"name":"\u65f6\u4ee4","id":"339","cook_major":[],"cook_tag":[]},{"name":"\u96f6\u98df\u70b9\u5fc3","id":"338","cook_major":[],"cook_tag":[]},{"name":"\u8425\u517b\u6807\u7b7e","id":"337","cook_major":[],"cook_tag":[]},{"name":"\u6708\u9f84","id":"336","cook_major":[],"cook_tag":[{"cate_id":"336","cover":"","id":"433","name":"\u54c8\u54c8","is_show":"0","title":"\u53d1\u751f\u5730\u65b9","subtitle":"\u6492\u5730\u65b9\u90b5\u8fbe"}]},{"name":"\u7cbe\u9009","id":"335","cook_major":[],"cook_tag":[]},{"name":"\u4e94\u8c37\u6742\u7cae","id":"346","cook_major":[{"is_show":"1","alias":"\u6d0b\u828b,\u8377\u5170\u85af,\u5730\u86cb,\u85af\u4ed4,\u571f\u8c46,\u8377\u5170\u85af,\u756a\u4ed4\u85af","cate_id":"346","cover":"","id":"78","name":"\u9a6c\u94c3\u85af","title":"","subtitle":""},{"is_show":"1","alias":"\u5730\u74dc,\u7ea2\u85af,\u767d\u85af,\u7518\u85af,\u756a\u85af,\u7ea2\u82d5","cate_id":"346","cover":"","id":"142","name":"\u5c71\u828b","title":"","subtitle":""}],"cook_tag":[]}],"status":1,"message":"\u83b7\u53d6\u6570\u636e\u6210\u529f"}
    var curClassify,tagType;
    var classify = data.data ? data.data : {};
    // log(classify);
    for (var i = 0; i < classify.length; i++) {
      var cook_major = classify[i].cook_major ? classify[i].cook_major : {};
      var cook_tag = classify[i].cook_tag ? classify[i].cook_tag : {};
      for (var m = 0; m < cook_major.length; m++) {
        if (cook_major[m].name == name) {
          curClassify = cook_major[m];
          callback(curClassify);
          return;
        } else {
          var alias = cook_major[m].alias.split(",")
            ? cook_major[m].alias.split(",")
            : [];
          for (var a = 0; a < alias.length; a++) {
            if (alias[a] == name) {
              curClassify = cook_major[m];
              callback(curClassify);
              return;
            }
          }
        }
      }
      for (var t = 0; t < cook_tag.length; t++) {
        if (cook_tag[t].name == name) {
          curClassify = cook_tag[t];
          callback(curClassify);
          return;
        }
      }
    }
    callback(curClassify);
    console.log(curClassify);
  });
}

/**
 * param 将要转为URL参数字符串的对象
 * key URL参数字符串的前缀
 * encode true/false 是否进行URL编码,默认为true
 *
 * return URL参数字符串
 */
var urlEncode = function (param,key,encode) {
  if (param == null) return "";
  var paramStr = "";
  var t = typeof param;
  if (t == "string" || t == "number" || t == "boolean") {
    paramStr +=
      "&" +
      key +
      "=" +
      (encode == null || encode ? encodeURIComponent(param) : param);
  } else {
    for (var i in param) {
      var k =
        key == null
          ? i
          : key + (param instanceof Array ? "[" + i + "]" : "." + i);
      paramStr += urlEncode(param[i],k,encode);
    }
  }
  return paramStr;
};

function Trans_php_time_to_str (timestamp,n) {
  update = new Date(timestamp * 1000); //时间戳要乘1000
  year = update.getFullYear();
  month =
    update.getMonth() + 1 < 10
      ? "0" + (update.getMonth() + 1)
      : update.getMonth() + 1;
  day = update.getDate() < 10 ? "0" + update.getDate() : update.getDate();
  hour = update.getHours() < 10 ? "0" + update.getHours() : update.getHours();
  minute =
    update.getMinutes() < 10 ? "0" + update.getMinutes() : update.getMinutes();
  second =
    update.getSeconds() < 10 ? "0" + update.getSeconds() : update.getSeconds();
  if (n == 1) {
    return (
      year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second
    );
  } else if (n == 2) {
    return year + "-" + month + "-" + day;
  } else if (n == 3) {
    return month + "-" + day;
  } else if (n == 4) {
    return month + "." + day;
  } else if (n == 5) {
    return year + "." + month + "." + day;
  } else {
    return 0;
  }
}

function Trans_php_time_to_time_str (timestamp) {
  update = new Date(timestamp * 1000); //时间戳要乘1000
  hour = update.getHours() < 10 ? "0" + update.getHours() : update.getHours();
  minute =
    update.getMinutes() < 10 ? "0" + update.getMinutes() : update.getMinutes();
  return hour + ":" + minute;
}
/*
 * 高位补0
 */
function padNumber (val,fill) {
  var len = ("" + val).length;
  return Array(fill > len ? fill - len + 1 || 0 : 0).join(0) + val;
}

function toNum (a) {
  var a = a.toString();
  //也可以这样写 var c=a.split(/\./);
  var c = a.split(".");
  var num_place = ["","0","00","000","0000"],
    r = num_place.reverse();
  for (var i = 0; i < c.length; i++) {
    var len = c[i].length;
    c[i] = r[len] + c[i];
  }
  var res = c.join("");
  return res;
}

function isEmptyObject (e) {
  var t;
  for (t in e) return !1;
  return !0;
}

function loadingTipsFrm () {
  var type = arguments[0] ? arguments[0] : false;
  if (type) {
    api.setFrameAttr({
      name: "loadingTpl",
      hidden: true,
    });
    return;
  }
  api.setFrameAttr({
    name: "loadingTpl",
    hidden: false,
  });
}

function loadingTips () {
  var tips = [
    "加盖锡纸，可以防止食物上色过深哦。",
    "烤箱内温度很高，拿取烤盘要小心哦。",
    "面团第一次发酵，温度适合在28。",
    "刚烤出炉的食物，需要稍作晾凉后再食用。",
    "烘烤肉质食物，使用上下火大温幅烘烤效果更佳。",
  ];
  var tipsNum = tips.length;
  var rede = parseInt(Math.random() * tipsNum);
  return tips[rede];
}

function initMeiqia () {
  var appVersion = api.appVersion; // 比如: 1.0.0
  //创建美洽
  mq = api.require("meiQia");
  //配置初始化美洽需要的appkey
  var param = {
    appkey: meiQiaAppKey,
  };
  var customizedIdParam = {
    id: "uid" + user.getUid(),
  };
  mq.setLoginCustomizedId(customizedIdParam);

  //初始化美洽
  mq.initMeiQia(param,function (ret,err) {
    if (ret) {
      var info = log4.get_device_base();
      var marketUserInfo = getPrefsWithKey("marketUserInfo");
      var customizedIdParam = {
        id: "uid" + user.getUid(),
      };
      //设置用户信息
      var infoParam = {
        name: user.getUsername(),
        comment: JSON.stringify(info),
        tags: ["APP用户"],
      };
      if (marketUserInfo) {
        infoParam.from = "萌酱酱选APP";
        if (marketUserInfo.nick_name) {
          infoParam.name = marketUserInfo.nick_name;
        }
        if (marketUserInfo.user_id) {
          infoParam.user_id = marketUserInfo.user_id;
          customizedIdParam.id = marketUserInfo.user_id;
        }
        if (marketUserInfo.user_tel) {
          infoParam.tel = marketUserInfo.user_tel;
        }
      }
      mq.setClientInfo(infoParam);

      mq.setTitleBarColor({
        color: "#F7DA6D",
      });

      mq.setLoginCustomizedId(customizedIdParam);

      // var clientIdParam = {
      //     id: ret.clientId
      // };
      // mq.setLoginMQClientId(clientIdParam);

      //初始化成功
      console.log(JSON.stringify(ret));

    } else {
      //初始化失败
      console.log(JSON.stringify(err));
    }
  });
}

function updateMeiqiaInfo () {
  var mq = api.require("meiQia");
  var info = log4.get_device_base();
  var marketUserInfo = getPrefsWithKey("marketUserInfo");
  var customizedIdParam = {
    id: "uid" + user.getUid(),
  };
  //设置用户信息
  var infoParam = {
    name: user.getUsername(),
    comment: JSON.stringify(info),
    tags: ["APP用户"],
  };
  if (marketUserInfo) {
    infoParam.from = "萌酱酱选APP";
    if (marketUserInfo.nick_name) {
      infoParam.name = marketUserInfo.nick_name;
    }
    if (marketUserInfo.user_id) {
      infoParam.user_id = marketUserInfo.user_id;
      customizedIdParam.id = marketUserInfo.user_id;
    }
    if (marketUserInfo.user_tel) {
      infoParam.tel = marketUserInfo.user_tel;
    }
  }
  mq.setClientInfo(infoParam);
  mq.setLoginCustomizedId(customizedIdParam);
}

/**
 * 版本比较 VersionCompare
 * @param {String} currVer 当前版本.
 * @param {String} promoteVer 比较版本.
 * @return {Boolean} false 当前版本小于比较版本返回 true.
 *
 * 使用
 * VersionCompare("6.3","5.2.5"); // false.
 * VersionCompare("6.1", "6.1"); // false.
 * VersionCompare("6.1.5", "6.2"); // true.
 */
var VersionCompare = function (currVer,promoteVer) {
  currVer = currVer || "0.0.0";
  promoteVer = promoteVer || "0.0.0";
  if (currVer == promoteVer) return false;
  var currVerArr = currVer.split(".");
  var promoteVerArr = promoteVer.split(".");
  var len = Math.max(currVerArr.length,promoteVerArr.length);
  for (var i = 0; i < len; i++) {
    var proVal = promoteVerArr[i],
      curVal = currVerArr[i];
    if (proVal < curVal) {
      return false;
    } else if (proVal > curVal) {
      return true;
    }
  }
  return false;
};
/**
 * 检查是否为URL
 *
 * @param      {<type>}   URL     The url
 * @return     {boolean}  { description_of_the_return_value }
 */
function checkURL (URL) {
  var str = URL;
  //判断URL地址的正则表达式为:http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&=]*)?
  //下面的代码中应用了转义字符"\"输出一个字符"/"
  var Expression = /http(s)?:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?/;
  var objExp = new RegExp(Expression);
  if (objExp.test(str) == true) {
    return true;
  } else {
    return false;
  }
}
// console.log = (function(oriLogFunc) {
// 	return function(str) {
// 		// oriLogFunc.call(console, str);

// 	}
// })(console.log);
/**
 * 判断权限是否开启，未开启跳转权限设置页面, android不支持
 * @param String type 权限类型
 * @param Function callback
 */
function setApp (type,callback) {
  var systemType = api.systemType;
  var key = "iosUrl",
    value = "app-settings:";
  var data = {};
  // alert('check')
  if (systemType != "ios") {
    callback();
    return;
  }

  var privacy = api.require("privacy");
  type = type || "camera";
  // alert(type)
  typeText = type == "camera" ? "相机" : "相册";
  if (!type || !callback) {
    console.log("传参");
    return;
  }
  data[key] = value;
  privacy[type](function (ret,err) {
    if (ret && ret.status && typeof callback == "function") {
      // alert('ok');
      callback();
    } else {
      api.confirm(
        {
          title: "提示",
          msg: "此功能需要开启" + typeText + "权限",
          buttons: ["确定","取消"],
        },
        function (ret,err) {
          if (ret && ret.buttonIndex == 2) {
            return;
          }
          if (ret && ret.buttonIndex == 1) {
            api.openApp(data);
          }
        }
      );
    }
  });
}

function setPrefsWithKeyValue (key,value) {
  api.setPrefs({
    key: key,
    value: JSON.stringify(value),
  });
}

function getPrefsWithKey (key) {
  console.log(JSON.stringify(key));
  var value = api.getPrefs({ sync: true,key: key });
  if (value) {
    return JSON.parse(value);
  }
  return value;
}

function launchWeChatMiniProgram (path) {
  if (!path) {
    return;
  }
  var wxPlus = api.require("wxPlus");
  wxPlus.isInstalled(function (ret,err) {
    if (ret.installed) {
      wxPlus.launchMiniProgram(
        {
          miniProgramType: "release",
          userName: "gh_f48087d8b113",
          path: path,
        },
        function (ret,err) {
          if (ret.status) {
            // alert('成功');
          } else {
            // alert(err.code);
          }
        }
      );
    } else {
      alert("请安装微信程序之后再试！");
    }
  });
}

function jumpToMarketPage (url,callBack) {
  if (typeof callBack == "function") {
    return callBack(url);
  }
  if (api.systemType == "ios") {
    webview.view(url);
  } else {
    webview.init(url);
  }
}

function convertCoverFile (cover) {
  if (cover.indexOf("?imageView") > -1) {
    return cover;
  } else if (api.connectionType != "wifi") {
    return cover + "?imageView2/1/w/200/h/150/interlace/1/q/90";
  } else {
    return cover + "?imageView2/1/w/400/h/300/interlace/1/q/80";
  }
}

function covertAvatarFile (avatar,defaultAvatar) {
  var path = avatar ? avatar : defaultAvatar;
  if (!path) return;
  if (path.indexOf("http://wx.qlogo.cn/mmopen/") > -1) {
    //微信头像
    var reg = "//d+$/";
    return path.replace(reg,"/132");
  } else if (path.indexOf("http://wx.qlogo.cn/mmopen/") > -1) {
    //qq头像
  } else {
    //七牛
    return path + "?imageView2/1/w/100/h/100/interlace/1/q/80";
  }
  return path;
}

function isEmptyString (content) {
  var string = content;
  try {
    string = string.replace(/\r\n/g,"");

    string = string.replace(/\\\n/g,"");
  } catch (e) {
    return true;
  }

  return !content || $api.trim(string) == "";
}

function prepareCommonData (type,pageParam) {
  if (!user.is_login()) {
    console.log("非法本次请求：" + token);
    console.log("非法本次请求：" + uid);
    api.alert({
      title: "提示",
      msg: "未登录用户，非法请求" + type + ",frameName：" + api.frameName,
    });
    api.hideProgress();
    return false;
  }

  var token = user.getToken();
  var uid = user.getUid();

  if (typeof token != "undefined") {
    var datas = pageParam;
    datas.deviceId = api.deviceId;
    datas.token = token;
    datas.uid = uid;
    datas.deviceModel = api.deviceModel;
    datas.systemVersion = api.systemVersion;
    datas.systemType = api.systemType;
    datas.appVersion = api.appVersion;
    datas.operator = api.operator; // 比如:中国移动
    datas.connectionType = api.connectionType; //比如: wifi
    datas.deviceName = api.deviceName; // 比如:“柚子”的 iPhone
    return datas;
  }
  return false;
}

function handlerResponse (type,ret,callback,errSelf,err) {
  if (ret) {
    if (ret.status == 1) {
      if (typeof callback === "function") {
        callback(ret);
      }
    } else if (ret.status == 10001) {
      api.sendEvent({
        name: "userLoginPut",
      });
      api.hideProgress();
    } else if (ret.status == 10011) {
      api.sendEvent({
        name: "request_fail",
        extra: {
          code: 10011,
          type: type,
          msg: ret.message,
        },
      });
      if (errSelf) {
        callback(ret,true);
      }
    } else if (ret.status == 10013) {
      api.sendEvent({
        name: "request_fail",
        extra: {
          code: 10011,
          type: type,
          msg: ret.message,
        },
      });
    } else {
      api.hideProgress();
      api.toast({
        msg: ret.message,
        duration: 2000,
        location: "middle",
      });
      console.log("更新数据出错，请稍后重试，错误状态" + ret.status);
    }
  } else {
    // api.toast({
    // 	msg: "由于以" + err.msg + "原因，请求失败",
    // 	duration: 3000,
    // 	location: 'bottom'
    // });
    console.log("-------------请求接口出错开始-------------");
    console.log(JSON.stringify(err));
    console.log("-------------请求接口出错结束-------------");
    errSelf && callback(ret,err);
    if (!errSelf) {
      api.toast({
        msg: err.msg,
        duration: 3000,
        location: "bottom",
      });
    }
    //上报服务器
    api.hideProgress();
    api.sendEvent({
      name: "request_fail",
      extra: {
        code: err.code,
        type: type,
      },
    });
  }
}

/**
 * 用户通用请求处理
 * @param  {[type]}   type      请求地址
 * @param  {[type]}   pageParam [数据]
 * @param  {Function} callback  [回调方法]
 * @param  {[type]}   err       [是否自行做处理]
 * @param {string} url [baseurl是否更改]
 * @return {[type]}             [返回值]
 */
function postRequest (type,pageParam,callback,errSelf) {
  var datas = prepareCommonData(type,pageParam);
  if (!datas) {
    return;
  }
  api.ajax(
    {
      url: serverurl + type,
      method: "post",
      timeout: 30,
      cache: true,
      dataType: "json",
      returnAll: false,
      data: {
        values: datas,
      },
    },
    function (ret,err) {
      handlerResponse(type,ret,callback,errSelf,err);
    }
  );
}

function getRequest (type,pageParam,callback,errSelf) {
  var datas = prepareCommonData(type,pageParam);
  if (!datas) {
    return;
  }
  console.log(JSON.stringify(datas));
  console.log(JSON.stringify(serverurl + type));
  api.ajax(
    {
      url: serverurl + type,
      method: "post",
      timeout: 30,
      cache: true,
      dataType: "json",
      returnAll: false,
      data: {
        values: datas,
      },
    },
    function (ret,err) {
      api.hideProgress();
      handlerResponse(type,ret,callback,errSelf,err);
    }
  );
}

function fxGetRequest (type,pageParam,callback,errSelf) {
  var datas = prepareCommonData(type,pageParam);
  user.get_wx_unionid(function (userinfo) {
    var unionid = userinfo.unionid;
    datas.unionid = unionid;
    api.ajax(
      {
        url: serverurl + type,
        method: "get",
        timeout: 30,
        cache: true,
        dataType: "json",
        returnAll: false,
        data: {
          values: datas,
        },
      },
      function (ret,err) {
        api.hideProgress();
        handlerResponse(type,ret,callback,errSelf,err);
      }
    );
  });
}

function getDateDiff (dateTimeStamp) {
  var publishTime = dateTimeStamp,
    d_seconds,
    d_minutes,
    d_hours,
    d_days,
    timeNow = parseInt(new Date().getTime() / 1000),
    d,
    date = new Date(publishTime * 1000),
    Y = date.getFullYear(),
    M = date.getMonth() + 1,
    D = date.getDate(),
    H = date.getHours(),
    m = date.getMinutes(),
    s = date.getSeconds();
  //小于10的在前面补0
  if (M < 10) {
    M = "0" + M;
  }
  if (D < 10) {
    D = "0" + D;
  }
  if (H < 10) {
    H = "0" + H;
  }
  if (m < 10) {
    m = "0" + m;
  }
  if (s < 10) {
    s = "0" + s;
  }

  d = timeNow - publishTime;
  d_days = parseInt(d / 86400);
  d_hours = parseInt(d / 3600);
  d_minutes = parseInt(d / 60);
  d_seconds = parseInt(d);

  if (d_days > 0 && d_days < 3) {
    return d_days + "天前";
  } else if (d_days <= 0 && d_hours > 0) {
    return d_hours + "小时前";
  } else if (d_hours <= 0 && d_minutes > 0) {
    return d_minutes + "分钟前";
  } else if (d_seconds < 60) {
    if (d_seconds <= 0) {
      return "刚刚";
    } else {
      return d_seconds + "秒前";
    }
  } else if (d_days >= 3 && d_days < 30) {
    return M + "-" + D + " " + H + ":" + m;
  } else if (d_days >= 30) {
    return Y + "-" + M + "-" + D + " " + H + ":" + m;
  }
}

function momentDetail (id) {
  api.openWin({
    name: "momentDetailWin",
    url: api.wgtRootDir + "/html/moment/win_moment_detail.html",
    bounces: false,
    slidBackEnabled: false,
    pageParam: {
      id: id,
    },
  });
}

function goToMomentAdd (cook) {
  api.openWin({
    name: "addMomentWin",
    url: api.wgtRootDir + "/html/moment/win_moment_add.html",
    bounces: false,
    bgColor: "#fff",
    slidBackEnabled: false,
    pageParam: {
      cook: cook,
    },
  });
}

/**
 * 缓存数据
 * @param  {[type]}   folder   [类型]
 * @param  {[type]}   id       [id]
 * @param  {[type]}   url      [请求地址]
 * @param  {Function} callback [回调]
 * @return {[type]}            [回调方法]
 */
function doCacheNew (
  folder,
  id,
  url,
  callback,
  update_now,
  is_only_read,
  params
) {
  var update_now = arguments[4] ? arguments[4] : false;
  var is_only_read = arguments[5] ? arguments[5] : false;

  readFile("/" + folder + "/" + id + ".data",function (ret,err) {
    if (ret.status) {
      if (typeof ret == "undefined") {
        getRequest(url,params,function (ret,err) {
          if (ret) {
            callback(ret);
          }
        });
      }
      var cacheData = ret.data;
      console.log("--------------------");
      console.log(
        "加载缓存文件:" +
        "/" +
        folder +
        "/" +
        id +
        ".data" +
        "页面:" +
        api.frameName
      );
      console.log("加载API URL:" + paths.server.serverBase + url);
      // console.log("加载缓存数据:"+cacheData);
      console.log("--------------------");
      //如果成功，说明有本地存储，读取时转换下数据格式
      //拼装json代码
      //alert('取到缓存');
      if (cacheData !== null) {
        try {
          callback(JSON.parse(cacheData));
        } catch (e) {
          // console.log("加载数据异常了:" + e.message);
          // console.log("缓存数据为:" + cacheData);
          //如果失败则从服务器读取，利用上面的那个ajaxRequest方法从服务器GET数据
          getRequest(url,params,function (ret,err) {
            if (ret) {
              callback(ret);
              //缓存数据
              writeFile(ret,id,folder);
            }
          });
        }
      }
      //再远程取一下数据，防止有更新
      if (is_only_read) {
        return;
      }
      getRequest(url,params,function (ret,err) {
        if (ret) {
          if (cacheData != JSON.stringify(ret)) {
            //有更新处理返回数据
            // alert('更新缓存')

            if (update_now) {
              callback(ret);
              // console.log('------update' + JSON.stringify(ret));
            }
            //缓存数据
            writeFile(ret,id,folder);
            //iCache($('.cache'));
          }
        } else {
          showErrMgs(err.code,err.msg);
        }
      });
    } else {
      //如果失败则从服务器读取，利用上面的那个ajaxRequest方法从服务器GET数据
      var handleErr = folder == "cookDetails";
      getRequest(
        url,
        params,
        function (ret,err) {
          handleErr && callback(ret,err);
          if (ret) {
            callback(ret);
            //缓存数据
            writeFile(ret,id,folder);
          }
        },
        handleErr
      );
    }
  });
}

function getDateFormatByDays (date,days,short) {
  var d = date;
  d.setDate(d.getDate() + days);
  var m = d.getMonth() + 1;
  if (m < 10) {
    m = "0" + m;
  }
  var day = d.getDate();
  if (day < 10) {
    day = "0" + day;
  }
  if (short) {
    return d.getFullYear() + "-" + m + "-" + day;
  }
  return d.getFullYear() + "-" + m + "-" + day + " 0:0:0";
}

function recordUserHistory (type,value) {
  setPrefsWithKeyValue("cache_user_history",{ type: type,value: value });
}

function clearUserHistory () {
  setPrefsWithKeyValue("cache_user_history","");
}

function goToUserHistory () {
  const record = getPrefsWithKey("cache_user_history");
  if (record && record.value) {
    if (record.type == "cook") {
      cook.view(record.value);
      return true;
    } else if (record.type == "web") {
      // alert(JSON.stringify(record));
      // alert(JSON.stringify(value));
      webview.view(record.value);
      return true;
    }
  }
  return false;
}

function getMonDayAndSunDay (datevalue) {
  var dateValue = datevalue;
  var arr = dateValue.split("-");
  //月份-1 因为月份从0开始 构造一个Date对象
  var date = new Date(arr[0],arr[1] - 1,arr[2]);

  var dateOfWeek = date.getDay(); //返回当前日期的在当前周的某一天（0～6--周日到周一）

  var dateOfWeekInt = parseInt(dateOfWeek,10); //转换为整型

  if (dateOfWeekInt == 0) {
    //如果是周日
    dateOfWeekInt = 7;
  }
  var aa = 7 - dateOfWeekInt; //当前于周末相差的天数

  var temp2 = parseInt(arr[2],10); //按10进制转换，以免遇到08和09的时候转换成0
  var sunDay = temp2 + aa; //当前日期的周日的日期
  var monDay = sunDay - 6; //当前日期的周一的日期

  var startDate = new Date(arr[0],arr[1] - 1,monDay);
  var endDate = new Date(arr[0],arr[1] - 1,sunDay);

  var sm = parseInt(startDate.getMonth()) + 1; //月份+1 因为月份从0开始
  var em = parseInt(endDate.getMonth()) + 1;

  var start = startDate.getFullYear() + "-" + sm + "-" + startDate.getDate();
  var end = endDate.getFullYear() + "-" + em + "-" + endDate.getDate();
  var result = new Array();

  return { monday: start,sunday: end };
}

function getCurrentMonthLast (year,month) {
  var date = new Date(year,month - 1,1);
  var currentMonth = date.getMonth();
  var nextMonth = ++currentMonth;
  var nextMonthFirstDay = new Date(date.getFullYear(),nextMonth,1);
  var oneDay = 1000 * 60 * 60 * 24;
  var lastTime = new Date(nextMonthFirstDay - oneDay);
  var month = parseInt(lastTime.getMonth() + 1);
  var day = lastTime.getDate();
  return date.getFullYear() + "-" + month + "-" + day;
}

function isXAbove () {
  return api.systemType == "ios" && api.safeArea.top > 20;
}

function hasPermission (one_per) {
  var perms = new Array();
  if (one_per) {
    perms.push(one_per);
  } else {
    var prs = document.getElementsByName("p_list");
    for (var i = 0; i < prs.length; i++) {
      if (prs[i].checked) {
        perms.push(prs[i].value);
      }
    }
  }
  var rets = api.hasPermission({
    list: perms,
  });
  return !rets || !rets[0] || !rets[0].granted;
}

function reqPermission (one_per,callback) {
  var perms = new Array();
  if (one_per) {
    perms.push(one_per);
  } else {
    var prs = document.getElementsByName("p_list_r");
    for (var i = 0; i < prs.length; i++) {
      if (prs[i].checked) {
        perms.push(prs[i].value);
      }
    }
  }
  api.requestPermission(
    {
      list: perms,
      code: 100001,
    },
    function (ret,err) {
      var list = ret.list;
      var granted = true;
      for (var i in list) {
        if (!list[i].granted) {
          granted = false;
        }
      }
      if (callback) {
        callback(granted);
      }
    }
  );
}

function confirmPer (perm,pemStr) {
  // if (api.systemType == "ios") {
  //   return true;
  // }
  var has = hasPermission(perm);
  if (has) {
    // reqPermission(perm);
    api.confirm(
      {
        title: "提醒",
        msg: "没有获得 " + pemStr + " 权限\n是否前往设置？",
        buttons: ["去设置","取消"],
      },
      function (ret,err) {
        if (1 == ret.buttonIndex) {
          reqPermission(perm);
        }
      }
    );
    return false;
  }
  return true;
}

function saveNetworkImage (url) {
  if (!confirmPer("photos","相册")) {
    return;
  }
  api.showProgress({
    title: "图片下载中",
    text: " 请稍等...",
    modal: true,
  });
  api.download(
    {
      url: url,
    },
    function (ret,err) {
      if (ret.state == 1 && ret.percent == 100) {
        api.saveMediaToAlbum(
          {
            path: ret.savePath,
          },
          function (ret,err) {
            api.hideProgress();
            if (ret && ret.status) {
              api.toast({
                msg: "图片已保存到系统相册",
                duration: 2000,
                location: "middle",
              });
            } else {
              api.toast({
                msg: "请检查网络后重试",
                duration: 2000,
                location: "middle",
              });
            }
          }
        );
      } else {
      }
    }
  );
}
