/*
 * Petrus Class
 * ruby
 * 2016/09/01
 * 
 */
(function() {
	"use strict";
	//EC: 故障 0： 正常 1: E0上传感器开路故障 2: E1上传感器短路故障 3: E2下传感器开路故障 4: E3下传感器短路故障
	//WorkStatus: 工作状态 0: 待机 1: 烘烤中 2: 暂停 3：结束 4：预约 5: 预热 6: 预热完成
	var gizwits = {};
	gizwits.GizwitsSDK = null;
	gizwits.GizwitsDevice = null;
	gizwits.device = {};
	gizwits.macId = null;
	gizwits.did = null;

	gizwits.link = function(callback) {
		api.openWin({
			name: 'petrusLinkStepWin',
			url: api.wgtRootDir + '/html/oven/win_link_step.html',
			delay: 100,
			slidBackEnabled: false,
		});
	}

	gizwits.initApp = function(callback) {
		gizwits.GizwitsSDK = api.require("gizWifiSDK");
		gizwits.GizwitsDevice = api.require("gizWifiDevice");
		gizwits.getVer(function(ret) {
			console.log("版本信息:" + JSON.stringify(ret));
		});
		var bind_device_did = api.getPrefs({
			sync: true,
			key: 'bind_device_did'
		});
		var bind_device_mac = api.getPrefs({
			sync: true,
			key: 'bind_device_mac'
		});
		if (bind_device_did) {
			gizwits.device.mac = bind_device_mac ? bind_device_mac : '';
			gizwits.device.did = bind_device_did ? bind_device_did : '';
			console.log("当前设备绑定烤箱为：" + JSON.stringify(gizwits.device));
		}
		if (api.systemType == 'ios') {
			var params = {
				appID: gizwits.iosAppId
			};
			// log(params);
			gizwits.GizwitsSDK.startWithAppID(params, function(ret, err) {
				if (err) {
					alert("初始化机智云失败");
				} else {
					if (ret.errorCode == 8316) {
						gizwits.login(function() {});
						callback();
						console.log('SDK 机智云初始化成功');
					} else {
						alert("机智云初始化失败");
					}
				}
			});
		} else {
			var params = {
				appID: gizwits.androidAppId
			};
			gizwits.GizwitsSDK.startWithAppID(params, function(ret, err) {
				if (err) {
					alert("初始化机智云失败");
				} else {
					if (ret.errorCode == 8316) {
						gizwits.login(function() {});
						callback();
						console.log('SDK 机智云初始化成功');
					} else {
						alert("机智云初始化失败");
					}
				}
			});
		}
	}

	/*是否绑定过设备*/
	gizwits.is_bind = function() {
		var is_bind_device = api.getPrefs({
			sync: true,
			key: 'is_bind_device'
		});
		if (is_bind_device == "1") {
			return true;
		} else {
			return false
		}
	}

	gizwits.getVer = function(callback) {
		gizwits.GizwitsSDK.getVersion(function(ret, err) {
			if (ret) {
				callback(ret);
			}
		});
	}

	/*清除绑定烤箱状态信息*/
	gizwits.clean = function() {
		api.removePrefs({
			key: 'bind_device_did'
		});
		api.removePrefs({
			key: 'bind_device_mac'
		});
	}

	gizwits.gizWifiDevice = function() {

		gizwits.GizwitsDevice.getHardwareInfo({
			"device": gizwits.device
		}, function(ret, err) {
			console.log("wifi 设备:ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err))
		});
	}


	gizwits.init = function() {
		gizwits.GizwitsSDK = api.require("gizWifiSDK");
		gizwits.GizwitsDevice = api.require("gizWifiDevice");

		var bind_device_did = api.getPrefs({
			sync: true,
			key: 'bind_device_did'
		});
		var bind_device_mac = api.getPrefs({
			sync: true,
			key: 'bind_device_mac'
		});
		if (bind_device_did && bind_device_mac) {
			gizwits.device.mac = bind_device_mac ? bind_device_mac : '';
			gizwits.device.did = bind_device_did ? bind_device_did : '';
		}
	}



	gizwits.registerAppNotifications = function(callback) {

		gizwits.GizwitsSDK.registerNotifications(function(ret, err) {
			if (ret) {
				callback(ret, err);
			} else {
				console.log("获取APP通知失败");
			}
			console.log("收到APP通知 ：ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err));
		});
	}

	gizwits.get_list = function(callback) {
		var params = {
			"uid": this.getUid(),
			"token": this.getToken(),
			specialProductKeys: ['f474bab5cf7f4a1d8c995053af6028f0']
		};
		gizwits.GizwitsSDK.getBoundDevices(params, function(ret, err) {
			console.log("收到设备列表信息 ： ret1 = " + JSON.stringify(ret) + "err1 = " + JSON.stringify(err));
			if (ret) {
				callback(ret);
			} else {
				api.toast({
					msg: '获取设备列表错误'
				});
			}
		});
	}

	gizwits.login = function(callback) {

		gizwits.GizwitsSDK.userLoginAnonymous(function(ret, err) {
			if (err) {} else {
				console.log('机智云登陆信息:' + JSON.stringify(ret));
				callback(ret);
				api.setPrefs({
					key: 'wifi_uid',
					value: ret.uid
				});
				api.setPrefs({
					key: 'wifi_token',
					value: ret.token
				});
			}
		});
	}

	gizwits.getUid = function() {
		return api.getPrefs({
			sync: true,
			key: 'wifi_uid'
		}) || '';
	}

	gizwits.getToken = function() {
		return api.getPrefs({
			sync: true,
			key: 'wifi_token'
		}) || '';
	}


	gizwits.getVersion = function(callback) {

	}

	gizwits.getListInfo = function(callback) {
		gizwits.GizwitsSDK.getListInfo(function(ret, err) {
			if (ret) {

				if (typeof(callback) === 'function') {
					callback(ret);
				}
			} else {
				console.log(" getListInfo 获取设备信息失败:" + JSON.stringify(err));
			}
		})
	}

	/**
	 * * 配置设备路由。
	 * 设备要能连接到WiFi网络，需要先把设备配置到WiFi路由器上。
	 * 配置时，需要给设备发送要配置的路由SSID和密码。
	 * @param {string} app_oven_wifi_ssid WiFi SSID
	 * @param {string} app_oven_wifi_key  WIFI 密码
	 */
	gizwits.setDeviceOnboarding = function(app_oven_wifi_ssid, app_oven_wifi_key, callback) {
		var app_oven_wifi_ssid = arguments[0] ? arguments[0] : api.getPrefs({
			sync: true,
			key: 'app_oven_wifi_ssid'
		});
		var app_oven_wifi_key = arguments[1] ? arguments[1] : api.getPrefs({
			sync: true,
			key: 'app_oven_wifi_key'
		});
		console.log('登陆WIFI SSID：' + app_oven_wifi_ssid);
		console.log('登陆WIFI PASS：' + app_oven_wifi_key);
		var params = {
			"ssid": app_oven_wifi_ssid,
			"key": app_oven_wifi_key,
			"mode": 1,
			"timeout": 60,
			"gagentTypes": [0]
		};
		gizwits.GizwitsSDK.setDeviceOnboarding(params, function(ret, err) {

			if (api.systemType == "android") {
				if (err) {
					if (err.errorCode == 8308) {
						api.alert({
							title: '萌酱酱选提示',
							msg: '请检查WIFI密码后重试连接',
						}, function(ret, err) {});
					} else {
						api.alert({
							title: '萌酱酱选提示',
							msg: '请检查WIFI密码后重试连接',
						}, function(ret, err) {

						});
					}
					user.request(paths.user.wifiLog, {
						params: params,
						error: err,
					}, function(ret) {
						console.log("提交烤箱WIFI LOG成功");
					});
					api.hideProgress();
					console.log("配网失败原因：" + JSON.stringify(err));
				} else {
					api.setPrefs({
						key: 'bind_device_mac',
						value: ret.device.mac
					});
					api.setPrefs({
						key: 'is_bind_device',
						value: '1'
					});
					if (user.is_login()) {
						user.request(paths.user.wifiDevice, ret.device, function(ret) {
							console.log("提交记录成功");
						});
					}
					// {"device":{"mac":"C89346D609F7","did":"N8BM2SW8rpjfFswrNxjSJc","productKey":"f474bab5cf7f4a1d8c995053af6028f0"}}
					console.log("配网成功收到设备信息：" + JSON.stringify(ret));
					callback(ret);

					$api.setStorage('link_device', ret);
					api.setPrefs({
						key: 'link_device',
						value: ret
					});
				}
			} else {
				//ios 配网失败
				if (err !== undefined) {
					if (err.errorCode == 8308) {
						api.alert({
							title: '萌酱酱选提示',
							msg: '请检查WIFI密码后重试连接',
						}, function(ret, err) {});
					} else if (err.errorCode == 8023) {
						api.alert({
							title: '萌酱酱选提示',
							msg: '配网失败，请检查网络后重试',
						}, function(ret, err) {});
					} else {
						api.alert({
							title: '萌酱酱选提示',
							msg: '配网失败，未知原因' + err.errorCode,
						}, function(ret, err) {

						});
					}
					user.request(paths.user.wifiLog, {
						params: params,
						error: err,
					}, function(ret) {
						console.log("提交烤箱WIFI LOG成功");
					});
					// alert("配网失败，未知原因"+JSON.stringify(err));
					api.hideProgress();
					console.log("配网失败原因：" + JSON.stringify(err));
				} else {
					api.setPrefs({
						key: 'bind_device_mac',
						value: ret.device.mac
					});
					api.setPrefs({
						key: 'is_bind_device',
						value: '1'
					});
					if (user.is_login()) {
						user.request(paths.user.wifiDevice, ret.device, function(ret) {
							console.log("提交记录成功");
						});
					}
					// {"device":{"mac":"C89346D609F7","did":"N8BM2SW8rpjfFswrNxjSJc","productKey":"f474bab5cf7f4a1d8c995053af6028f0"}}
					console.log("配网成功收到设备信息：" + JSON.stringify(ret));
					callback(ret);


					$api.setStorage('link_device', ret);
					api.setPrefs({
						key: 'link_device',
						value: ret
					});
				}
			}
			console.log("成功:" + JSON.stringify(ret));
			console.log("失败" + JSON.stringify(err));
			if (!err) {

				//判断是否配网成功
				if (typeof(ret) !== undefined) {
					// log(ret);
					if (ret.device.did !== '') { //报错
						
						var that = this;
						gizwits.GizwitsDevice.setSubscribe({
							"subscribed": true,
							"device": ret.device
						}, function(ret, err) {
							if (ret) {
								api.sendEvent({
									name: 'updateDevice'
								});
								//通知订阅成功，刷新列表
								// api.sendEvent({
								// 	name: 'gizwitsSuccess'
								// });
							} else {
								console.log(JSON.stringify(err));
								// alert("关注设备失败");
								console.log("绑定监听设备失败");
							}
						});
					}
				}
			}
		});
	}

	gizwits.unbind = function(did, mac) {
			// var bind_device_did = api.getPrefs({sync: true,key: 'bind_device_did'});
			var did = arguments[0] ? arguments[0] : bind_device_did;
			var that = this;

			api.showProgress({
				style: 'default',
				animationType: 'fade',
				title: '正在解绑请稍等...',
				text: '先喝杯茶...',
				modal: true
			});
			console.log("正在解绑设备:" + JSON.stringify(gizwits.device));



			var bind_device_mac = api.getPrefs({
				sync: true,
				key: 'bind_device_mac'
			});
			api.removePrefs({
				key: 'is_bind_device'
			});
			gizwits.GizwitsSDK.unbindDevice({
				"uid": that.getUid(),
				"token": that.getToken(),
				"did": did
			}, function(ret, err) {
				if (ret) {


					api.removePrefs({
						key: 'bind_device_did'
					});
					api.removePrefs({
						key: 'bind_device_mac'
					});

					console.log("成功解除设备服务器绑定");
					console.log("ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err));
					api.hideProgress();

					setTimeout(function() {
						api.sendEvent({
							name: 'unbindSuccess',
							extra: {
								macId: bind_device_mac
							}
						});
					}, 500);
					if (user.is_login()) {
						user.request(paths.user.unbindWifiDevice, {
							did: did
						}, function(ret) {
							console.log('解绑设备:' + did);
						});
					}
				} else {
					api.setPrefs({
						key: 'is_bind_device',
						value: '1'
					});
					api.alert({
						title: '提示',
						msg: '解绑设备失败，检查网络环境后请重试',
					}, function(ret, err) {
						if (ret) {}
					});
					console.log("解绑失败:" + JSON.stringify(err));
					api.hideProgress();
				}
			});
			gizwits.GizwitsDevice.setSubscribe({
				"subscribed": false,
				"device": gizwits.device
			}, function(ret, err) {
				if (ret) {
					console.log("取消关注设备:" + JSON.stringify(gizwits.device));
					api.hideProgress();
				} else {
					console.log("解除设备关注失败");
					api.hideProgress();
				}
			});


			// gizwits.GizwitsDevice.setSubscribe({
			// 	"subscribed": false,
			// 	"device": gizwits.device
			// }, function(ret, err) {
			// 	if (ret) {

			// 	};
			// });
		}
		/**
		 * 成功订阅设备
		 */
	gizwits.setSubscribe = function(mac, did) {

		if (typeof(mac) !== "undefined" && typeof(did) !== "undefined") {
			gizwits.device.mac = mac;
			gizwits.device.did = did;
			//手动传参订阅
			console.log("手动传参如下:" + JSON.stringify(gizwits.device));
		}
		var that = this;
		// var gizWifiSDK = api.require('gizWifiSDK');
		gizwits.GizwitsSDK.bindRemoteDevice({
			"uid": that.getUid(),
			"token": that.getToken(),
			"mac": mac,
			'productKey': gizwits.productKey,
			'productSecret': gizwits.productPassword,
		}, function(ret, err) {
			console.log("云端设备绑定成功： ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err))
			if (ret) {
				console.log("成功订阅设备，并且绑定设备信息到缓存");
				//通知订阅成功，刷新列表
				api.sendEvent({
					name: 'gizwitsSuccess'
				});
				var deviceObj = {};
				deviceObj.mac = mac || '';
				deviceObj.did = did || '';
				if (user.is_login()) {
					user.request(paths.user.wifiDevice, deviceObj, function(ret) {
						console.log("提交记录成功");
					});
				}
			} else {
				api.toast({
				    msg: '关注设备失败'
				});
				console.log(JSON.stringify(err));
				// alert("关注设备失败");
				console.log("绑定监听设备失败");
				gizwits.GizwitsDevice.setSubscribe({
					"subscribed": true,
					"device": gizwits.device
				}, function(ret, err) {
					if (ret) {

						console.log("成功订阅设备，并且绑定设备信息到缓存");
						//通知订阅成功，刷新列表
						api.sendEvent({
							name: 'gizwitsSuccess'
						});
						var deviceObj = {};
						deviceObj.mac = mac || '';
						deviceObj.did = did || '';
						if (user.is_login()) {
							user.request(paths.user.wifiDevice, deviceObj, function(ret) {
								console.log("提交记录成功");
							});
						}
					} else {
						console.log(JSON.stringify(err));
						// alert("关注设备失败");
						console.log("绑定监听设备失败");
					}
				});
			}
		});

		gizwits.GizwitsSDK.disableLAN({
			"disabled": true
		}, function(ret, err) {
			// api.toast({
			//     msg: '禁用小循环了'
			// });
		});

		// gizwits.GizwitsDevice.setSubscribe({
		// 	"subscribed": true,
		// 	"device": gizwits.device
		// }, function(ret, err) {
		// 	if (ret) {

		// 		console.log("成功订阅设备，并且绑定设备信息到缓存");
		// 		//通知订阅成功，刷新列表
		// 		api.sendEvent({
		// 			name: 'gizwitsSuccess'
		// 		});
		// 		var deviceObj = {};
		// 		deviceObj.mac = mac || '';
		// 		deviceObj.did = did || '';
		// 		if (user.is_login()) {
		// 			user.request(paths.user.wifiDevice, deviceObj, function(ret) {
		// 				console.log("提交记录成功");
		// 			});
		// 		}
		// 	} else {
		// 		console.log(JSON.stringify(err));
		// 		// alert("关注设备失败");
		// 		console.log("绑定监听设备失败");
		// 	}
		// });
		// log(gizwits.device);
		gizwits.GizwitsDevice.setSubscribe({
			"subscribed": true,
			"device": gizwits.device
		}, function(ret, err) {
			if (ret) {

				console.log("成功订阅设备，并且绑定设备信息到缓存");
				//通知订阅成功，刷新列表
				api.sendEvent({
					name: 'gizwitsSuccess'
				});
				var deviceObj = {};
				deviceObj.mac = mac || '';
				deviceObj.did = did || '';
				if (user.is_login()) {
					user.request(paths.user.wifiDevice, deviceObj, function(ret) {
						console.log("提交记录成功");
					});
				}
			} else {
				console.log(JSON.stringify(err));
				// alert("关注设备失败");
				console.log("绑定监听设备失败");
			}
		});
	}

	gizwits.subscribed = function(did, mac) {
		var did = arguments[0] ? arguments[0] : '';
		gizwits.GizwitsDevice.setSubscribe({
			"subscribed": true,
			"device": {
				"did": did,
				"mac": mac
			}
		}, function(ret, err) {
			// alert("ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err))
			if (ret) {
				setTimeout(function() {
					api.sendEvent({
						name: 'bindSuccess',
					});
				}, 2000);
			} else {
				// alert("关注设备失败");
				console.log("绑定监听设备失败");
			}
		});
	}

	gizwits.getWifiSSID = function(callback) {
		gizwits.GizwitsSDK.getSSIDList(function(ret, err) {
			callback(ret, err);

			console.log("获取wifi列表：" + "ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err))
		});
	}

	gizwits.registerDev = function(callback) {
		var callback = arguments[0] ? arguments[0] : {};
		console.log("监听设备为:" + JSON.stringify(gizwits.device));
		gizwits.GizwitsDevice.registerNotifications({
			"device": gizwits.device
		}, function(ret, err) {
			if (ret) {
				if (typeof callback === "function") {
					callback(ret, err);
				}
			} else {
				console.log("监听设备变化失败:" + JSON.stringify(err));
			}
		});
	}


	gizwits.getDeviceStatus = function(callback) {
		var errCallback = arguments[1] ? arguments[1] : function() {};

		gizwits.GizwitsDevice.getDeviceStatus({
			"device": gizwits.device
		}, function(ret, err) {
			if (ret) {
				callback(ret);
			} else {
				errCallback(err);
				// log(err);
				// alert("获取烤箱状态失败")
				console.log("获取烤箱状态:ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err))
				api.hideProgress();
			};
		});
	}

	gizwits.writeData = function(cloud, callback) {
		// var link_device = api.getPrefs({sync: true,key: 'link_device'})
		// var link_device = $api.getStorage('link_device');
		var GizWifiBinary = api.require("gizWifiBinary");
		console.log("下发设备为:" + JSON.stringify(gizwits.device));
		gizwits.GizwitsDevice.write({
			"device": gizwits.device,
			"data": cloud,
		}, function(ret, err) {
			if (ret) {
				callback();
			} else {
				if (err.errorCode == 8031) {
					api.alert({
						title: '提示',
						msg: '请检查烤箱网络网络电源后重试',
					}, function(ret, err) {
						if (ret) {
							// alert(JSON.stringify(ret));
						} else {
							// alert(JSON.stringify(err));
						}
					});
				} else if (err.errorCode == 8029) {
					api.alert({
						title: '提示',
						msg: '设备未订阅',
					}, function(ret, err) {
						if (ret) {
							// alert(JSON.stringify(ret));
						} else {
							// alert(JSON.stringify(err));
						}
					});
				} else if (err.errorCode == 8034) {
					api.alert({
						title: '提示',
						msg: '设备控制指令执行失败',
					}, function(ret, err) {
						if (ret) {
							// alert(JSON.stringify(ret));
						}
					});
				} else if (err.errorCode == 8308) {
					api.alert({
						title: '提示',
						msg: '设备控制指令执行失败，请重启APP 再次下发',
					}, function(ret, err) {
						if (ret) {
							// alert(JSON.stringify(ret));
						}
					});
				} else {
					api.alert({
						title: '提示',
						msg: '执行失败',
					}, function(ret, err) {
						if (ret) {}
					});
				}
				// log(err);
			}
			// log(ret);
			console.log("下发指令为：ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err));
		});
		//数组编码字符串
		// var src = [0x02, 0x00, 0x1E, 0x1E, 0xFF, 0xFF,
		// 	0x02, 0x10, 0x1E, 0xDC, 0x00, 0x14,
		// 	0x02, 0x10, 0xC8, 0xC8, 0x00, 0x0A,
		// 	0x02, 0x00, 0x1E, 0x1E, 0xFF, 0xFF
		// ];
		// if (link_device.device.mac) {
		// 	alert("设备bu'c")
		// 	return;
		// }
		// 07 10001 DCDC 


		// 00x7 0x1A 0xB4 0xAA 0x00 00x14
		// var src2 = "AQIDBA==";
		// GizWifiBinary.encode({"binaryData": src}, function(ret, err) {
		// 	console.log("编码：" + JSON.stringify(ret));
		// 		var data = {
		// 			"KG_Cancel": "0",
		// 			"WorkStatus": "0",
		// 			"WorkMode": "0", //默认0
		// 			"KG_Top": "1",
		// 			"KG_Bottom": "1",
		// 			"KG_Fan": "0",
		// 			"KG_Light": "0",
		// 			"PowerMode": "2",
		// 			"Ref_Mode": "2",
		// 			"KG_Turn": "0",
		// 			"Temp_Top": "100",
		// 			"Temp_Bottom": "130",
		// 			"Time_Top": "40",
		// 			"Time_Bottom": "20",
		// 			"WF_CurrentStep": "1",
		// 			"StepNum": "10",
		// 			"WorkTime": "40", //工作时间
		// 			"WF_TimeLeft": "0",
		// 			"WF_ID":101, //菜单号
		// 			"extSteps": ret.binary, //透传
		// 		};
		// 		// log(writeData);
		// 		console.log("发送数据内容："+JSON.stringify(cloud));
		// });
		// KG_Cancel, 类型为enum, 值为1: 字段bit0~bit0, 字段值为0b1;
		// WorkStatus, 类型为enum, 值为6: 字段bit3~bit1, 字段值为0b110;
		// WorkMode, 类型为enum, 值为1: 字段bit4~bit4, 字段值为0b1;
		// KG_Top, 类型为enum, 值为1: 字段bit5~bit5, 字段值为0b1;
		// KG_Bottom, 类型为enum, 值为1: 字段bit6~bit6, 字段值为0b1;
		// KG_Fan, 类型为enum, 值为1: 字段bit7~bit7, 字段值为0b1;
		// KG_Light, 类型为enum, 值为1: 字段bit8~bit8, 字段值为0b1;
		// PowerMode, 类型为enum, 值为6: 字段bit11~bit9, 字段值为0b110;
		// Ref_Mode, 类型为enum, 值为7: 字段bit14~bit12, 字段值为0b111;
		// KG_Turn, 类型为enum, 值为1: 字段bit15~bit15, 字段值为0b1;
	}


	gizwits.stopWork = function(callback) {
		var stopdata = {
			"KG_Cancel": "1"
		}
		gizwits.writeData(stopdata, function() {
			api.setPrefs({
				key: 'is_wokeing',
				value: '0'
			});
			callback();
		})
	}

	gizwits.writeDataCloudTest = function(callback) {
		var link_device = $api.getStorage('link_device');
		var bind_device_did = api.getPrefs({
			sync: true,
			key: 'bind_device_did'
		});
		var GizWifiBinary = api.require("gizWifiBinary");
		//数组编码字符串
		// var src = [0x02,0x00,0x1E,0x1E,0xFF,0xFF,0x02,0x10,0x1E,0xDC,0xFF,0xF0];
		var src = [0x02, 0x00, 0x2D, 0x2D, 0xFF, 0xFF,
			0x02, 0x00, 0xB4, 0xB4, 0x00, 0x11
		];
		// var src = [0x02, 0x00, 0x1E, 0x1E, 0xFF, 0xFF,
		// 	0x02, 0x10, 0xC8, 0xC8, 0x00, 0x14,
		// 	0x02, 0x10, 0xC8, 0xC8, 0x00,  0x0A,
		// 	0x02, 0x00, 0x1E, 0x1E, 0xFF, 0xFF,
		// 	0x02, 0x10, 0x1E, 0xDC, 0x00, 0x14,
		// 	0x02, 0x10, 0xC8, 0xC8, 0x00, 0x0A,
		// 	0x02, 0x00, 0x1E, 0x1E, 0xFF, 0xFF,
		// 	0x02, 0x10, 0x1E, 0xDC, 0x00, 0x14,
		// ];
		GizWifiBinary.encode({
			"binaryData": src
		}, function(ret, err) {
			console.log("编码：" + JSON.stringify(ret));
			var data = {
				"KG_Cancel": "0",
				"WorkStatus": "0",
				"WorkMode": "0", //默认0
				"KG_Top": "1",
				"KG_Bottom": "1",
				"KG_Fan": "0",
				"KG_Light": "0",
				"PowerMode": "2",
				"Ref_Mode": "2",
				"KG_Turn": "0",
				"Temp_Top": "100",
				"Temp_Bottom": "130",
				"Time_Top": "40",
				"Time_Bottom": "20",
				"WF_CurrentStep": "1",
				"StepNum": "2",
				"WorkTime": "40", //工作时间
				"WF_TimeLeft": "0",
				"WF_ID": 101, //菜单号
				"extSteps": ret.binary, //透传
			};
			// log(writeData);
			// console.log("发送数据内容："+JSON.stringify(cloud));
			gizwits.GizwitsDevice.write({
				"device": gizwits.device,
				"data": data,
			}, function(ret, err) {
				if (ret) {
					callback();
					// var devicesParam = {};
					// devicesParam.did = bind_device_did;
					// devicesParam.macId = link_device.device.mac;
					petrus.openViewConsole(gizwits.device);
				} else {

				}
				// log(ret);
				console.log("ret = " + JSON.stringify(ret) + "err = " + JSON.stringify(err))
			});
		});
	}

	/**
	 * 获取SSID账号
	 */
	gizwits.getWifi = function(callback) {
		gizwits.GizwitsSDK.getPhoneSSID(function(ret, err) {
			if (ret && ret.SSID) {
				api.setPrefs({
					key: 'app_oven_wifi_ssid',
					value: ret.SSID
				});
				if ((ret.SSID.indexOf("XPG-GAgent")) != -1) {
					return;
				} else {
					callback(ret);
				}
			} else {
				// log(err);
				if (err.errorCode == 8313) {
					api.alert({
						title: '萌酱酱选提醒',
						msg: '未检测到WIFI请检查后重试',
					}, function(ret, err) {
						if (ret) {
							api.closeWin();
						}
					});
				} else {
					api.alert({
						title: '萌酱酱选提醒',
						msg: err.msg,
					}, function(ret, err) {
						if (ret) {}
					});
				}
				// alert(err);
			}
		});
	}

	gizwits.productKey = 'f474bab5cf7f4a1d8c995053af6028f0';
	gizwits.productPassword = '25b530b9fae343b5a1500ee91e792169';
	gizwits.iosAppId = 'e06dbaaeb46e4504aa000f63272f3e28';
	gizwits.iosAppSecret = '716e7610539e4ded966c0cc89a64ef99';
	gizwits.androidAppId = '96921f2080a84d0488e2578494436cac';
	gizwits.androidAppSecret = 'a39b3c87f6bb4abb999addf6edf7bac2';
	gizwits.isLogin = false;
	gizwits.softMode = 1;
	gizwits.airlinkMode = 2;

	window.gizwits = gizwits;
})();
/**
 * Created 
 */
function Device() {
	Device.mac = "";
	Device.did = "";
	Device.passcode = "";
	Device.isDisabled = "";
	Device.isOnline = "";
	Device.isLAN = "";
	Device.isBind = "";
}

function cook_cloud() {
	var data = {
		"KG_Cancel": "0",
		"WorkStatus": "0",
		"WorkMode": "0", //默认0
		"KG_Top": "1",
		"KG_Bottom": "1",
		"KG_Fan": "0",
		"KG_Light": "0",
		"PowerMode": "2",
		"Ref_Mode": "2",
		"KG_Turn": "0",
		"Temp_Top": "100",
		"Temp_Bottom": "130",
		"Time_Top": "40",
		"Time_Bottom": "20",
		"WF_CurrentStep": "1",
		"StepNum": "10",
		"WorkTime": "40", //工作时间
		"WF_TimeLeft": "0",
		"WF_ID": 102, //菜单号
		"extSteps": "", //透传
	}
	return data;
}