var jg = {
    //初始化
    ajpush: function() {
        //引入极光包
        var ajpush = api.require('ajpush');
        return ajpush;
    },
    //初始化
    init: function() {
        var ajpush = jg.ajpush();
        ajpush.init(function(ret) {
            // alert(JSON.stringify(ret));
            if (ret && ret.status) {
                //success
            }
        });
    },
    //设置消息监听，若iOS应用在前台运行，此时收到推送后也通过此方法回调
    setListener: function(fun) {
        var ajpush = jg.ajpush();
        ajpush.setListener(
            function(ret) {
                fun(ret);
            }
        );
    },
    //移除消息监听
    removeListener: function() {
        var ajpush = jg.ajpush();
        ajpush.removeListener();
    },
    //绑定用户别名和标签。服务端可以指定别名和标签进行消息推送
    bindAliasAndTags: function() {
        var ajpush = jg.ajpush();
        var param = {
            alias: 'myalias',
            tags: ['tag1', 'tag2']
        };
        ajpush.bindAliasAndTags(param, function(ret) {
            var statusCode = ret.statusCode;
        });
    },
    //通知极光推送SDK当前应用恢复到前台。
    onResume: function() {
        api.addEventListener({
            name: 'resume'
        }, function(ret, err) {
            var ajpush = jg.ajpush();
            ajpush.onResume();
        });
    },
    //通知极光推送SDK当前应用退入到后台
    onPause: function() {
        api.addEventListener({
            name: 'pause'
        }, function(ret, err) {
            var ajpush = jg.ajpush();
            ajpush.onPause();
        });
    },
    //清除极光推送发送到状态栏的通知。
    //待清除的通知id（等同于消息ID），为-1时清除所有，iOS只支持清除所有，不能为空
    clearNotification: function() {
        var ajpush = jg.ajpush();
        var param = {
            id: -1
        };
        ajpush.clearNotification(param, function(ret) {
            if (ret && ret.status) {
                //success
            }
        });
    },
    //设置允许推送时间，只Android有效
    //允许推送的日期，0表示星期天，1表示星期一，以此类推，（7天制，数组里面的每项范围为0到6），不能为空
    setPushTime: function() {
        var ajpush = jg.ajpush();
        var params = {};
        params.days = [1, 2];
        params.startHour = 8; //允许推送的开始时间（24小时制：startHour的范围为0到23），不能为空
        params.endHour = 20; //允许推送的结束时间（24小时制：endHour的范围为0到23），不能为空
        ajpush.setPushTime(params, function(ret) {
            if (ret && ret.status) {
                //success
            }
        });
    },
    //设置通知静默时间，只Android有效
    setSilenceTime: function() {
        var ajpush = jg.ajpush();
        var params = {}; //静音时段的开始小时（24小时制，范围：0~23），不能为空
        params.startHour = 8; //静音时段的开始小时（24小时制，范围：0~23），不能为空
        params.startMinute = 0; //静音时段的开始分钟（范围：0~59），不能为空
        params.endHour = 20; //静音时段的结束小时（24小时制，范围：0~23），不能为空
        params.endMinute = 59; //静音时段的结束分钟（范围：0~59），不能为空
        ajpush.setPushTime(params, function(ret) {
            if (ret && ret.status) {
                //success
            }
        });
    },
    //停止Push推送。
    stopPush: function() {
        var ajpush = jg.ajpush();
        ajpush.stopPush(function(ret) {
            if (ret && ret.status) {
                //操作成功状态值，1-成功，0-失败
                //success
            }
        });
    },
    //恢复Push推送。
    resumePush: function() {
        var ajpush = jg.ajpush();
        ajpush.resumePush(function(ret) {
            if (ret && ret.status) {
                //操作成功状态值，1-成功，0-失败
                //success
            }
        });
    },
    //查询当前推送服务是否停止。
    isPushStopped: function() {
        var ajpush = jg.ajpush();
        ajpush.isPushStopped(function(ret) {
            if (ret && ret.isStopped) {
                //推送服务是否停止状态，1-停止，0-未停止
            }
        });
    },
    //设置应用图标右上角数字，只iOS有效。
    //为0时清除应用图标数字，大于0时设置应用图标数字，同时该值会更新到激光推送服务器，不能为空
    setBadge: function() {
        var ajpush = jg.ajpush();
        ajpush.setBadge({
            badge: 0
        });
    },
    //集成了JPush SDK的应用程序在第一次成功注册到JPush服务器时，
    //JPush服务器会给客户端返回一个唯一的该设备的标识RegistrationID。
    //JPush SDK会以广播的形式发送RegistrationID到应用程序。
    //应用程序可以把此RegistrationID保存于自己的应用服务器上，
    //然后就可以根据 RegistrationID来向设备推送消息或者通知
    getRegistrationId: function() {
        var ajpush = jg.ajpush();
        ajpush.getRegistrationId(function(ret) {
            var registrationId = ret.id;
        });
    },
    /*
     在Android平台，使用极光推送发送通知、消息等类型推送时，
     极光推送模块会往设备状态栏上发送通知，当通知被点击后，
     APICloud会将本次推送的内容通过事件监听回调的方式交给开发者。具体使用如下：
     */
    AndroidJT: function() {
        api.addEventListener({
            name: 'appintent'
        }, function(ret, err) {
            if (ret && ret.appParam.ajpush) {
                var ajpush = ret.appParam.ajpush;
                var id = ajpush.id;
                var title = ajpush.title;
                var content = ajpush.content;
                var extra = ajpush.extra;
            }
        })
    },
    /*
     在iOS平台，使用极光推送发送通知时，若应用在前台运行，
     则推送内容可以通过setListener方法监听到，若应用在后台，
     系统会往设备通知栏发送通知，当通知被点击后，
     APICloud会将本次推送的内容通过事件监听回调的方式交给开发者。具体使用如下：
    */
    iosJT: function() {
        api.addEventListener({
            name: 'noticeclicked'
        }, function(ret, err) {
            if (ret && ret.value) {
                var ajpush = ret.value;
                var content = ajpush.content;
                var extra = ajpush.extra;
            }
        })
    }
};
