(function(window) {
    "use strict";
    var doc = window.document;
    /**
     * APICloud 延迟加载模块
     */
    function LazyLoad() {
        this.options = {
            selector: "img.ui-imglazy",
            holder: "data-img",
        };
    };
    LazyLoad.prototype.init = function(selector, holder) {
        var self = this,
            o = self.options,
            ios = navigator.appVersion.match(/(iPhone\sOS)\s([\d_]+)/),
            isIos = ios && !0 || !1,
            isoVersion = isIos && ios[2].split("_");
        if (arguments.length == 1 && typeof selector == "object") {
            for (var attr in selector) {
                o[attr] = selector[attr];
            }
        } else {
            selector && (this.options.selector = selector);
            holder && (this.options.holder = holder);
        }

        isoVersion = isoVersion && parseFloat(isoVersion.length > 1 ? isoVersion.splice(0, 2).join(".") : isoVersion[0], 10),
            isIos = self.isPhone = isIos && isoVersion < 10;

        self.imgs = Array.prototype.slice.call(doc.querySelectorAll(o.selector), 0);
        self._show();
        if (isIos) {
            //触发
            window.addEventListener("touchend", function(e) {
                if (e && e.changedTouches) {
                    self._show();
                } else {
                    self._show();
                }
            })
            window.addEventListener("scroll", function(event) {
                self._show();
            })
        } else {
            window.addEventListener("scroll", function(event) {
                self._show();
            })
        }

    };
    LazyLoad.prototype._show = function() {
        var self = this,
            imgs = self.imgs;
        for (var i = 0; i < imgs.length; i++) {
            var node = imgs[i];
            if (!node.getAttribute("loaded") && self._inView(node)) {
                self.load(node)
            }
        }
    };
    LazyLoad.prototype._inView = function(node) {
        var o = this.options,
            min = window.pageYOffset - Math.floor(window.innerHeight / 1),
            max = window.pageYOffset + Math.floor(window.innerHeight * 4),
            rect = node.getBoundingClientRect(),
            top = rect.top + window.pageYOffset

        return top >= min && top <= max
    };
    LazyLoad.prototype._checkUrl = function(urlString) {
        if (urlString != "") {
            var reg = /(http|ftp|https):\/\/[\w\-_]+(\.[\w\-_]+)+([\w\-\.,@?^=%&:/~\+#]*[\w\-\@?^=%&/~\+#])?/;
            if (!reg.test(urlString)) {
                return false;
            } else {
                return true;
            }
        }
    };
    LazyLoad.prototype.load = function(node) {
        var self = this;
        var href = node.getAttribute(this.options.holder),
            img = new Image();
        img.addEventListener("error", function() {
            node.setAttribute("src", href);
        });
        if (typeof(api) !== "undefined") {
            //创建加载过程
            var url = href;
            var pos = url.lastIndexOf("/data");
            var filename = MD5(url.substring(pos + 1));
            var path = api.cacheDir + "/pic/" + filename;
            var obj = api.require('fs');
            
            // var obj = fs.existSync({
            //     path: path
            // });

            // api.toast({
            //     msg: "正在加载图片"+href
            // });
            // api.imageCache({
            //     url: href,
            //     thumbnail:false,
            // }, function(ret, err) {
            //     var path = ret.url;
            //     if (ret.status) {
            //         img.addEventListener("load", function() {
            //             node.setAttribute("src", path);
            //         });
            //         img.src = path;
            //         node.setAttribute("loaded", "true");
            //     } else {
            //         node.style.opacity = 0.6;
            //         img.addEventListener("load", function() {
            //             node.setAttribute("src", href);
            //             node.style.setProperty("-webkit-transition", "400ms");
            //             node.style.setProperty("transition", "400ms");
            //             node.style.opacity = 1;
            //         });
            //         img.src = href;
            //         node.setAttribute("loaded", "true");
            //     }

            // });

            obj.exist({
                path: path
            }, function(ret, err) {
                if (obj.exist) {
                    if (!ret.directory) {
                        img.addEventListener("load", function() {
                            node.setAttribute("src", path);
                        });
                        img.src = path;
                        node.setAttribute("loaded", "true");
                    }
                } else {
                    setTimeout(function() {
                        node.style.opacity = 0.6;
                        img.addEventListener("load", function() {
                            node.setAttribute("src", href);
                            node.style.setProperty("-webkit-transition", "400ms");
                            node.style.setProperty("transition", "400ms");
                            node.style.opacity = 1;
                        });
                        img.src = href;
                        node.setAttribute("loaded", "true");
                    }, 10);

                    if (self._checkUrl(href)) {
                        api.download({
                            url: href,
                            savePath: path,
                            report: false,
                            cache: true,
                            allowResume: true
                        }, function(ret, err) {
                            //msg(ret);
                            if (ret) {
                                var value = ('文件大小：' + ret.fileSize + '；下载进度：' + ret.percent + '；下载状态' + ret.state + '存储路径: ' + ret.savePath);
                                // console.log(value);
                            }
                        });
                    }
                }
            });
        } else {
            
            node.style.opacity = 0.6;
            img.addEventListener("load", function() {
                node.setAttribute("src", href);
                node.style.setProperty("-webkit-transition", "400ms");
                node.style.setProperty("transition", "400ms");
                node.style.opacity = 1;
            });

            img.src = href;
            node.setAttribute("loaded", "true");
        }
    };
    window.LazyLoad = new LazyLoad()
}(window));