var pay;
(function (pay) {
  const payType = {
    ali: "aliPayTradePlus",
    wx: "wxPayPlus",
  };
  var callBack;

  pay.init = function (type, call) {
    if (typeof type === "function") callBack = type;
    if (typeof call === "function") callBack = call;
    if (typeof type === "string") return payOrder(type);
    else
      return {
        aliPay: payOrder("ali"),
        wxPay: payOrder("wx"),
      };
  };

  function payOrder(type) {
    var plus = payType[type];
    var payPlus = api.require(plus);
    return function (config) {
      payPlus.payOrder(config, payCallBack(type));
    };
  }

  function payCallBack(type) {
    if (type === "ali") {
      return payCallBackAli;
    }

    if (type === "wx") {
      return payCallBackWx;
    }
  }

  function payCallBackAli(ret, err) {
    var message;
    switch (ret && ret.code) {
      case "9000":
        message = "支付成功";
        break;
      case "8000":
        message =
          "正在处理中，支付结果未知（有可能已经支付成功），请查询商户订单列表中订单的支付状态";
        break;
      case "4000":
        message = "订单支付失败";
        break;
      case "5000":
        message = "重复请求";
        break;
      case "6001":
        message = "取消支付"; // "用户中途取消支付操作";
        break;
      case "6002":
        message = "网络连接出错";
        break;
      case "6004":
        message =
          "支付结果未知（有可能已经支付成功），请查询商户订单列表中订单的支付状态";
        break;
      default:
        message = "";
    }

    var returnCode = "";
    if (ret && ret.status) {
      message = "支付成功";
      returnCode = "success";
    } else {
      returnCode = "error";
    }
    if (message) {
      api.toast({ msg: message, duration: 1000 });
    }
    if (callBack) {
      setTimeout(function () {
        callBack(returnCode, message);
      }, 1000);
    }
  }

  function payCallBackWx(ret, err) {
    var message;
    switch (err && err.code) {
      case 1:
        message = "apiKey值非法";
        break;
      case -1:
        message = "支付异常";
        break;
      case -2:
        message = "取消支付"; // "用户取消支付";
        break;
      case 2:
        message = "支付异常";
        break;
      default:
        message = "";
    }
    var returnCode = "";
    if (ret && ret.status) {
      message = "支付成功";
      returnCode = "success";
    } else {
      returnCode = "error";
    }
    if (message) api.toast({ msg: message, duration: 1000 });
    if (callBack) {
      setTimeout(function () {
        callBack(returnCode, message);
      }, 1000);
    }
  }
})(pay || (pay = {}));
