/*
 * Petrus Class
 * ruby
 * 2016/09/01
 */
(function () {

	/*
		1、JSON 结构
		2、烤箱状态
		3、自动和手动工作模式
		4、预警系统
		5、
	 */
	"use strict";

	var petrus = {};

	petrus.deviceStatus = '';
	petrus.deviceName = '';
	petrus.deviceId = '';


	/**
	 * 打开烤箱操作页面
	 */
	petrus.link = function () {
		if (!user.is_login()) {
			user.login();
			return;
		}
		api.openWin({
			name: 'petrusLinkWin',
			url: api.wgtRootDir + '/html/oven/win_link.html',
			delay: 300,
			pageParam: {
			}
		});
	}
	/**
	 * 打开控制台
	 */
	petrus.openViewConsole = function (devicesParam, consoleType) {
		var consoleType = arguments[1] ? arguments[1] : 'use';
		var cook_id = arguments[2] ? arguments[2] : 0;
		var cook_task = arguments[3] ? arguments[3] : 0;
		var bind_device_mac = api.getPrefs({ sync: true, key: 'bind_device_mac' });

		api.openWin({
			name: 'frm_console_' + bind_device_mac,
			url: api.wgtRootDir + "/html/oven/frm_console.html",
			rect: {
				x: 0,
				y: 0,
				w: 'auto',
				h: 'auto'
			},
			slidBackEnabled: true,
			useWKWebView: false,
			pageParam: {
				devicesParam: devicesParam,
				consoleType: consoleType,
				cook_id: cook_id,
				cook_task: cook_task
			},
			bounces: false
		});
	}

	/**
	 * 关闭烤箱链接页面
	 */
	petrus.closelLink = function () {
		api.closeWin({
			name: 'petrusLinkWin'
		});
	}
	/**
	 * 打开云菜谱控制台
	 */
	petrus.openCloud = function (macId, did) {
		if (!user.is_login()) {
			user.login();
			return;
		}
		if (!macId) {
			alert("没有可操作烤箱");
			return;
		}
		var macId = arguments[0] ? arguments[0] : '';
		var did = arguments[1] ? arguments[1] : '';
		api.openWin({
			name: 'win_cloud_oven_' + macId,
			url: api.wgtRootDir + '/html/oven/win_cloud.html',
			delay: 300,
			pageParam: {
				macId: macId,
				did: did
			}
		});
	}
	petrus.openConsole = function (macId, did) {
		if (typeof (macId) === undefined) {
			alert("没有可操作烤箱");
			return;
		}
		var macId = arguments[0] ? arguments[0] : '';
		var did = arguments[1] ? arguments[1] : '';
		var is_run = arguments[2] ? arguments[2] : 0;
		api.openWin({
			name: 'win_cloud_console',
			url: api.wgtRootDir + '/html/oven/win_cloud_console.html',
			delay: 300,
			slidBackEnabled: false,
			pageParam: {
				macId: macId,
				did: did,
				is_run: is_run,
			}
		});
	}

	petrus.endLink = function () {
		petrus.closelLink();
		api.closeWin({
			name: 'petrusLinkStepWin'
		});
	}

	petrus.info = function () {
		api.alert({
			msg: "暂无介绍"
		});
	}
	window.petrus = petrus;//创建对象
})();