/*
 * Menu Class
 * ruby
 * 2016/02/16
 */
(function () {

	"use strict";

	var UISearch = {};

	UISearch.storageName = "_historyList";

	UISearch.open = function () {
		var is_cloud = arguments[0] ? arguments[0] : 0;
		var is_user = arguments[1] ? arguments[1] :0;
		api.openWin({
			name: 'UISearchWin',
			url: api.wgtRootDir + "/html/win_search.html",
			delay: 200,
			bounces: false,
			slidBackEnabled: false,
			animation: {
				type: "none", //动画类型（详见动画类型常量）
				subType: "from_top", //动画子类型（详见动画子类型常量）
				duration: 200 //动画过渡时间，默认300毫秒
			},
			pageParam: {
				is_cloud: is_cloud,
				is_user:is_user
			}
		});
	};

	UISearch.openCook = function () {
		var keyword = arguments[0] ? arguments[0] : '';
		var type = arguments[1] ? arguments[1] : 'cook';
		if (keyword == '') {
			api.alert({
				title: '提示',
				msg: '搜索关键词不能为空'
			});
			return;
		};
		var is_cloud = arguments[2] ? arguments[2] : 0;
		api.openWin({
			name: 'UISearchCookWin',
			url: api.wgtRootDir + "/html/win_search_cook.html",
			delay: 300,
			bounces: false,
			animation: {
				type: "none", //动画类型（详见动画类型常量）
				subType: "from_top", //动画子类型（详见动画子类型常量）
				duration:300 //动画过渡时间，默认300毫秒
			},
			pageParam: {
				keyword: keyword.replace(/"/g, '\\"').replace(/\n/g,'\\n').replace(/\r/g, '\\r'),
				type: type,
				is_cloud: is_cloud
			}
		});
	}

	UISearch.closeCook = function () {

		api.closeWin({
			name: 'UISearchCookWin',
			animation: {
				type: "none", //动画类型（详见动画类型常量）
				subType: "from_top", //动画子类型（详见动画子类型常量）
				duration: 0 //动画过渡时间，默认300毫秒
			}
		});
	}


	UISearch.addItem = function (keyword,type) {
		var type = arguments[1]?arguments[1]:'cook';
		var _historyList = $api.getStorage(UISearch.storageName) || new Array();
		// _historyList.push('test','test1','test3');
		var log_item = {
			keyword:keyword,
			type:type,
		};
		if (_historyList.length >= 1) {
			console.log(_historyList.length);
			if (_historyList.length >= 9) {
				_historyList.splice(0, 1);
				_historyList.push(log_item);
			} else {
				_historyList.push(log_item);
			}
			console.log(_historyList);
			$api.setStorage(UISearch.storageName, _historyList);

		} else {
			console.log('---搜索记录关键词数组为空---');
			_historyList.push(log_item);
			$api.setStorage(UISearch.storageName, _historyList);
		}
	}

	UISearch._historyList=function(){
		return $api.getStorage(UISearch.storageName) || new Array();;
	}

	UISearch.delItem = function (obj) {

		if (obj !== undefined) {
			var $item = $api.closest(obj, ".history-item");
			var keyword = obj.getAttribute("data-txt");
			if ($item) {
				var _historyList = $api.getStorage(UISearch.storageName) || new Array();
				for (var i = 0; i < _historyList.length; i++) {
					if (keyword==_historyList[i].keyword ) {
						_historyList.remove(i);
					}
				}
				$api.setStorage(UISearch.storageName, _historyList);
				$api.remove($item);
			};
		};
	}

	UISearch.viewItem = function (obj) {
		if (obj !== undefined) {
			var keyword = obj.getAttribute("data-txt");
			var type = obj.getAttribute("data-type");
			if (keyword) {
				this.openCook(keyword,type);
			}else{
				console.log('非法操作');
			}
		};
	}

	UISearch.setList = function () {
		var _historyList = $api.getStorage('_historyList') || new Array();
		var gettpl = document.getElementById("historyListTpl").innerHTML;
		laytpl(gettpl).render(_historyList, function (html) {
			var doc = $api.byId("historyList");
			doc.innerHTML = html;
			api.parseTapmode();
		});
	}

	UISearch.cancel = function () {
		api.closeWin({
			name: 'UISearchWin',
			animation: {
				type: "none", //动画类型（详见动画类型常量）
				subType: "from_top", //动画子类型（详见动画子类型常量）
				duration: 100 //动画过渡时间，默认300毫秒
			}
		});
	}

	UISearch.clear = function () {
		var historyList = $api.dom(".history-list");
		$api.rmStorage('_historyList');
		searchApp.history = [];
		// historyList.innerHTML = "";
	}

	Array.prototype.indexOf = function (val) {
		for (var i = 0; i < this.length; i++) {
			if (this[i] == val) return i;
		}
		return -1;
	};

	Array.prototype.remove = function (val) {
		var index = this.indexOf(val);
		if (index > -1) {
			this.splice(index, 1);
		}
	};
	window.UISearch = UISearch;

})();
