// Vue.component('cook-item', )

var cookTag = {
  template:
    '<div class="cook-tag ui-nowrap-multi"><span class="tag-item" v-for="item in list"  v-on:click="cooktag(item)" v-if="item" >#{{item | age}}</span></div>',
  data: function() {
    return {
      list: []
    };
  },
  props: {
    tags: {
      type: String,
      required: false,
      default: ''
    }
  },
  created: function() {
    if (this.tags != '' && this.tags) {
      this.list = this.tags.split(',') || [];
    } else {
      this.list = [];
    }
  },
  filters: {
    age: function(value) {
      return value;
    }
  },
  methods: {
    cooktag: function(tag) {
      cook.tag(tag);
    }
  }
};

// console.log(cookTga);
var cookItem = {
  template:
    '<div class="cook-item"><div class="cook-img" v-bind:class="{\'cook-video\': item|isVideo }" tapmode v-on:click="cook_view(item)"><img :src="cover" v-lazyload="coverFile" class="ui-imglazy" :data-img="item.cover | cover" ></div><div class="cook-info"><h2 class="cook-title ui-nowrap" tapmode v-on:click="cook_view(item)" v-text="item.title"></h2><cook-tag :tags="item.tags" ></cook-tag><div class="cook-age"><a v-show="item.age_name" href="javascript:;"" >{{ ageName }}</a></div><div class="cook-username"><img :src="avatar" v-lazyload="avtarFile" v-on:click="user_view(item.uid)" class="ui-border-radius cook-user-avatar"><span class="username ui-nowrap" v-text="item.username" v-on:click="user_view(item.uid)">吴彦祖</span> <img class="icon-label-new icon-label-left" v-if="show" :src="item.level.small_pic" /> <img class="icon-label icon-mon" v-if="show" :src="item.mon.small_pic" />      </div><div class="cook-read"><span class="iconfont cook-read-view">&#xe65c;</span><span class="cook-read-view-number"v-text="item.hits || 0"></span> <span class="iconfont cook-read-love">&#xe62d;</span><span class="cook-read-likes-number" v-text="likes || 0"></span></div></div></div>',
  components: {
    'cook-tag': cookTag
  },
  created: function() {
    // this.avatarDefault = this.avatar;
    // this.coverDefault = this.cover;
    // console.log(this);
    if (this.uprofile) {
      this.item.avatar = this.uprofile;
    }
    if (this.uid) {
      this.item.uid = this.uid;
    }
    if (this.uname) {
      this.item.username = this.uname;
    }
    // this.item = this.item;
    // console.log(this.item);
  },
  filters: {
    cover: function(path) {
      var img = path + '?imageView2/1/w/300/h/225/interlace/1/q/80';
      return img;
    }
  },
  data: function() {
    return {
      oldLikes: this.item.likes,
      show: false
    };
  },
  props: {
    item: {
      type: Object,
      required: true,
      default: {
        title: '暂无内容',
        hits: 0
      }
    },
    avatar: {
      type: String
    },
    cover: {
      type: String
    },
    utype: {
      type: String
    },
    uname: {
      type: String
    },
    uprofile: {
      type: String
    },
    uid: {
      type: Number
    },
    age: {
      type: String
    },
    list: {
      type: Array
    },
    cookid: {
      type: String
    },
    num: {
      type: Number
    }
  },
  computed: {
    coverFile: function() {
      if (this.utype != 'wifi') {
        return this.item.cover + '?imageView2/1/w/200/h/150/interlace/1/q/90';
      } else {
        return this.item.cover + '?imageView2/1/w/400/h/300/interlace/1/q/80';
      }
    },
    avtarFile: function() {
      var path = this.item.avatar;
      if (!path) return;
      if (path.indexOf('http://wx.qlogo.cn/mmopen/') > -1) {
        //微信头像
        var reg = '/\/\d+$/'
        return path.replace(reg, '/132');
      } else if (path.indexOf('sinaimg.cn/') > -1) {
        //新浪微博头像
      } else if (path.indexOf('http://wx.qlogo.cn/mmopen/') > -1) {
        //qq头像
      } else {
        //七牛
        if (this.utype != 'wifi') {
          var avatar = path + '?imageView2/1/w/60/h/60/interlace/1/q/80';
        } else {
          var avatar = path + '?imageView2/1/w/100/h/100/interlace/1/q/80';
        }
        return avatar;
      }
      return path;
    },
    isVideo: function(vm) {
      if (vm.item.video) {
        return true;
      } else {
        return false;
      }
    },
    ageName: function() {
      return this.age && this.age != '0' && this.list
        ? this.list[this.age - 1].name
        : this.item.age_name;
    },
    likes: function() {
      var result = this.item.likes;
      if (this.cookid && this.cookid == this.item.id) {
        result = +this.oldLikes + this.num;
        this.oldLikes = result;
      }
      return result;
    }
  },
  methods: {
    cook_view: function(item) {
      this.item.hits++;
      cook.view(item.id);
    },
    user_view: function(uid) {
      user.view(uid);
    }
  }
};
// Vue.component('cook-tag', );
