var msgItem = {
  template: '<div class="msg-item" :class="{notice: isnotice}" @click="stystem">' +
    '<div class="msg-avatar">' +
    '<img v-if="isSystem" :src="systemavatar" class="m-avatar" />' +
    '<avatar v-else :userinfo="user" :defaultSrc="defaultsrc" :avatar="avatar"/>' +
    '</div>' +
    // '<div class="msg-avatar"><img :src="avatar" /></div>' +
    '<div class="msg-contents" :class="{msgcol: !cover}">' +
    '<h6 class="name"><span @click="toUserView">{{msgTitle}}</span><span v-if="isnotice" class="msg-event">{{eventDes}}</span></h6>' +
    '<p class="des" v-if="!isnotice" @click="toCookView">{{content}}</p>' +
    '<p class="time">{{time | TransferTime}}</p>' +
    '</div>' +
    '<div v-if="cover" class="right" @click="toCookView">' +
    '<img class="cover" :src="cover" alt />' +
    '</div>' +
    '</div>',
  props: {
    item: {
      type: Object
    },
    title: {
      type: String,
      default: '萌酱酱选'
    },
    content: {
      type: String,
      default: ''
    },
    time: {
      type: String
    },
    user: {
      type: [Object,Array]
    },
    isnotice: {
      type: Boolean
    },
    user: {
      // type: Object
    },
    defaultsrc: {
      type: String
    },
    event: {
      type: String
    },
    cook: {
      type: Object
    },
    defaultcover: {
      type: String
    },
    systemavatar: {
      type: String
    },
    system: {
      type: Boolean
    }
  },
  filters: {
    TransferTime: function (s) {
      if (!s) return ''
      return transTime(s)
    }
  },
  data: function () {

    return {
      isSystem: this.item.event_type == 'system' || this.item.event_type == 'points' || this.system
    }
  },
  computed: {
    formatTime: function () {
      return Trans_php_time_to_str(this.time)
    },
    msgTitle: function () {
      // console.log(this.user)
      if (!this.cook) {
        if (this.item.extra) {
          var extra = JSON.parse(this.item.extra);
          if (typeof extra !== 'string') {
            if (extra.type == "doctor") {
              return '萌酱酱选'
            }
          }
        }
      }
      return this.isSystem ? '萌酱酱选' : this.user.username
    },
    avatar: function () {
      return this.isSystem ? this.user.avatar : this.user.avatar
    },
    eventDes: function () {
      if (!this.event) return
      var eventType = ''
      var str = '了你的菜谱'
      switch (this.event) {
        case 'comment':
          eventType = '赞美' + str
          break;
        case 'links':
          eventType = '收藏' + str
          break;
        default:
          eventType = '关注了你'
          break;
      }
      return eventType
    },
    cover: function () {
      if (this.item) {
        return this.item.cook_info ? this.item.cook_info.cover : null
      }
      return null
    }
  },
  components: {
    'avatar': avatar
  },
  methods: {
    toCookView: function () {
      if (!this.cook) {
        if (this.item.extra) {
          var extra = JSON.parse(this.item.extra);
          if (typeof extra == 'string') {
            if (extra.indexOf('http') >= 0) {
              if (extra.indexOf(marketurl) >= 0) {
                jumpToMarketPage(extra);
              } else {
                webview.view(extra)
              }
              return;
            }
          } else {
            var type = extra.type;
            if (type == "doctor") {
              api.openWin({
                name: "win_" + extra.txt,
                url: api.wgtRootDir + "/html/doctor/win_common.html",
                pageParam: {
                  header: extra.push_data.name,
                  name: extra.txt,
                  url: api.wgtRootDir + "/html/doctor/" + extra.txt + ".html",
                  data: {
                    question_id: extra.push_data.question_id,
                    doctor_id: extra.push_data.doctor_id,
                  },
                },
              });
            } else if (type == 'web' && extra.txt) {
              if (extra.txt.indexOf(marketurl) >= 0) {
                jumpToMarketPage(extra.txt);
              } else {
                webview.view(extra.txt);
              }
              return;
            }
          }
        }
        if (this.item.moment_info) {
          cook.replyComment(this.item);
        }
        return
      }
      if (this.cook.status == 3) {
        api.toast({
          msg: '菜谱不存在~',
          duration: 1000
        });
        return
      }
      if (this.event === 'comment') {
        cook.replyComment(this.item);
      } else {
        cook.view(this.cook.id,false,true);
      }
    },
    toUserView: function () {
      if (this.isSystem) {
      } else {
        user.view(this.user.uid)
      }
    },
    stystem: function (obj,push_type) {
      if (!this.isSystem) {
        return
      }
      if (this.cook && this.cook.status == 3) {
        api.toast({
          msg: '菜谱不存在~',
          duration: 1000
        })
        return
      }
      var param = this.item.extra
      var push_type = this.item.push_type;
      if (this.item.event_type == 'points') {
        user.level();
        return;
      }
      if (push_type && param) {
        switch (push_type) {
          case 'cook':
            cook.view(param)
            break;
          case 'topic':
            cook.topic(param)
            break
          case 'user':
            user.view(param)
            break;
          case 'web':
            webview.view(param)
          case 'points':
            user.level();
            break;
          default:

        }
        return
      }
      // 达人私信链接进入
      if (tools.isUrl(param) && !this.cook) {
        webview.view(param)
      }
    }
  }
}
function transTime (str) {
  var update = new Date(str * 1000); //时间戳要乘1000
  var year = update.getFullYear();
  var month = (update.getMonth() + 1 < 10) ? ('0' + (update.getMonth() + 1)) : (update.getMonth() + 1);
  var day = (update.getDate() < 10) ? ('0' + update.getDate()) : (update.getDate());
  var hour = (update.getHours() < 10) ? ('0' + update.getHours()) : (update.getHours());
  var minute = (update.getMinutes() < 10) ? ('0' + update.getMinutes()) : (update.getMinutes());
  var date = new Date()
  var timeDis = date.getTime() - update.getTime()
  var dayl = date.getDate() != update.getDate()
  //计算出相差天数
  var days = Math.floor(timeDis / (24 * 3600 * 1000))
  //计算出小时数
  var leave1 = timeDis % (24 * 3600 * 1000)
  var hours = Math.floor(leave1 / (3600 * 1000))
  //计算相差分钟数
  var leave2 = leave1 % (3600 * 1000)
  var minutes = Math.floor(leave2 / (60 * 1000))
  //计算相差秒数
  var leave3 = leave2 % (60 * 1000)
  var seconds = Math.round(leave3 / 1000)
  var str = ''
  if (days == 0 && dayl) {
    return '昨天'
  }
  if (days >= 1) {
    days <= 10 && (str = days + '天之前')
    days == 1 && (str = '昨天')
    return str || (year + '-' + month + '-' + day + ' ' + hour + ':' + minute);
  }
  if (hours == 0) {
    str = minutes == 0
      ? '刚刚'
      : minutes + '分钟之前'
    return str
  } else {
    return hours + '小时之前'
  }
}
