var typeItem = {
    template: '  <div class="msg-type ui-border-b" @click="toView">' +
                '<div class="left">' +
                   '<span>{{name}}</span><span v-if="msgNum" class="msg-info" >{{msgNum}}</span>' +
                '</div>' +
                '<a href="javascript:" class="iconfont icon-right">&#xe606;</a>' +
                '</div>',
    props: {
        name: {
            type: String,
            required: true,
            default: ''
        },
        info: {
            type: Number
        },
        handle: {
            type: Function
        },
        kind: {
            type: Number
        },
        setprefs: {
            type: Function
        }
    },
    data: function () {
        return {
            read: false,
            over: false
        }
    },
    computed: {
        msgNum: function () {
            if (this.read || this.info < 0) {
                return 0
            }
            return this.info > 99 ? '99+' : this.info
        }
    },
    methods: {
        toView: function () {
            var that = this
            this.handle(this.kind)
            this.setprefs(this.kind)
            setTimeout(function () {
                that.read = true
            }, 100)
        }
    }
}
