
(function webpackUniversalModuleDefinition(root, factory) {
    if(typeof exports === 'object' && typeof module === 'object')
        module.exports = factory();
    else if(typeof define === 'function' && define.amd)
        define([], factory);
    else if(typeof exports === 'object')
        exports["Lazyload"] = factory();
    else
        root["Lazyload"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/    // The module cache
/******/    var installedModules = {};
/******/
/******/    // The require function
/******/    function __webpack_require__(moduleId) {
/******/
/******/        // Check if module is in cache
/******/        if(installedModules[moduleId]) {
/******/            return installedModules[moduleId].exports;
/******/        }
/******/        // Create a new module (and put it into the cache)
/******/        var module = installedModules[moduleId] = {
/******/            i: moduleId,
/******/            l: false,
/******/            exports: {}
/******/        };
/******/
/******/        // Execute the module function
/******/        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/        // Flag the module as loaded
/******/        module.l = true;
/******/
/******/        // Return the exports of the module
/******/        return module.exports;
/******/    }
/******/
/******/
/******/    // expose the modules object (__webpack_modules__)
/******/    __webpack_require__.m = modules;
/******/
/******/    // expose the module cache
/******/    __webpack_require__.c = installedModules;
/******/
/******/    // identity function for calling harmony imports with the correct context
/******/    __webpack_require__.i = function(value) { return value; };
/******/
/******/    // define getter function for harmony exports
/******/    __webpack_require__.d = function(exports, name, getter) {
/******/        if(!__webpack_require__.o(exports, name)) {
/******/            Object.defineProperty(exports, name, {
/******/                configurable: false,
/******/                enumerable: true,
/******/                get: getter
/******/            });
/******/        }
/******/    };
/******/
/******/    // getDefaultExport function for compatibility with non-harmony modules
/******/    __webpack_require__.n = function(module) {
/******/        var getter = module && module.__esModule ?
/******/            function getDefault() { return module['default']; } :
/******/            function getModuleExports() { return module; };
/******/        __webpack_require__.d(getter, 'a', getter);
/******/        return getter;
/******/    };
/******/
/******/    // Object.prototype.hasOwnProperty.call
/******/    __webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/    // __webpack_public_path__
/******/    __webpack_require__.p = "";
/******/
/******/    // Load entry module and return exports
/******/    return __webpack_require__(__webpack_require__.s = 1);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

exports.default = function () {
    var cntr = 0;
    var lastCntr = 0;
    var diff = 0;
    var scrollEnd = document.createEvent('HTMLEvents');
    scrollEnd.initEvent('scrollEnd', true, false);
    scrollEnd.eventType = 'message';
    function enterFrame() {
        if (cntr !== lastCntr) {
            diff++;
            if (diff === 5) {
                window.dispatchEvent(scrollEnd);
                cntr = lastCntr;
            }
        }
        requestAnimationFrame(enterFrame);
    }
    window.requestAnimationFrame(enterFrame);
    window.addEventListener('scroll', function () {
        lastCntr = cntr;
        diff = 0;
        cntr++;
    });
};

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _scrollEnd = __webpack_require__(0);

var _scrollEnd2 = _interopRequireDefault(_scrollEnd);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var options = {
    time: 300,
    fade: false,
    speed: 20
    //nohori: true
};

(0, _scrollEnd2.default)();
var compute = function compute(el, time, cb) {
    if (el.getAttribute('loaded')) return;
    var rect = el.getBoundingClientRect();
    if ((rect.bottom >= 0 && rect.bottom <= window.screen.height || rect.top >= 0 && rect.top <= window.screen.height)
    // && (rect.right >= 0 && rect.right <= window.screen.width || rect.left >= 0 && rect.left <= window.screen.width)
        ) {
        if (el.src != el.newSrc && !!el.newSrc) {
            // api.toast({
            //     msg: el.newSrc
            // });
            if (typeof(api) != 'undefined') {
                var href = el.newSrc;
                var url = el.newSrc;
                // var pos = url.lastIndexOf("/data");
                // var filename = MD5(url.substring(pos + 1));
                var filename = MD5(url);
                var path = api.cacheDir + "/pic/" + filename;

                var obj = api.require('fs');
                obj.exist({
                    path: path
                }, function(ret, err) {
                    if (ret.exist) {
                        if (!ret.directory) {
                            // log(ret)
                            el.src = path;
                            el.setAttribute("loaded", "true");
                        }
                    } else {
                        setTimeout(function() {
                            el.src = href;
                            // console.log(href);
                            el.setAttribute("loaded", "true");
                        }, 10);
                        if (api.connectionType=="wifi") {

                            api.download({
                                url: href,
                                savePath: path,
                                report: false,
                                cache: true,
                                allowResume: true
                            }, function(ret, err) {
                                //msg(ret);
                                if (ret) {
                                    var value = ('文件大小：' + ret.fileSize + '；下载进度：' + ret.percent + '；下载状态' + ret.state + '存储路径: ' + ret.savePath);
                                    // console.log(value);
                                    // console.log('加载下载文件完毕'+value);
                                }
                            });
                        }

                    }
                })

                // if (api.systemType=="ios") {
                    // api.imageCache({
                    //     url: el.newSrc,
                    //     thumbnail: false,
                    // }, function(ret, err) {
                    //     if (ret) {
                    //         var url = ret.url;
                    //         setTimeout(function() {
                    //             el.src = url;
                    //             el.setAttribute("loaded", "true");
                    //         }, 0);
                    //     }
                    // });
                // }else{
                //     el.src = el.newSrc;
                //     el.onload = function() {
                //         el.style.opacity = '1';
                //         el.onload = new Function();
                //         el.setAttribute("loaded", "true");
                //     };
                //     el.style.transition = 'opacity ' + time + 'ms';
                //     if (cb) {
                //         cb();
                //     }
                // }
            }else{
                el.src = el.newSrc;
                el.onload = function () {
                    el.style.opacity = '1';
                    el.onload = new Function();
                    el.setAttribute("loaded", "true");
                };
                el.style.transition = 'opacity ' + time + 'ms';
                if (cb) {
                    cb();
                }
            }
        }
    }
};
var getSpeed = function getSpeed(opt) {
    var lastPos = opt.lastPos;
    var lastSpeeds = opt.lastSpeeds;
    var aveSpeed = opt.aveSpeed;
    var curPos = document.body.getBoundingClientRect().top;
    var speed = lastPos - curPos;
    if (lastSpeeds.length < 10) {
        lastSpeeds.push(speed);
    } else {
        lastSpeeds.shift();
        lastSpeeds.push(speed);
    }
    var sumSpeed = 0;
    lastSpeeds.forEach(function (speed) {
        sumSpeed += speed;
    });
    aveSpeed = Math.abs(sumSpeed / lastSpeeds.length);
    lastPos = curPos;
    return {
        lastPos: lastPos,
        lastSpeeds: lastSpeeds,
        aveSpeed: aveSpeed
    };
};
var compareSrc = function compareSrc(src, newSrc) {

    if (newSrc){
        if (newSrc.indexOf('undefined') > -1) {
            newSrc = src;
        }
    }else{
        newSrc = newSrc ? newSrc : src;
    }
    if (src.replace(/^http:/, '').replace(/^https:/, '').match(newSrc.replace(/^http:/, '').replace(/^https:/, ''))) {
        return true;
    } else return false;
};

var lazyload = {
    install: function install(Vue, _options) {
        if (_options) {
            for (var key in _options) {
                options[key] = _options[key];
            }
        }
        Vue.directive('lazyload', {
            inserted: function inserted(el, binding, vnode, oldVnode) {
                if (!el) return;
                if (compareSrc(el.src, binding.value)) return;
                if (options.fade) el.style.opacity = 0;
                if (!el.src) {
                    el.src = 'data:image/gifbase64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
                }

                var oldSrc = el.src;
                var speed = {
                    lastPos: document.body.getBoundingClientRect().top,
                    lastSpeeds: [],
                    aveSpeed: 0
                };
                el.newSrc = binding.value;
                var computeBySpeed = function computeBySpeed() {
                    if (!el.newSrc || el.newSrc === el.src) return;
                    speed = getSpeed(speed);
                    if (speed.aveSpeed > options.speed) return;
                    compute(el, options.time);
                };
                var onScrollEnd = function onScrollEnd() {
                    if (!el.newSrc || el.newSrc === el.src) return;
                    compute(el, options.time);
                };
                el.onload = function () {
                    el.onload = new Function();
                    // alert(el.newSrc);
                    el.removeEventListener('error', onError);
                    compute(el, options.time);
                    window.addEventListener('scroll', computeBySpeed);
                    window.addEventListener('scrollEnd', onScrollEnd);
                };
                // el.onerror=function(){
                //     el.src = oldSrc;
                // }
                function onError() {
                    el.onload = new Function();
                    el.removeEventListener('error', onError);
                    window.removeEventListener('scroll', computeBySpeed);
                    window.removeEventListener('scrollEnd', onScrollEnd);
                }
                el.addEventListener('error', onError);
                setTimeout(function () {
                    compute(el, options.time);
                });
            },
            update: function update(el, binding) {
                if (compareSrc(el.src, binding.value)) return;
                // el.style.opacity = 0;
                //
                el.style.transition = 'opacity ' + options.time / 2 + 'ms';
                el.newSrc = binding.value;
                setTimeout(function () {
                    compute(el, options.time / 2);
                }, 150);
            }
        });
    }
};

module.exports = lazyload;

/***/ })
/******/ ]);
});
/* requestAnimationFrame.js
 * by zhangxinxu 2013-09-30
*/
(function() {
    var lastTime = 0;
    var vendors = ['webkit', 'moz'];
    for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
        window.requestAnimationFrame = window[vendors[x] + 'RequestAnimationFrame'];
        window.cancelAnimationFrame = window[vendors[x] + 'CancelAnimationFrame'] ||    // name has changed in Webkit
                                      window[vendors[x] + 'CancelRequestAnimationFrame'];
    }
    if (!window.requestAnimationFrame) {
        window.requestAnimationFrame = function(callback, element) {
            var currTime = new Date().getTime();
            var timeToCall = Math.max(0, 16.7 - (currTime - lastTime));
            var id = window.setTimeout(function() {
                callback(currTime + timeToCall);
            }, timeToCall);
            lastTime = currTime + timeToCall;
            return id;
        };
    }
    if (!window.cancelAnimationFrame) {
        window.cancelAnimationFrame = function(id) {
            clearTimeout(id);
        };
    }
}());
