#extension GL_OES_EGL_image_external : require
precision highp float;

uniform vec3                iResolution;
uniform float               iGlobalTime;
uniform samplerExternalOES  sTexture;
varying vec2                texCoord;
uniform vec2                iMouse;
uniform mat3                vMatrix;

void mainImage(out vec4 fragColor, in vec2 fragCoord){

    vec2 coord = (vec3(fragCoord.xy, 1) * vMatrix).xy;

    if(coord.x >= 0.0 && coord.y >= 0.0 && coord.x <= 1.0 && coord.y <= 1.0){
        fragColor = texture2D(sTexture, coord);
    }else{
        fragColor = vec4(0, 0, 0, 1.0);
    }

}

void main(){
    mainImage(gl_FragColor, texCoord);
}