precision mediump float;
varying vec2 textureCoordinate;
uniform sampler2D s_texture;
uniform float degree;
void main()
{
    const float PI = 3.1415926;
    float theta = degree * PI / 180.0;
    float cosDegree = cos(theta);
    float sinDegree = sin(theta);
    float hw = 1.3333;

    float scaleX =  hw * abs(cosDegree) + abs(sinDegree);
    float scaleY =  abs(sinDegree) + hw * abs(cosDegree);
    float divider = min(hw / scaleX, 1.0/scaleY);

    float scaleOffset = (1.0 - divider)/2.0;

    float coordinateX = textureCoordinate.x - 0.5;
    float coordinateY = textureCoordinate.y - 0.5;

    float originCoordinateX = coordinateX * hw * cosDegree + coordinateY * sinDegree;
    float originCoordinateY = coordinateY * cosDegree - coordinateX*hw * sinDegree;

    float originX = (originCoordinateX / hw + 0.5) ;
    float originY = (originCoordinateY + 0.5);

    // to scale
    originX = originX * divider + scaleOffset;
    originY = originY * divider + scaleOffset;


    vec2 vector;
    vector[0] = originX;
    vector[1] = originY;

    gl_FragColor = texture2D( s_texture, vector);
}