precision mediump float;
varying vec2 textureCoordinate;
uniform sampler2D s_texture;
uniform float percentage;
void main()
{



    vec2 vector;
    float smallXY = 1.0 - percentage;
    float divider = 1.0/smallXY;

    float offset1 = mod((percentage/2.0),smallXY);
    float offset2 = offset1-smallXY;

    if(textureCoordinate.x>offset1)
    {
        vector[0]=mod((textureCoordinate.x - offset1),smallXY)*divider;
    }
    else
    {
        vector[0]=(textureCoordinate.x - offset2)*divider;
    }

    if(vector[0] < 0.01)
    {
        vector[0] = 0.01;
    }

    if(vector[0] > 0.99)
    {
        vector[0] = 0.99;
    }

    if(textureCoordinate.y>offset1)
    {
        vector[1]=mod((textureCoordinate.y - offset1),smallXY)*divider;
    }
    else
    {
        vector[1]=(textureCoordinate.y - offset2)*divider;
    }

    if(vector[1] < 0.01)
    {
        vector[1] = 0.01;
    }

    if(vector[1] > 0.99)
    {
       vector[1] = 0.99;
    }

    gl_FragColor = texture2D( s_texture, vector);
}