precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

vec4 rgb2gray(in vec3 rgb)
{
    float c = 0.3 * rgb.r + 0.59 * rgb.g + 0.11* rgb.b;
    return vec4(c, c, c, 1.0);
}

void main()
{
    vec4 inputColor = texture2D(inputImageTexture, textureCoordinate);
    if (inputColor.r == 0.0 && inputColor.g == 0.0 && inputColor.b == 0.0) {
        gl_FragColor = inputColor;
    }  else {
        vec4 outColor = rgb2gray(inputColor.rgb);
        gl_FragColor = outColor;
    }
}
