/**
 * FOR SERVER USING
 * 服务器使用
 */
const http = require('http')
const fs = require('fs')
const path = require('path')
//var extract = require('extract-zip')
// const createProxyMiddleware = require('http-proxy-middleware').createProxyMiddleware
const express = require('express')
const { default: Axios } = require('axios')
const app = express()

app.get('/getIp', function(req, res) {
    const ip = req.headers['x-forwarded-for'] || req.connection.remoteAddress || req.socket.remoteAddress
    res.header('Access-Control-Allow-Origin', '*')
    Axios.get('https://e0a41aa5-ea1c-4a6a-ad70-fa5a5099ff91.dns-detect.alicdn.com/api/detect/DescribeDNSLookup', {
        timeout: 5000
    })
        .then((data) => {
            res.send({
                ip,
                localIp: data.data.content.localIp,
                ldns: data.data.content.ldns
            })
        })
        .catch((err) => {
            res.send({
                ip
            })
            console.error('获取阿里云DescribeDNSLookup接口失败', err)
        })
})

//const axios = require('axios')

//const servers = ['']
const RUNENV = process.env.RUNENV

const port = RUNENV == 'electron' ? 3000 : process.env.PORT || 9322

app.get('/main', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

app.get('/small', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

app.get('/login', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

app.get('/preview', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

app.get('/device', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

app.get('/playback', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

app.get('/upload', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

app.get('/diag', function(req, res) {
    res.sendFile(__dirname + '/public/index.html')
})

//const rewriteOptions = JSON.parse(fs.readFileSync('routers.json'))||{}
// let middleWareOption = {
//     target: 'http://localhost:' + port, // target host
//     // changeOrigin: false, // needed for virtual hosted sites
//     pathRewrite: {
//         '^/main': '/index.html',
//         '^/small': '/index.html',
//         '^/login': '/index.html',
//         '^/preview': '/index.html',
//         '^/device': '/index.html',
//         '^/playback': '/index.html',
//         '^/upload': '/index.html',
//         '^/diag': '/index.html'
//     },
//     logLevel: 'debug'
// }

app.use(express.static(RUNENV == 'electron' ? '.' : 'public'))

app.get('/status', (req, res, next) => {
    res.send('success')
    next()
})

// app.use(createProxyMiddleware(middleWareOption))
app.listen(port, '0.0.0.0')
