package com.android.bitmapfun.util;

import java.io.Serializable;

public abstract class LoadImage implements Serializable {
	public static final int MAX_WIDTH = 960;
    public static final int MAX_HEIGHT = 960;
    
    private static final long serialVersionUID = -1553083837863333470L;
    protected int width = MAX_WIDTH;
    protected int height = MAX_HEIGHT;
    protected int outWidth = -1;
    protected int outHeight = -1;
    protected boolean cacheMemoryAvailable = false;
    protected boolean cacheStoregeAvailable = false;

   
    /**
     * 是否需要从网络下载
     */
    private boolean downloadAvailable = true;

    /**
     * 正在加载中的默认图片
     */
    private int loadingImageResId;

    /**
     * 获取本地图片
     * 
     * @param localPath 本地图片路径
     * @param maxWidth 最大宽度
     * @param maxHeight 最大高度
     * @param isNeedCacheMemory 是否需要缓存到内存
     * @param isNeedCacheStorege 是否需要缓存到硬盘
     */
    public LoadImage(int maxWidth, int maxHeight, boolean cacheMemory, boolean cacheStorege) {
        this.width = maxWidth;
        this.height = maxHeight;
        this.cacheMemoryAvailable = cacheMemory;
        this.cacheStoregeAvailable = cacheStorege;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }
    
    public void setOutMeasureSize(int outWidth,int outHeight){
    	this.outWidth = outWidth;
    	this.outHeight = outHeight;
    }

    public int getOutWidth() {
		return outWidth;
	}

	public int getOutHeight() {
		return outHeight;
	}

	public void setHeight(int height) {
        this.height = height;
    }

    public abstract String getSourceCacheKey();

    public abstract boolean isComplete();

    public abstract String getCacheKey();

    public int getLoadingImageResId() {
        return loadingImageResId;
    }

    public boolean isCacheMemoryAvailable() {
        return cacheMemoryAvailable;
    }

    public void setCacheMemoryAvailable(boolean cacheMemoryAvailable) {
        this.cacheMemoryAvailable = cacheMemoryAvailable;
    }

    public boolean isCacheStoregeAvailable() {
        return cacheStoregeAvailable;
    }

    public void setCacheStoregeAvailable(boolean cacheStoregeAvailable) {
        this.cacheStoregeAvailable = cacheStoregeAvailable;
    }

    public boolean isDownloadAvailable() {
        return downloadAvailable;
    }

    public void setDownloadAvailable(boolean downloadAvailable) {
        this.downloadAvailable = downloadAvailable;
    }

    public void setLoadingImageResId(int loadingImageResId) {
        this.loadingImageResId = loadingImageResId;
    }
}
