package com.android.bitmapfun.util;

import java.io.File;

public class LoadImageFile extends LoadImage {

    private static final long serialVersionUID = 7104020755219869839L;

    private String mLocalPath;

    public LoadImageFile(String localPath) {
        this(localPath, false);
    }

    public LoadImageFile(String localPath, boolean cacheMemory) {
        this(localPath, cacheMemory, false);
    }

    public LoadImageFile(String localPath, boolean cacheMemory, boolean cacheStorege) {
        this(localPath, cacheMemory, cacheStorege, MAX_WIDTH, MAX_HEIGHT);
    }

    public LoadImageFile(String path, boolean cacheMemory, int width, int height) {
        this(path, cacheMemory, false, width, height);
    }

    public LoadImageFile(String localPath, boolean cacheMemory, boolean cacheStorege, int width, int height) {
        super(width, height, cacheMemory, cacheStorege);
        this.mLocalPath = localPath;
    }

    @Override
    public String getSourceCacheKey() {
        return mLocalPath;
    }

    @Override
    public boolean isComplete() {
        if (mLocalPath != null && new File(mLocalPath).isFile()) {
            return true;
        }
        return false;
    }

    @Override
    public String getCacheKey() {
        if (width > 0 && height > 0 && width != MAX_WIDTH && height != MAX_HEIGHT) {
            return mLocalPath + width + height;
        } else {
            return mLocalPath;
        }
    }

    public String getLocalPath() {
        return mLocalPath;
    }

    @Override
    public String toString() {
        return "LoadImageFile [mLocalPath=" + mLocalPath + ", width=" + width + ", height=" + height
                + ", cacheMemoryAvailable=" + cacheMemoryAvailable + ", cacheStoregeAvailable=" + cacheStoregeAvailable
                + "]";
    }
}
