package com.android.bitmapfun.util;

import android.app.Application;
import android.content.Context;
import android.provider.MediaStore.Images.Thumbnails;

public class LoadImageThumb extends LoadImage{
	
	private final Context mApplication;
	
	private final int mTyle;
	
	private final int mSourceId;
	
	private final String THUMB_FLAG = "luochun_thumb";
	
	public LoadImageThumb(Context applicationContext,int type,int sourceId,int maxWidth,int maxHeight){
		super(maxWidth, maxHeight, true, false);
		this.mApplication = applicationContext.getApplicationContext();
		this.mTyle = type;
		this.mSourceId = sourceId;
	}
	
	public Context getApplication() {
		return mApplication;
	}

	public int getTyle() {
		return mTyle;
	}

	public int getSourceId() {
		return mSourceId;
	}
	
	@Override
	public String getSourceCacheKey() {
		return THUMB_FLAG+mSourceId+mTyle+MAX_HEIGHT+MAX_WIDTH;
	}

	@Override
	public boolean isComplete() {
		if((mTyle == Thumbnails.MICRO_KIND || mTyle== Thumbnails.MINI_KIND)){
			return true;
		}
		return false;
	}

	@Override
	public String getCacheKey() {
		// TODO Auto-generated method stub
		return THUMB_FLAG+mSourceId+mTyle+MAX_HEIGHT+MAX_WIDTH;
	}
	
}
