package com.android.bitmapfun.util;

import java.net.URLDecoder;

import com.pingan.frame.http.HttpHelper;
import com.pingan.frame.http.listener.TokenCallback;

public class LoadImageUrl extends LoadImage {

    private static final long serialVersionUID = -419151094685156662L;

    /**
     * 图片缩略图 100*100
     */
    public static final String STYLE_NAME_IMAGE_SMALL = "small";
    /**
     * 视频缩略图 100*100
     */
    public static final String STYLE_NAME_VIDEO_IMAGE_SMALL = "vset_small";
    /**
	 * 
	 */
    public static final String STYLE_NAME_IMAGE_SMALL_160 = "small160";

    public static final String STYLE_NAME_IMAGE_SMALL_360 = "small360";

    public static final String STYLE_NAME_IMAGE_SMALL_480 = "small480";

    public static final String STYLE_NAME_IMAGE_SMALL_600 = "small600";

    public static final String STYLE_NAME_IMAGE_SMALL_810 = "small810";

    public static final String STYLE_NAME_CLIP_IMAGE_SMALL_80 = "smallj80";

    public static final String STYLE_NAME_CLIP_IMAGE_SMALL_120 = "smallj120";

    public static final String STYLE_NAME_CLIP_IMAGE_SMALL_160 = "smallj160";

    public static final String STYLE_NAME_CLIP_IMAGE_SMALL_200 = "smallj200";

    public static final String STYLE_NAME_CLIP_IMAGE_SMALL_270 = "smallj270";
    

    private String mUrl = null;

    private String mStyle = null;
    
    private boolean isNeedCut = false;

    public LoadImageUrl(String url, String style) {
        this(url, style, true, true, MAX_WIDTH, MAX_HEIGHT,false);
    }

    public LoadImageUrl(String url, int width, int height) {
        this(url, null, true, true, width, height,false);
    }
    
    public LoadImageUrl(String url, int width, int height, boolean isNeedCut) {
        this(url, null, true, true, width, height,isNeedCut);
    }

    public LoadImageUrl(String url, boolean cacheMemory, boolean cacheStorege) {
        this(url, null, cacheMemory, cacheStorege, MAX_WIDTH, MAX_WIDTH,false);
    }

    public LoadImageUrl(String url, String style, boolean cacheMemory, boolean cacheStorege, int width, int height,boolean isNeedCut) {
        super(width, height, cacheMemory, cacheStorege);
        this.mUrl = url;
        this.mStyle = style;
        this.isNeedCut = isNeedCut;
        initStyleSize();
    }
    
    public boolean isNeedCut(){
    	return isNeedCut;
    }
    
    private void initStyleSize(){
    	if(STYLE_NAME_IMAGE_SMALL.equals(mStyle)||STYLE_NAME_VIDEO_IMAGE_SMALL.equals(mStyle)){
    		this.width = 100;
            this.height = 100;
    	}
    	else if(STYLE_NAME_IMAGE_SMALL_160.equals(mStyle)){
    		this.width = 160;
            this.height = 160;
    	}
    	else if(STYLE_NAME_IMAGE_SMALL_360.equals(mStyle)){
    		this.width = 360;
            this.height = 360;
    	}
    	else if(STYLE_NAME_IMAGE_SMALL_480.equals(mStyle)){
    		this.width = 480;
            this.height = 480;
    	}
    	else if(STYLE_NAME_IMAGE_SMALL_600.equals(mStyle)){
    		this.width = 600;
            this.height = 600;
    	}
    	else if(STYLE_NAME_IMAGE_SMALL_810.equals(mStyle)){
    		this.width = 810;
            this.height = 810;
    	}
    	else if(STYLE_NAME_CLIP_IMAGE_SMALL_80.equals(mStyle)){
    		this.width = 80;
            this.height = 80;
    	}
    	else if(STYLE_NAME_CLIP_IMAGE_SMALL_120.equals(mStyle)){
    		this.width = 120;
            this.height = 120;
    	}
    	else if(STYLE_NAME_CLIP_IMAGE_SMALL_160.equals(mStyle)){
    		this.width = 160;
            this.height = 160;
    	}
    	else if(STYLE_NAME_CLIP_IMAGE_SMALL_200.equals(mStyle)){
    		this.width = 200;
            this.height = 200;
    	}
    	else if(STYLE_NAME_CLIP_IMAGE_SMALL_270.equals(mStyle)){
    		this.width = 270;
            this.height = 270;
    	}
    }

    @Override
    public String getSourceCacheKey() {
        return mUrl;
    }

    @Override
    public boolean isComplete() {
        if (mUrl != null && !mUrl.trim().equals("")) {
            return true;
        }
        return false;
    }

    @Override
    public String getCacheKey() {
        if (mStyle != null) {
            return mUrl + mStyle;
        } else if (width > 0 && height > 0 && width != MAX_WIDTH && height != MAX_HEIGHT) {
            return mUrl + width + height + isNeedCut;
        } else {
            return mUrl;
        }
    }

    public String getUrl() {
        return mUrl;
    }

    public String getStyle() {
        return mStyle;
    }
    /**
     * 是否是请求一个压缩图片
     * @return
     */
    public boolean isSmallUrl(){
    	String tempUrl = getUrl();
        String styleName = getStyle();
        //如果包含请求相关http什么的
        if (HttpHelper.hasProtocol(tempUrl)) {
        	int width = getWidth();
        	int height = getHeight();
        	//如果有styleName就是压缩图片下载
        	if (LoadImageUrl.isQiNiuImageUrl(tempUrl) && styleName != null && styleName.length() > 0) {
        		return true;
            }
        	//如果宽高度有改变 就是压缩图片下载
        	else if(width > 0 && height > 0&&LoadImageUrl.isQiNiuImageUrl(tempUrl)){
        		return true;
        	}
        	else {
        		return false;
            }

        } 
        //如果是私有文件
        else {
        	//如果有styleName就是压缩图片下载
        	if(styleName!=null&&!styleName.trim().equals("")){
        		return true;
        	}
        }
        return false;
    }
    
    
    public String getDownloadUrl(TokenCallback tokenCallback){
    	String tempUrl = getUrl();
        String styleName = getStyle();
        String resultUrl = null;
        if (HttpHelper.hasProtocol(tempUrl)) {
        	int width = getWidth();
        	int height =getHeight();
        	if (LoadImageUrl.isQiNiuImageUrl(tempUrl) && styleName != null && styleName.length() > 0) {
                resultUrl = tempUrl + "/" + styleName;
            }
        	else if(width>0&&height>0&&LoadImageUrl.isQiNiuImageUrl(tempUrl)){
        		if(isNeedCut()){
        			resultUrl = tempUrl + "?" + "imageView2/1/w/"+width+"/h/"+height;
        		}
        		else{
        			resultUrl = tempUrl + "?" + "imageView2/2/w/"+width+"/h/"+height;
        		}
        	}
        	else {
                resultUrl = tempUrl;
            }
        } else {
            String downloadUrl = tokenCallback.getDownloadUrl(tempUrl, styleName);
            if (downloadUrl != null) {
                resultUrl = URLDecoder.decode(downloadUrl);
            }
        }
        return resultUrl;
    }
    

    public static boolean isQiNiuImageUrl(String url){
    	if(url!=null&&url.contains("qiniudn")){
    		return true;
    	}
    	return false;
    }
    
    @Override
    public String toString() {
        return "LoadImageUrl [mUrl=" + mUrl + ", mStyle=" + mStyle + ", width=" + width + ", height=" + height
                + ", cacheMemoryAvailable=" + cacheMemoryAvailable + ", cacheStoregeAvailable=" + cacheStoregeAvailable
                + "]";
    }
}
