package com.pingan.frame;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

import org.json.JSONException;
import org.json.JSONObject;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Toast;

import com.android.bitmapfun.util.PAImageFetcher;
import com.pingan.frame.http.HttpConnector;
import com.pingan.frame.http.HttpRequest;
import com.pingan.frame.http.HttpResponse;
import com.pingan.frame.http.action.HttpActionRequest;
import com.pingan.frame.http.action.HttpActionResponse;
import com.pingan.frame.http.bitmap.HttpBitmapRequest;
import com.pingan.frame.http.bitmap.HttpBitmapResponse;
import com.pingan.frame.http.download.HttpDownloadRequest;
import com.pingan.frame.http.download.HttpDownloadResponse;
import com.pingan.frame.http.listener.HttpProgressListener;
import com.pingan.frame.http.listener.TokenCallback;
import com.pingan.frame.http.upload.HttpUploadContinueRequest;
import com.pingan.frame.http.upload.HttpUploadRequest;
import com.pingan.frame.http.upload.HttpUploadResponse;
import com.pingan.frame.util.AppLog;
import com.pingan.frame.util.BitmapUtils;
import com.pingan.frame.util.FileUtil;
import com.pingan.frame.util.PAHashMap;

public class MainActivity extends Activity implements OnClickListener,HttpProgressListener{
	private String TAG = "MainActivity";
	/**
	 * 上传按钮
	 */
	private Button mBtnUpload;
	/**
	 * 下载文件按钮
	 */
	private Button mBtnDownload;
	/**
	 * 发送接口请求按钮
	 */
	private Button mBtnAction;
	/**
	 * 图片下载按钮
	 */
	private Button mBtnBitmap;
	/**
	 * ui回调handler
	 */
	private Handler mHandler;
	
	private ImageView imageview;
	
	private EditText mEditText;
	
	private EditText mEditText1;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		//初始化过滤器
		HttpConnector.init(null);;
		//初始化图片缓存策略
		PAImageFetcher.init(this, null);
		//初始化临时保存目录
		FileUtil.initTempRootPath(this);
		mHandler = new Handler();
		initView();
	}

	/**
	 * 初始化View
	 */
	private void initView(){
		mBtnUpload = (Button) findViewById(R.id.btn_http_upload);
		mBtnDownload = (Button) findViewById(R.id.btn_http_download);
		mBtnAction = (Button) findViewById(R.id.btn_http_action);
		mBtnBitmap = (Button) findViewById(R.id.btn_http_bitmap);
		imageview = (ImageView) findViewById(R.id.img_view);
		mEditText = (EditText) findViewById(R.id.edittext);
		mEditText1 = (EditText) findViewById(R.id.edittext1);
		mBtnUpload.setOnClickListener(this);
		mBtnDownload.setOnClickListener(this);
		mBtnAction.setOnClickListener(this);
		mBtnBitmap.setOnClickListener(this);
	}
	
	@Override
	public void onClick(View view) {
//		switch (view.getId()) {
//			//接口请求
//			case R.id.btn_http_action:
//				//get请求发送
////				requestHttpActionByGet();
//				//post请求发送
////				requestHttpActionByPost();
//				break;
//			//图片请求
//			case R.id.btn_http_bitmap:
//				requestHttpBitmap(this);
//				break;
//			//下载文件
//			case R.id.btn_http_download:
//				requestHttpDownload(this);
//				break;
//			//上传文件
//			case R.id.btn_http_upload:
////				requestHttpUploadContinue();
//				requestHttpUpload();
//				break;
//			default:
//				break;
//		}
	}
	
	/**
	 * 下载图片
	 */
	private void requestHttpBitmap(Context context){

		//下载地址
//		String downloadUrl = "http://pinganimg.u.qiniudn.com/pubaccount1_1382406685531";
//		
//		//图片本地缓存地址(可以为null,当不为null时代表曾经下载过，并且保存到了本地)
//		//第一次下载为null
//		String filePath = null;
//		//下载完图片保存的路径
//		String savePath = getAppStorageDir(this);
//		//tokenCallback  用于发送iq指令  获取七牛上传得token
//		TokenCallback tokenCallback = null;
//		//图片请求
//		HttpBitmapRequest request = new HttpBitmapRequest(context,downloadUrl, savePath, tokenCallback);
//		//将Button封装进请求当中
//		request.setData(mBtnBitmap);
//		
//		request.setMaxMeasureSize(200,200);
//		
//		request.setBitmapConfig(Config.ARGB_4444);
//		
//		request.changeIsCache(false);
//		//监听
//		request.setHttpListener(this);
//		//如果您要求所有的监听回调处于ui线程中,请设置一个handler
//		request.setHandler(mHandler);
		//发送请求
//		Bitmap cacheBitmap = BitmapManager.getInstance().getBitmap(request, this);
//		//如果存在缓存中,则直接使用
//		if(cacheBitmap!=null){
//			Toast.makeText(this, R.string.has_cache_bitmap, Toast.LENGTH_SHORT).show();
//			//已经在缓存当中
//		}else{
//			//没有在缓存中 会进监听
//			mBtnBitmap.setEnabled(false);
//		}
	}
	
	
	/**
	 * Get请求接口
	 */
	private void requestHttpActionByGet(){
		String url = "http://zhidao.baidu.com/search";
		//构建一个请求对象
		HttpActionRequest request = new HttpActionRequest(url, HttpActionRequest.REQUEST_METHOD_GET);
		//请求参数封装开始
		HashMap<String, String> parameter = new HashMap<String, String>();
		parameter.put("lm", "0");
		parameter.put("rn", "10");
		parameter.put("pn", "0");
		parameter.put("fr", "search");
		parameter.put("ie", "gbk");
		parameter.put("word", "action demo");
		request.setParamData(parameter);
		//请求参数封装结束
		
		//监听
		request.setHttpListener(this);
		//将Button封装进请求当中
		request.setData(mBtnAction);
		//如果您要求所有的监听回调处于ui线程中,请设置一个handler
		request.setHandler(mHandler);
		mBtnAction.setEnabled(false);
		//发送请求
		HttpConnector.sendHttpRequest(request);
	}
	/**
	 * Post请求接口
	 */
	private void requestHttpActionByPost(){
		try {
			String url = "http://114.80.125.116:8080/mtp-web/p1/op_query_public_key.htm";
			//构建一个请求对象
			HttpActionRequest request = new HttpActionRequest(url, HttpActionRequest.REQUEST_METHOD_POST);
			//JSON传参封装  开始
			JSONObject jsonObejct = new JSONObject();
			jsonObejct.put("operationType", "OP_QUERY_PUBLIC_KEY");
			jsonObejct.put("sessionId", "");
			jsonObejct.put("clientId", "deviceAndroid");
			request.setParamData(jsonObejct);
			//最后服务器接受到的是:{'operationType':'OP_QUERY_PUBLIC_KEY','sessionId':'','clientId':'deviceAndroid'}
			//JSON传参封装 结束
			
			//MAP传参封装 开始
//			HashMap<String, String> mapObject = new HashMap<String, String>();
//			mapObject.put("operationType", "OP_QUERY_PUBLIC_KEY");
//			mapObject.put("sessionId", "");
//			mapObject.put("clientId", "deviceAndroid");
//			request.setParamData(mapObject);
//			//最后服务器接受到的是:operationType=OP_QUERY_PUBLIC_KEY&sessionId=&clientId=deviceAndroid
			//MAP传参封装 结束
			
			//请求头部信息封装开始
			HashMap<String, Object> headMapObject = new HashMap<String, Object>();
			headMapObject.put("Content-Type", "application/json");
			request.setHeaderMap(headMapObject);
			//请求头部信息封装结束
			//监听
			request.setHttpListener(this);
			//将Button封装进请求当中
			request.setData(mBtnAction);
			//如果您要求所有的监听回调处于ui线程中,请设置一个handler
			request.setHandler(mHandler);
			mBtnAction.setEnabled(false);
			//发送请求
			HttpConnector.sendHttpRequest(request);
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * 上传文件
	 */
	private void requestHttpUpload(){
		
		//要上传得文件的绝对路径
		String filePath = "/mnt/sdcard/bj_02.png";
		Log.i("luochun", "上传图片:"+filePath);
		//构建一个上传请求
		HttpUploadRequest request = new HttpUploadRequest(this,"/mnt/sdcard/luochun",BitmapFactory.decodeFile(filePath), 
				HttpUploadContinueRequest.FILE_TYPE_IMAGE, HttpUploadContinueRequest.BIZ_TYPE_COMM, null);
		//如果您要求所有的监听回调处于ui线程中,请设置一个handler
		request.setHandler(mHandler);
		//监听
		request.setHttpListener(this);
		//将Button封装进请求当中
		request.setData(mBtnUpload);
		
		mBtnUpload.setEnabled(false);
		//发送请求
		HttpConnector.sendHttpRequest(request);
	}
	
	/*
	 * 获得指定文件的byte数组  
	 */  
	public static byte[] getBytes(String filePath){   
	    byte[] buffer = null;   
	    try {   
	        File file = new File(filePath);   
	        FileInputStream fis = new FileInputStream(file);   
	        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);   
	        byte[] b = new byte[1000];   
	        int n;   
	        while ((n = fis.read(b)) != -1) {   
	            bos.write(b, 0, n);   
	        }   
	        fis.close();   
	        bos.close();   
	        buffer = bos.toByteArray();   
	    } catch (FileNotFoundException e) {   
	        e.printStackTrace();   
	    } catch (IOException e) {   
	        e.printStackTrace();   
	    }   
	    return buffer;   
	}   
	
	/**
	 * 下载文件
	 */
	private void requestHttpDownload(Context context){
		
		//下载完图片保存的路径
		String savePath = getAppStorageDir(this);
		//下载地址
		String downloadUrl = "http://luochun.u.qiniudn.com/localredad2012070-3.jpg";
		//构建一个下载请求
		HttpDownloadRequest request = new HttpDownloadRequest(context,downloadUrl, savePath, null);
		//如果您要求所有的监听回调处于ui线程中,请设置一个handler
		request.setHandler(mHandler);
		//监听
		request.setHttpListener(this);
		//将Button封装进请求当中
		request.setData(mBtnDownload);
		
		mBtnDownload.setEnabled(false);
		
		//发送请求
		HttpConnector.sendHttpRequest(request);
	}
	
	
	/**
	 * 处理上传完毕后该做的事情
	 * @param response
	 * @param btnView
	 */
	private void responseUpload(HttpResponse response,Button btnView){
		if(response.getStateCode()==HttpResponse.STATE_SUCCESS){
			HttpUploadResponse uploadResponse = (HttpUploadResponse)response;
			//上传后生成的下载地址
			String downloadUrl = uploadResponse.getDownloadUrl();
			Toast.makeText(this,getString(R.string.http_upload_success)+"  生成下载地址为:"+downloadUrl, Toast.LENGTH_SHORT).show();
		}else{
			Toast.makeText(this,R.string.http_upload_faild, Toast.LENGTH_SHORT).show();
		}
		btnView.setText(R.string.http_upload);
	}
	
	/**
	 * 处理请求接口完毕该做的事情
	 * @param response
	 * @param btnView
	 */
	private void responseAction(HttpResponse response,Button btnView){
		if(response.getStateCode()==HttpResponse.STATE_SUCCESS){
			HttpActionResponse actionResponse = (HttpActionResponse)response;
			//如果服务器返回时json则采用此方法处理
			responseActionJson(actionResponse);
//			responseActionXml(actionResponse);
			Toast.makeText(this,R.string.http_action_success, Toast.LENGTH_SHORT).show();
		}else{
			
			Toast.makeText(this,R.string.http_action_faild, Toast.LENGTH_SHORT).show();
		}
		btnView.setText(R.string.http_action);
	}
	/**
	 * 处理请求接口结果为json返回的数据
	 * @param actionResponse
	 */
	private void responseActionJson(HttpActionResponse actionResponse){
		JSONObject jsonObject = (JSONObject) actionResponse.getResponseData();
		Toast.makeText(this, "jsonObject:"+jsonObject.toString(), Toast.LENGTH_SHORT).show();
	}
	/**
	 * 处理请求接口结果为xml返回的数据
	 * @param actionResponse
	 */
	private void responseActionXml(HttpActionResponse actionResponse){
		PAHashMap<String, Object> xmlMap = (PAHashMap<String, Object>) actionResponse.getResponseData();
		Toast.makeText(this, "xmlMap:"+xmlMap.toString(), Toast.LENGTH_SHORT).show();
	}
	/**
	 * 处理请求图片完毕该做的事情
	 * @param response
	 * @param btnView
	 */
	private void responseBitmap(HttpResponse response,Button btnView){
		if(response.getStateCode()==HttpResponse.STATE_SUCCESS){
			HttpBitmapResponse bitmapResponse = (HttpBitmapResponse)response;
			//图片
			Bitmap bm = bitmapResponse.getBitmap();
			imageview.setImageBitmap(bm);
			//图片保存地址
			String saveFilePath = bitmapResponse.getImageLocalPath();
			Toast.makeText(this,getString(R.string.http_bitmap_success)+"  图片保存在:"+saveFilePath, Toast.LENGTH_SHORT).show();
		}else{
			
			Toast.makeText(this,R.string.http_bitmap_faild, Toast.LENGTH_SHORT).show();
		}
		btnView.setText(R.string.http_bitmap);
	}
	/**
	 * 处理请求下载文件完毕该做的事情
	 * @param response
	 * @param btnView
	 */
	private void responseDownload(HttpResponse response,Button btnView){
		if(response.getStateCode()==HttpResponse.STATE_SUCCESS){
			HttpDownloadResponse downloadResponse = (HttpDownloadResponse)response;
			String filePath = downloadResponse.getFilePath();
			Toast.makeText(this,getString(R.string.http_download_success)+"  文件保存在:"+filePath, Toast.LENGTH_SHORT).show();
		}else{
			
			Toast.makeText(this,R.string.http_download_faild, Toast.LENGTH_SHORT).show();
		}
		btnView.setText(R.string.http_download);
	}
	
	/**
	 * 获取APP 存储的路径
	 * 
	 * @param context
	 * @return
	 */
	public String getAppStorageDir(Context context) {
		// 获取Android程序在Sd上的保存目录约定 当程序卸载时，系统会自动删除。
		File f = context.getExternalFilesDir(null);
		// 如果约定目录不存在
		if (f == null) {
			// 获取外部存储目录即 SDCard
			String storageDirectory = Environment.getExternalStorageDirectory()
					.toString();
			File fDir = new File(storageDirectory);
			// 如果sdcard目录不可用
			if (fDir.canWrite()) {
				storageDirectory = storageDirectory+File.separator+"pingan"+File.separator+context.getApplicationInfo().packageName;
				AppLog.i(TAG, "项目存储路径采用sdcard的地址   storageDirectory:"+storageDirectory);
				return storageDirectory+"/demo";
			}
			else{
				AppLog.e(TAG, "没有找到可用的存储路径  采用cachedir");
				return context.getCacheDir().toString()+"/demo";
			}
		} else {
			String storageDirectory = f.getAbsolutePath();
			AppLog.i(TAG, "项目存储路径采用系统给的路径地址  storageDirectory:"+storageDirectory);
			return storageDirectory+"/demo";
		}

	}
	
	
	
	@Override
	public void onHttpBegin(HttpRequest request) {
		if(request instanceof HttpUploadContinueRequest){
			Toast.makeText(this,"上传文件开始", Toast.LENGTH_SHORT).show();
		}
		else if(request instanceof HttpBitmapRequest){
			Toast.makeText(this,"下载图片开始", Toast.LENGTH_SHORT).show();
		}
		else if(request instanceof HttpActionRequest){
			Toast.makeText(this,"请求接口开始", Toast.LENGTH_SHORT).show();
		}
		else if(request instanceof HttpDownloadRequest){
			Toast.makeText(this,"下载文件开始", Toast.LENGTH_SHORT).show();
		}
	}

	@Override
	public void onHttpFinish(HttpResponse response) {
		Button btnView = (Button) response.getHttpRequest().getData();
		btnView.setEnabled(true);
		if(response instanceof HttpUploadResponse){
			responseUpload(response, btnView);
		}
		else if(response instanceof HttpBitmapResponse){
			responseBitmap(response, btnView);
		}
		else if(response instanceof HttpActionResponse){
			responseAction(response, btnView);
		}
		else if(response instanceof HttpDownloadResponse){
			responseDownload(response, btnView);
		}
	}
	
	@Override
	public void onProgress(HttpRequest request, float percent,
			long excuteLength, long sumLength) {
		Button btnView = (Button) request.getData();
		if(request instanceof HttpBitmapRequest){
			btnView.setText("图片下载进度:"+percent);
		}
		else if(request instanceof HttpDownloadRequest){
			btnView.setText("文件下载进度:"+percent);
		}
		else if(request instanceof HttpUploadContinueRequest){
			btnView.setText("文件上传进度:"+percent);
		}
	}
	
	
}
