/*
 * 文件名: DataHandler.java
 * 版    权：  Copyright PingAn Technology All Rights Reserved.
 * 描    述: [该类的简要描述]
 * 创建人: CUNGUANTONG465
 * 创建时间: 2011-12-19
 * 
 * 修改人：
 * 修改时间:
 * 修改内容：[修改内容]
 */
package com.pingan.frame.datahandle;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.pingan.frame.util.PAHashMap;

/**
 * 
 * [一句话功能简述]<BR>
 * [功能详细描述]
 * 
 * @author CUNGUANTONG465
 * @version [Android PABank C01, 2011-12-19]
 */
@SuppressWarnings("unchecked")
public final class PADataHandler extends DataHandler {
	
	
	private static final String TAG = PADataHandler.class.getSimpleName();

	private Stack<String> mTagStack = new Stack<String>();

	@SuppressWarnings("rawtypes")
	private Stack<PAHashMap> mMapStack = new Stack<PAHashMap>();
	
	private Stack<PAHashMap> mAttributesStack = new Stack<PAHashMap>();

	private PAHashMap<String, Object> mMaps;

	/**
	 * 当前存储数据的Map
	 */
	private PAHashMap<String, Object> mCurrentMaps;

	private String mStartTagName = "";
	private String mEndTagName = "";
	private String mTagValue = "";

	private int mTagDepth = 0;

	StringBuffer buffer = new StringBuffer();

	public PAHashMap<String, Object> getObjectMap() {
		return mCurrentMaps;
	}

	@Override
	public void characters(char[] ch, int start, int length) {
		buffer.append(ch, start, length);
	}

	@Override
	public void startDocument() throws SAXException {
		// 初始化第一级Maps目录
		mMaps = new PAHashMap<String, Object>();
		mCurrentMaps = mMaps;
	}

	@Override
	public void endElement(String uri, String localName, String qName) {
		String tagName = localName == "" ? qName : localName;

		mEndTagName = tagName;
		mTagValue = buffer.toString().trim();
		// PABankLog.e(TAG, mStartTagName + "==" + mTagValue);
		try {
			String stackTopTag = "";
			if (!mTagStack.empty()) {
				stackTopTag = mTagStack.peek().toString();
			}
			if (stackTopTag.equalsIgnoreCase(mEndTagName)) {
				mTagStack.pop();
				//如果处于最深处 
				if (mTagDepth == mTagStack.size()) {
					if (mCurrentMaps.containsKey(mEndTagName)) {
						int num = getElementNum(mCurrentMaps, mEndTagName);
						mCurrentMaps.put(mEndTagName + num, initElement(mTagValue, mAttributesStack.pop()));
						
					} else {
						mCurrentMaps.put(mEndTagName, initElement(mTagValue, mAttributesStack.pop()));
					}
				}
				else if (mTagDepth - 1 == mTagStack.size()) {

					mMaps = mCurrentMaps;
					mMaps.put(PAHashMap.KEY_ATTRIBUTES, mAttributesStack.pop());
					mCurrentMaps = mMapStack.pop();
					
					addElementToMap();
					mTagDepth -= 1;
				}

			}
		} catch (EmptyStackException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}
	
	private PAHashMap<String, Object> initElement(String text,PAHashMap attributes){
		
		PAHashMap<String, Object> mapItem = new PAHashMap<String, Object>();
		
		mapItem.put(PAHashMap.KEY_ATTRIBUTES, attributes);
		mapItem.put(PAHashMap.KEY_TEXT, text);
		
		return mapItem;
		
	}

	private void addElementToMap() {
		if (mCurrentMaps.containsKey(mEndTagName)) {
			int num = getElementNum(mCurrentMaps, mEndTagName);
			mCurrentMaps.put(mEndTagName + num, mMaps);
		} else {
			mCurrentMaps.put(mEndTagName, mMaps);
		}
	}

	/**
	 * 
	 * [获取当前map中elmentName元素名称]<BR>
	 * [功能详细描述]
	 * 
	 * @param currentMap
	 *            currentMap
	 * @param elementName
	 *            elementName
	 * @return int
	 */
	private int getElementNum(PAHashMap<String, Object> currentMap,
			String elementName) {
		HashMap<String, Object> maps = (HashMap<String, Object>) currentMap
				.clone();
		Iterator<Entry<String, Object>> iterator = maps.entrySet().iterator();
		int num = 0;
		String keyName = "";
		while (iterator.hasNext()) {
			Entry<String, Object> entry = iterator.next();
			keyName = entry.getKey();
			if (keyName.startsWith(elementName)) {
				num += 1;
			}
		}
		return num;
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) {
		String tagName = localName == "" ? qName : localName;

		buffer.delete(0, buffer.length());
		mStartTagName = tagName;
		
		PAHashMap<String, Object> mapAttributes = new PAHashMap<String, Object>();
		
		for(int i=0;i<attributes.getLength();i++){
			String key = attributes.getLocalName(i);
			String value = attributes.getValue(i);
			mapAttributes.put(key, value);
		}
		mAttributesStack.push(mapAttributes);
		
		if (mTagDepth + 1 == mTagStack.size()) {
			mMapStack.push(mCurrentMaps);
			
			mCurrentMaps = new PAHashMap<String, Object>();
			mTagDepth += 1;
		}
		
		mTagStack.push(mStartTagName);
	}

	@Override
	public void endDocument() {
		mCurrentMaps.toString();
		int size = mCurrentMaps.size();
	}

}
