package com.pingan.frame.http;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Handler;
import android.view.View;
import android.widget.ImageView;

import com.pingan.frame.http.bitmap.HttpBitmapRequest;
import com.pingan.frame.util.AppLog;
import com.pingan.frame.util.BitmapUtils;
import com.pingan.frame.util.DownloadFileSaveUtil;
import com.pingan.frame.util.DownloadFileSaveUtil.DownloadFileSave;
import com.pingan.frame.util.FileUtil;

public class BitmapManager {
	private final String TAG = "BitmapManager";
	
	
	
	private static BitmapManager mInstance;
	
	private final Object OB_LOCKED =  new Object();
	/**
	 * 缓存图片  软引用
	 */
	private HashMap<String, SoftReference<Bitmap>> mBitmapCache;
	
	private final int DEFAULT_MEMORY_SIZE = 1024*1024*6;
	
	private final float DEFAULT_MEMORY_SIZE_PERCENT = 0.5f;
	
	private final static String CACHE_RESOURCE = "resource";
	/**
	 * 构造函数
	 */
	private BitmapManager(){
		
	}
	
	/**
	 * 获取实例
	 * @author 	罗春
	 * @return	实例对象
	 */
	private static BitmapManager getInstance(){
		if(mInstance == null){
			mInstance = new BitmapManager();
		}
		return mInstance;
	}
	/**
	 * 初始化缓存相关配置
	 * @param context
	 */
	public void initCache(Context context){
		
		FileUtil.initTempRootPath(context);
		
		int memoryLength = DEFAULT_MEMORY_SIZE;
		final int MBytes = 1024*1024;
//		try{
//			ActivityManager activityManager = (ActivityManager)context.getSystemService(Context.ACTIVITY_SERVICE);
//			int memoryClass = activityManager.getLargeMemoryClass();
//			if(memoryClass>0){
//				AppLog.d(TAG, "httpFrame initCache 系统分配缓存大小M："+memoryClass+"M   " +
//							  "系统分配缓存Bytes:"+MBytes*memoryClass);
//				memoryLength = (int) (memoryClass * MBytes * DEFAULT_MEMORY_SIZE_PERCENT);
//			}else{
//				memoryLength = DEFAULT_MEMORY_SIZE;
//				AppLog.d(TAG, "httpFrame initCache 手动设置缓存大小M：4M   Bytes:"+memoryLength);
//			}
//		}catch(Exception ex){
//			memoryLength = DEFAULT_MEMORY_SIZE;
//		}
//		
		AppLog.d(TAG, "httpFrame initCache 实际设置缓存大小M："+memoryLength/MBytes+"M   Bytes:"+memoryLength);
		mBitmapCache = new HashMap<String, SoftReference<Bitmap>>();
	}
	
	
	
	/**
	 * 获取图片
	 * @author 	罗春
	 * @param request	请求对象
	 * @param context	context
	 * @return	如果存在内存中，则会直接返回，如果没有在内存中将在监听器中返回
	 */
	private Bitmap getBitmap(HttpBitmapRequest request,Context context){
		Bitmap bitmap = null;
		
		//查看图片是否存在内存当中
		bitmap = getBitmapFromCacheByUrl(request.getBitmapCacheUrl());
		
		//内存中的图片是否有效
		if(bitmap!=null&&!bitmap.isRecycled()){
			AppLog.i(TAG, "httpFrame getBitmap  已经存在内存中  正在从内存中获取图片");
			return bitmap;
		}
		//从网络请求图片
		requestBitmap(request,context);
		return null;
	}
	
	/**
	 * 缓存一张网络图片
	 * @author 罗春
	 * @param networkUrl
	 * @param bm
	 */
	private void cacheNetworkBitmap(String networkUrl,Bitmap bm){
		if(bm==null||bm.isRecycled()){
			AppLog.e(TAG, "httpFrame cacheNetworkBitmap 请不要缓存一个已经被释放资源的图片");
		}else{
			AppLog.i(TAG, "httpFrame cacheSoftReferenceBitmap 将"+networkUrl+"缓存到内存当中  当前已缓存数:"+mBitmapCache.size()+"  height:"+bm.getHeight()+"  width:"+bm.getWidth());
			mBitmapCache.put(networkUrl, new SoftReference<Bitmap>(bm));
		}
	}
	
	
	/**
	 * 从网络请求一张图片
	 * @param bitmapRequest	请求资源信息
	 * @param context		context
	 */
	private void requestBitmap(HttpBitmapRequest bitmapRequest,Context context){
		// 发送Http请求
		HttpConnector.sendHttpRequest(bitmapRequest);
	}
	
	/**
	 * 从内存中查找看看图片是否存在
	 * @author 罗春			
	 * @param networkUrl	
	 * @return
	 */
	private Bitmap getBitmapFromCacheByUrl(String networkUrl){
		if(networkUrl!=null){
			SoftReference<Bitmap> mSoftBitmap = mBitmapCache.get(networkUrl);
			if(mSoftBitmap!=null){
				Bitmap bitmap =  mSoftBitmap.get();
				if(bitmap!=null&&!bitmap.isRecycled()){
					return bitmap;
				}
				mBitmapCache.remove(networkUrl);
			}
		}
		return null;
	}
	
	private Bitmap getBitmapByResource(Context context,int resource){
		Bitmap bitmap = null;
		
		//查看图片是否存在内存当中
		bitmap = getBitmapFromCacheByUrl(CACHE_RESOURCE+resource);
		
		if(bitmap!=null&&!bitmap.isRecycled()){
			AppLog.i(TAG, "getBitmapByResource  从内存中获取资源文件");
			return bitmap;
		}
		
		Bitmap resourceBimmap = BitmapFactory.decodeResource(context.getResources(), resource);
		cacheNetworkBitmap(CACHE_RESOURCE+resource, resourceBimmap);
		return resourceBimmap;
	}
	
	private void getBitmapByResource(final View view,final Context context,
			final Handler handler,final int resource,
			final int maxWidth,final int maxHeight,final boolean isNeedCache){
		getBitmapByResource(view, context, handler, resource, maxWidth, maxHeight, isNeedCache,null,null);
	}
	
	private void getBitmapByResource(final View view,final Context context,
			final Handler handler,final int resource,
			final int maxWidth,final int maxHeight,final boolean isNeedCache,
			final ErrorCallback callback,final Object callbackObject){
		Bitmap bitmap = null;
		
		//查看图片是否存在内存当中
		bitmap = getBitmapFromCacheByUrl(CACHE_RESOURCE+resource+maxWidth+maxHeight);
		
		if(bitmap!=null&&!bitmap.isRecycled()){
			AppLog.i(TAG, "getBitmapByResource  从内存中获取资源文件");
			setBitmapToView(view, bitmap,callback,callbackObject);
			return ;
		}
		
		new Thread(){
			
			@Override
			public void run() {
				super.run();
				synchronized(OB_LOCKED){
					try{
						Bitmap bm = null;
						if(maxWidth>0&&maxHeight>0){
							bm = BitmapUtils.getBitmap(resource,context, maxWidth,
									maxHeight,null);
						}else{
							bm = BitmapUtils.getBitmap(resource,context, HttpBitmapRequest.DEFAULT_MEASURE_WIDTH,
									HttpBitmapRequest.DEFAULT_MEASURE_HEIGHT,null);
						}
						
						if(isNeedCache&&bm!=null&&!bm.isRecycled()){
							cacheNetworkBitmap(CACHE_RESOURCE+resource+maxWidth+maxHeight, bm);
						}
						
						setBitmapToView(handler, view, bm,callback,callbackObject);
					}catch(Exception ex){
						ex.printStackTrace();
						if(callback!=null){
							callback.onError(callbackObject);
						}
					}
					
				}
			}
			
		}.start();
		
	}
	
	private void getBitmap(View imageview,Context context,String imagePath,
			Handler handler){
		getBitmap(imageview,context, imagePath, handler,false, -1, -1);
	}
	
	private void getBitmap(View imageview,Context context,String imagePath,
			Handler handler,boolean isNeedCache){
		getBitmap(imageview,context, imagePath, handler, isNeedCache, -1, -1);
	}
	
	private void getBitmap(final View imageview,Context context,final String imagePath,
			final Handler handler,final boolean isNeedCache,final int maxWidth,final int maxHeight){
		getBitmap(imageview, context, imagePath, handler, isNeedCache, maxWidth, maxHeight, null, null);
	}
	
	
	private void getBitmap(final View imageview,Context context,final String imagePath,
			final Handler handler,final boolean isNeedCache,final int maxWidth,final int maxHeight,
			final ErrorCallback callback,final Object callbackObject){
		
		Bitmap bitmap = null;
		
		//查看图片是否存在内存当中
		bitmap = getBitmapFromCacheByUrl(imagePath+maxWidth+maxHeight);
		
		if(bitmap!=null&&!bitmap.isRecycled()){
			AppLog.i(TAG, "getBitmapByResource  从内存中获取资源文件");
			setBitmapToView(imageview, bitmap,callback,callbackObject);
			return ;
		}
		
		new Thread(){
			
			@Override
			public void run() {
				super.run();
				synchronized(OB_LOCKED){
					try{
						Bitmap bm = null;
						if(maxWidth>0&&maxHeight>0){
							bm = BitmapUtils.getBitmap(imagePath, maxWidth,
									maxHeight,null);
						}else{
							bm = BitmapUtils.getBitmap(imagePath, HttpBitmapRequest.DEFAULT_MEASURE_WIDTH,
									HttpBitmapRequest.DEFAULT_MEASURE_HEIGHT,null);
						}
						
						int angle = BitmapUtils.readPictureDegree(imagePath);
						if(angle>0){
							bm = BitmapUtils.rotaingImageView(angle, bm);
						}
						
						if(isNeedCache&&bm!=null&&!bm.isRecycled()){
							cacheNetworkBitmap(imagePath+maxWidth+maxHeight, bm);
						}
						
						setBitmapToView(handler, imageview, bm,callback,callbackObject);
					}catch(Exception ex){
						ex.printStackTrace();
						if(callback!=null){
							callback.onError(callbackObject);
						}
					}
					
				}
			}
			
		}.start();
	}
	
	private Bitmap getSmallBitmapFromCache(final Context context,
			final String imageUrl,final String styleName,
			final Handler handler){
		
		Bitmap bitmap = null;
		
		final String xmlCacheUrl = imageUrl+styleName;
		
		//查看图片是否存在内存当中
		bitmap = getBitmapFromCacheByUrl(xmlCacheUrl);
		
		if(bitmap!=null&&!bitmap.isRecycled()){
			AppLog.i(TAG, "getBitmapFromCache  从内存中获取资源文件");
			return bitmap;
		}
		
		String filePath = DownloadFileSaveUtil.
				getUsableCachePath(context, xmlCacheUrl);
		
		if(filePath!=null){
			return BitmapUtils.getBitmap(filePath, HttpBitmapRequest.DEFAULT_MEASURE_WIDTH,
					HttpBitmapRequest.DEFAULT_MEASURE_HEIGHT,null);
		}else{
			return null;
		}
		
		
	}
	
	
	public void removeCacheLocalBitmap(Context context,String downloadUrl){
		
	}
	
	public void removeCacheLocalBitmap(Context context,List<String> downloadUrlList){
		
	}
	
	private String getLocalPathByUrl(Context context,String url,String styleName){
		DownloadFileSave fileSave =  DownloadFileSaveUtil.getFile(context, url+styleName);
		//如果存在  并且下载完毕了
		if(fileSave!=null&&fileSave.getDownloaStatus()==DownloadFileSave.DOWNLOAD_STATUS_FINISH){
			return fileSave.getFilePath();
		}
		return null;
	}
	
	private String getLocalPathByUrl(Context context,String url){
		return getLocalPathByUrl(context, url, "");
	}
	
	private void setBitmapToView(View view,Bitmap bm,ErrorCallback callback,Object callbackObject){
		if(bm==null||bm.isRecycled()){
			AppLog.e(TAG, "资源已经被释放  无法渲染view");
			if(callback!=null){
				callback.onError(callbackObject);
			}
		}
		if(view instanceof ImageView){
			ImageView imageView =  (ImageView) view;
			imageView.setImageBitmap(bm);
		}
		else{
			view.setBackgroundDrawable(new BitmapDrawable(bm));
		}
	}
	
	private void setBitmapToView(Handler handler,final View view,final Bitmap bm,
			final ErrorCallback callback,final Object callbackObject){
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				try {
					setBitmapToView(view, bm,callback,callbackObject);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		
	}
	
	public static interface ErrorCallback{
		public void onError(Object ob);
	}
	
}
