/*
 * 文  件   名： HttpHelper.java
 * 版          权： Copyright GoPawPaw All Rights Reserved.
 * 描          述：[该类的简要描述]
 * 创  建   人： LiJinHua
 * 创建时间： 2012-3-28
 * 
 * 修   改  人：
 * 修改时间：
 * 修改内容：[修改内容]
 */
package com.pingan.frame.http;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import com.pingan.frame.util.AppLog;

/**
 * 
 * [网络发辅助工具类]<BR>
 * [功能详细描述]
 * 
 * @author Luochun
 * @version [Android PABank C01, 2011-12-20]
 */
public class HttpHelper {
	
	/**
	 * TAG
	 */
	private static final String TAG = HttpHelper.class.getSimpleName();
	
	public static String initURL(String url,Object data){
		try {
			if (!hasProtocol(url)) {
				return null;
			}
			if(data!=null){
				String paramData = getRequestURLParam(data);
				return url +"?"+ paramData;
			}else{
				return url;
			}
			
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			AppLog.e(TAG, "httpFrame threadName:"+Thread.currentThread().getName()+" initURL HttpHelper initURL  存在非法的传参  "+data);
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 
	 * [包装请求参数]<BR>
	 * [map类型的，将map转为String，并按需求添加chanelType字段<br/>
	 * String类型的，按需求添加chanelType字段]
	 * 
	 * @param object
	 *            请求体
	 * @param urlId
	 *            请求ID
	 * @return String 包装后的请求体
	 * @throws UnsupportedEncodingException 
	 */
	@SuppressWarnings("unchecked")
	public static String getRequestURLParam(Object object) throws UnsupportedEncodingException {
		if(object == null){
			return "";
		}
		String requestData = "";
		if (object instanceof Map) {
			Map<String, String> paramMap = (Map<String, String>) object;
			requestData = getRequestURLParam(paramMap);
		} else {
			requestData = (String) object;
		}
		return requestData;
	}

	/**
	 * 
	 * [将参数Map<String,String>转化为URL参数String]<BR>
	 * [ 如：<br>
	 * hashMap.put("user", "username");<br>
	 * hashMap.put("pass", "password");<br>
	 * 转换后为：user=username&pass= password]
	 * 
	 * @param paramMap
	 *            请求参数字典
	 * @param urlId
	 *            请求ID
	 * @return String 包装好的请求参数
	 * @throws UnsupportedEncodingException 
	 */
	private static String getRequestURLParam(Map<String, String> paramMap
			) throws UnsupportedEncodingException {

		StringBuffer queryBuffer = new StringBuffer();

		if (paramMap == null) {
			// 过滤NullPointerException
			return queryBuffer.toString();
		}

		Iterator<String> it = paramMap.keySet().iterator();
		while (it.hasNext()) {
			String key = it.next();
			Object obj = paramMap.get(key);
			String valuse = "";
			if(obj instanceof byte[]){
				valuse = new String((byte[])obj);
			}else{
				valuse = ""+obj;
			}

			if (!"".equals(queryBuffer.toString())) {
				// 第一个参数
				queryBuffer.append("&");
			}
			queryBuffer.append(key);
			queryBuffer.append("=");
			queryBuffer.append(valuse);
		}
		return queryBuffer.toString();

	}
	
	/**
	 * ssl not verify
	 */
	public static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier() {
		public boolean verify(String hostname, SSLSession session) {
			return true;
		}
	};

	/**
	 * [Trust every server - dont check for any certificate]<BR>
	 */
	public static void trustAllHosts() {
		// Create a trust manager that does not validate certificate chains
		TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
			public java.security.cert.X509Certificate[] getAcceptedIssuers() {
				return new java.security.cert.X509Certificate[]{};
			}

			public void checkClientTrusted(X509Certificate[] chain,
					String authType) throws CertificateException {
			}

			public void checkServerTrusted(X509Certificate[] chain,
					String authType) throws CertificateException {
			}
		}};

		// Install the all-trusting trust manager
		try {
			SSLContext sc = SSLContext.getInstance("TLS");
			sc.init(null, trustAllCerts, new java.security.SecureRandom());
			HttpsURLConnection
					.setDefaultSSLSocketFactory(sc.getSocketFactory());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	
	/**
	 * 获取主机地址
	 * @return
	 */
	public static String getHostFromUrl(String urlString) {
		String host = null;
		try {
			URL url = new URL(urlString);
			host = url.getProtocol()+"://"+url.getHost();
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			AppLog.e(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" getHostFromUrl "+e.getMessage());
		}
		
		return host;
	}
	
	/**
	 * 
	 * [检查请求地址是否包含网络协议]<BR>
	 * [功能详细描述]
	 * 
	 * @param sendURL
	 *            请求Url全路径
	 * @return true:包含协议 false:不包含协议
	 */
	public static boolean hasProtocol(String sendURL) {
		boolean hasProtocol = false;
		try {
			URL url = new URL(sendURL);
			url.getProtocol();
			hasProtocol = true;
		} catch (MalformedURLException e) {
			e.printStackTrace();
			AppLog.e(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" hasProtocol "+e.getMessage());
		}
		return hasProtocol;
	}

	
}
