package com.pingan.frame.http;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import com.pingan.frame.http.listener.HttpListener;
import com.pingan.frame.http.listener.HttpSimpleListener;

import android.os.Handler;

public abstract class HttpRequest {
	
	/**
	 * GET请求
	 */
	public static final String REQUEST_METHOD_GET = "GET";
	
	/**
	 * POST请求
	 */
	public static final String REQUEST_METHOD_POST = "POST";
	
	/**
	 * 将放在队列的最顶部(下一个任务就是它了)
	 */
	public static final int FIRST_LEVEL_TOP = 1;
	/**
	 * 将放在队列的最底部(别人处理完了,再进行处理我)
	 */
	public static final int FIRST_LEVEL_BOTTOM = 2;
	/**
	 * 立马执行,开启一个独立的进程专门处理我
	 */
	public static final int FIRST_LEVEL_SOON = 3;
	/**
	 * 清空同类队列后再请求
	 */
	public static final int FIRST_LEVEL_CLEAR_TOP = 4;
	
	/**
	 * 数据报文请求类型
	 */
	public static final int REQUEST_TYPE_ACTION = 1;
	
	/**
	 * 文件下载请求类型
	 */
	public static final int REQUEST_TYPE_DOWNLOAD = 2;
	
	/**
	 * 上传文件请求类型
	 */
	public static final int REQUEST_TYPE_UPLOAD = 3;
	
	/**
	 * 下载地址
	 */
	protected String mUrl;

	/**
	 * 优先级别
	 */
	protected int mFirstLevel = FIRST_LEVEL_TOP;
	/**
	 * 是否被服务器响应 
	 */
	private boolean isResponse = false;
	/**
	 * 任务已经被处理,
	 */
	private boolean isExecute = false;
	
	/**
	 * UI线程Handler
	 */
	private Handler mHandler ;
	/**
	 * 客户端记录标示,标示着是哪笔请求返回了
	 */
	private Object[] mObArrary;
	/**
	 * 请求方式  "GET"  "POST"
	 */
	protected String mRequestMethod;
	/**
	 * 头部信息设置
	 */
	private HashMap<String, Object> mHeaderMap;

	/**
	 * 监听列表
	 */
	protected HttpSimpleListener mHttpListener = null;
	/**
	 * 相同的任务处理
	 */
	private List<HttpRequest> mSameRequestList = new ArrayList<HttpRequest>();

	/**
	 * post url传参
	 */
	private Object mPostURLParam;
	/**
	 * 
	 * @param url
	 * @param paramMap
	 */
	public HttpRequest(String url,String requestMethod){
		this.mUrl = url;
		this.mHandler = null;
		this.mRequestMethod = requestMethod;
		this.mHeaderMap = null;
	}
	
	/**
	 * 
	 * @param url
	 * @param paramMap
	 * @param handler
	 */
	public HttpRequest(String url,Handler handler,String requestMethod){
		this.mUrl = url;
		this.mHandler = handler;
		this.mRequestMethod = requestMethod;
		this.mHeaderMap = null;
	}
	
	public HttpRequest(String url,Handler handler,String requestMethod,HashMap<String, Object> headerMap){
		this.mUrl = url;
		this.mHandler = handler;
		this.mRequestMethod = requestMethod;
		this.mHeaderMap = headerMap;
	}
	
	/**
	 * 
	 * @param url
	 * @param paramMap
	 * @param firstLevel
	 * @param handler
	 */
	public HttpRequest(String url,int firstLevel,Handler handler,String requestMethod,HashMap<String, Object> headerMap){
		this.mUrl = url;
		this.mFirstLevel = firstLevel;
		this.mHandler = handler;
		this.mRequestMethod = requestMethod;
		this.mHeaderMap = headerMap;
	}
	
	public void setUrl(String mUrl) {
		this.mUrl = mUrl;
	}

	public void setHeaderMap(HashMap<String, Object> mHeaderMap) {
		this.mHeaderMap = mHeaderMap;
	}
	
	public HashMap<String, Object> getHeaderMap() {
		return mHeaderMap;
	}

	/**
	 * 客户端记录标示,标示着是哪笔请求返回了
	 */
	public void setData(Object... ob){
		this.mObArrary = ob;
	}
	/**
	 * 获取客户端记录标示
	 * @return	如果记录了多个标示则返回一个Object数组,如果只记录了一个则返回一个Object
	 */
	public Object getData(){
		if(mObArrary!=null){
			if(mObArrary.length==1){
				return mObArrary[0];
			}else{
				return mObArrary;
			}
		}else{
			return null;
		}
	}
	
	public boolean isResponse() {
		return isResponse;
	}

	public void setResponse(boolean isResponse) {
		this.isResponse = isResponse;
	}

	public boolean isExecute() {
		return isExecute;
	}

	public void setExecute(boolean isExecute) {
		this.isExecute = isExecute;
	}

	public String getUrl() {
		return mUrl;
	}

	public Handler getHandler() {
		return mHandler;
	}
	
	public HttpSimpleListener getHttpListener() {
		return mHttpListener;
	}
	
	/**
	 * post url参数封装
	 * @param paramData 参数
	 */
	public void setPostUrlParamData(String paramData){
		this.mPostURLParam = paramData;
	}
	
	/**
	 * 
	 * post url参数封装
	 * @param paramData 参数
	 */
	public void setPostUrlParamData(HashMap<String, String> paramData){
		this.mPostURLParam = paramData;
	}
	
	/**
	 * 获取post url参数封装数据
	 * @return
	 */
	public Object getPostUrlParamData(){
		return this.mPostURLParam;
	}
	
	/**
	 * 是否是完整的可用的任务
	 * @return	如果返回true代表是完整的可执行的任务
	 */
	public boolean isComplete(){
		if(HttpHelper.hasProtocol(mUrl)&&
			(mRequestMethod == REQUEST_METHOD_GET || mRequestMethod == REQUEST_METHOD_POST)){
			return true;
		}
		return false;
	}
	
	/**
	 * 获取优先级别
	 * @author 罗春
	 * @return
	 */
	public abstract int getFirstLevel();
	
	
	
	/**
	 * 读取数据timeOut
	 * @return	读取数据timeOut时间
	 */
	public abstract long getReadTimeout();
	
	/**
	 * 连接TimeOut
	 * @return	连接TimeOut时间
	 */
	public abstract long getConnectTimeout();
	/**
	 * 请求参数
	 * @return
	 */
	public abstract Object getParamData() throws Exception;
	
	/**
	 * 处理网络之前   做些什么
	 * @author 罗春
	 * 2011-7-20
	 */
	public abstract HttpResponse onPreExecute() throws Exception;
	
	public abstract void onPreExecute(HttpURLConnection connection) throws Exception;
	
	public abstract HttpResponse onDoingExecute(HttpURLConnection connection) throws Exception;
	
	/**
	 * 网络交互完毕怎么处理
	 * @author 罗春
	 * 2011-7-20
	 */
	public abstract void onPostExecute(boolean isSuccess);
	/**
	 * 创建相应的response
	 * @return
	 */
	public abstract HttpResponse createErrorResponse(int state,HttpRequest httpTask);
	
	/**
	 * httpListener
	 * @param mHttpListener
	 */
	public void setHttpListener(HttpSimpleListener mHttpListener) {
		this.mHttpListener = mHttpListener;
	}
	
	/**
	 * 请求处理类型,下载类型 还是 上传类型 等等
	 * @return
	 */
	public abstract int getRequestType();
	/**
	 * 是否是重复请求的任务,如果是重复请求的任务则不会放入任务列表
	 * 重复任务和相同任务不会点:
	 * 	相同任务:会进行累加监听回调
	 * 	重复任务:则不会给与任何处理
	 * @return 如果是重复任务返回true
	 */
	public boolean isRepeatRequest(HttpRequest reqeust){
//		if(mObArrary!=null){
//			if(mObArrary.equals(reqeust.getData())){
//				return true;
//			}
//		}
		return false;
	}
	
	public String getRequestMethod() {
		return mRequestMethod;
	}
	
	public void setRequestMethod(String reqeustMethod){
		this.mRequestMethod = reqeustMethod;
	}
	/**
	 * 
	 * @param handler
	 */
	public void setHandler(Handler handler){
		this.mHandler = handler;
	}
	
	protected void addSameRequest(HttpRequest sameRequest){
		mSameRequestList.add(sameRequest);
	}
	
	protected List<HttpRequest> getSameRequestList(){
		return mSameRequestList;
	}
	
}
