package com.pingan.frame.http;

public abstract class HttpResponse {
	
	/**
	 * 状态成功
	 */
	public static final int STATE_SUCCESS = 0;
	
	/**
	 * 状态失败
	 */
	public static final int STATE_FAILED = 1;
	
	/**
	 * 网络不可用
	 */
	public static final int STATE_NETWORK_ENABLE= 101;
	
	/**
	 * HTTP请求失败
	 */
	public static final int STATE_HTTP_FALSE = 2;
	
	/**
	 * HTTP读取数据失败
	 */
	public static final int STATE_READ_FALSE = 3;
	/**
	 * 内存不足够
	 */
	public static final int STATE_MEMORY_NOT_ENOUGH = 4;
	/**
	 * 创建请求出错
	 */
	public static final int STATE_CREATE_REQUEST_ERROR = 5;
	
	private int mStateCode;
	
	

	private HttpRequest mHttpTask;
	
	private HttpRequest mHttpContinueTask;
	
	public HttpResponse(int state,HttpRequest httpRequest){
		this.mStateCode = state;
		this.mHttpTask = httpRequest;
	}
	
	public HttpResponse(int state,HttpRequest httpRequest,HttpRequest httpContinueRequest){
		this.mStateCode = state;
		this.mHttpTask = httpRequest;
		this.mHttpContinueTask = httpContinueRequest;
	}
	
	public HttpRequest getHttpContinueRequest(){
		return this.mHttpContinueTask;
	}
	
	public abstract HttpResponse createSameResponse(HttpRequest httpRequest);
	
	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return "mStateCode:"+mStateCode+"  url:"+mHttpTask.getUrl();
	}
	
	
	public int getStateCode() {
		return mStateCode;
	}

	public HttpRequest getHttpRequest() {
		return mHttpTask;
	}
}
