/*
 * 文  件   名： HttpThread.java
 * 版          权： Copyright GoPawPaw All Rights Reserved.
 * 描          述：[该类的简要描述]
 * 创  建   人： LiJinHua
 * 创建时间： 2012-5-8
 * 
 * 修   改  人：
 * 修改时间：
 * 修改内容：[修改内容]
 */
/*
 * 文  件   名： HttpThread.java
 * 版          权： Copyright GoPawPaw All Rights Reserved.
 * 描          述：[该类的简要描述]
 * 创  建   人： LiJinHua
 * 创建时间： 2012-5-8
 * 
 * 修   改  人：
 * 修改时间：
 * 修改内容：[修改内容]
 */
package com.pingan.frame.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.net.ssl.HttpsURLConnection;

import org.json.JSONObject;

import android.os.Handler;

import com.pingan.frame.http.download.HttpDownloadRequest;
import com.pingan.frame.http.listener.HttpListener;
import com.pingan.frame.http.listener.HttpProgressListener;
import com.pingan.frame.http.listener.HttpSimpleListener;
import com.pingan.frame.http.listener.HttpWriteParamCallback;
import com.pingan.frame.util.AppLog;
import com.pingan.frame.util.Tools;

/**
 * Http请求线程类
 * 
 * @version [Android 1.0.0, 2012-5-7]
 */
public class HttpThread extends Thread {

	/**
	 * TAG标签
	 */
	private static final String TAG = HttpThread.class.getSimpleName();

	/**
	 * 当前Http请求对象
	 */
	private HttpRequest mHttpRequest;


	/**
	 * 线程监听器，用于在线程中获取Http请求
	 */
	private HttpThreadListener mHttpThreadListener;

	/**
	 * URL请求链接对象
	 */
	private HttpURLConnection urlConnection;

	/**
	 * 是否已经信任https所有主机，标记只执行一次信任，若每次都执行，则在android4.1以上
	 * 请求多次时会请求失败
	 */
	private static boolean hasTrustAllHosts = false;
	
	public HttpThread(HttpThreadListener httpThreadListener) {
		this.mHttpThreadListener = httpThreadListener;
	}

	@Override
	public void run() {


		AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" HttpThread : " + this.getName() + " 开始运行!! ");

		while (true) {
			synchronized (mHttpThreadListener) {
				mHttpRequest = mHttpThreadListener.getHttpRequest();
				if(mHttpRequest == null){
					mHttpThreadListener.requestWait(this);
					continue;
				}
			}
			// 如果存在请求，则一直执行
			try {
				HttpResponse httpResponse = mHttpRequest.onPreExecute();
				if(httpResponse!=null){
					postHttpFinish(mHttpRequest,httpResponse);
				}
				else{
					AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" HttpThread : " + this.getName() + "  开始请求==> "
							+ mHttpRequest.getUrl());
					postHttpBegin(mHttpRequest);
					httpResponse = httpConnect(mHttpRequest);
					if(httpResponse!=null){
						HttpRequest httpContinueRequest = null;
						
						while((httpContinueRequest = httpResponse.getHttpContinueRequest()) !=null){
							AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" HttpThread : " + this.getName() + "  开始连续请求==> "
									+ mHttpRequest.getUrl());
							httpResponse = httpConnect(httpContinueRequest);
						}
					}
					postHttpFinish(mHttpRequest,httpResponse);
					if(httpResponse.getStateCode()==HttpResponse.STATE_SUCCESS){
						mHttpRequest.onPostExecute(true);
					}else{
						mHttpRequest.onPostExecute(false);
					}
					
				}
			}
			catch (HttpOperateException ex){
				ex.printStackTrace();
				throw new RuntimeException("崩溃了");
			}
			catch (Exception e) {
				e.printStackTrace();
				postHttpError();
				AppLog.e(TAG,
						"httpFrame  threadName:"+Thread.currentThread().getName()+" HttpThread 连接失败 ：url ==> "
								+ mHttpRequest.getUrl() + " Exception:"
								+ e.toString());

			} 
			catch (OutOfMemoryError e) {
				e.printStackTrace();
				postHttpError();
				AppLog.e(TAG,
						"httpFrame  threadName:"+Thread.currentThread().getName()+" 内存溺出");
			}
			finally {
				mHttpThreadListener.finishHttpRequest(mHttpRequest);
				mHttpRequest = null;
				urlConnection = null;
			}

		}
			
	}
	
	private void postHttpError(){
		try {
			postHttpFinish(mHttpRequest, mHttpRequest.
					createErrorResponse(HttpResponse.STATE_FAILED, mHttpRequest));
		} catch (HttpOperateException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
			throw new RuntimeException("崩溃了");
		}
		mHttpRequest.onPostExecute(false);
	}
	/**
	 * 处理开始回调
	 * @param httpRequest
	 * @throws HttpOperateException
	 */
	private void postHttpBegin(final HttpRequest httpRequest) throws HttpOperateException{
		updateHttpBegin(httpRequest);
		
		List<HttpRequest> sameRequestList = httpRequest.getSameRequestList();
		for(int i=0;i<sameRequestList.size();i++){
			AppLog.w(TAG, "httpFrame postHttpBegin 累加监听回调");
			updateHttpBegin(sameRequestList.get(i));
		}
		
	}
	/**
	 * 处理开始回调
	 * @param httpRequest	被处理的任务
	 * @throws HttpOperateException 前端逻辑崩溃 
	 */
	private void updateHttpBegin(final HttpRequest httpRequest) throws HttpOperateException{
		
		if(httpRequest.getHttpListener() instanceof HttpListener){
			Handler handler = httpRequest.getHandler();
			final HttpListener httpLinstener = (HttpListener) httpRequest.getHttpListener();
			//如果需要UI线程
			if(handler!=null){
				handler.post(new Runnable() {
					
					@Override
					public void run() {
						// TODO Auto-generated method stub
						AppLog.i(TAG, "httpFrame updateHttpBegin UI线程  "+httpRequest.getUrl());
						httpLinstener.onHttpBegin(httpRequest);
					}
				});
			}else{
				AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" updateHttpBegin 非UI线程  "+httpRequest.getUrl());
				try{
					httpLinstener.onHttpBegin(httpRequest);
				}catch(Exception ex){
					throw new HttpOperateException(ex);
				}
			}
		}
		
	}
	/**
	 * 处理结束回调
	 * @param httpRequest
	 * @param httpResponse
	 * @throws HttpOperateException
	 */
	public static void postHttpFinish(final HttpRequest httpRequest,
			final HttpResponse httpResponse) throws HttpOperateException{
		try {
			HttpSimpleListener simpleListener = HttpConnector.getHttpFilterListener();
			if(simpleListener!=null){
				simpleListener.onHttpFinish(httpResponse);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		
		HttpThread.updateHttpFinish(httpRequest,httpResponse,false);
		
		List<HttpRequest> sameRequestList = httpRequest.getSameRequestList();
		for(int i=0;i<sameRequestList.size();i++){
			AppLog.w(TAG, "httpFrame postHttpFinish 累加监听回调");
			HttpThread.updateHttpFinish(sameRequestList.get(i),httpResponse,true);
		}
	}
	
	/**
	 * 处理结束回调
	 * @param httpRequest	被处理的任务
	 * @param httpResponse	任务处理的结果
	 * @throws HttpOperateException 
	 */
	public static void updateHttpFinish(final HttpRequest httpRequest,
			final HttpResponse httpResponse,final boolean isSameRequest) throws HttpOperateException{
		if(httpRequest.getHttpListener() instanceof HttpSimpleListener){
			Handler handler = httpRequest.getHandler();
			final HttpSimpleListener httpLinstener = (HttpSimpleListener) httpRequest.getHttpListener();
			//如果需要UI线程
			if(handler!=null){
				handler.post(new Runnable() {
					
					@Override
					public void run() {
						// TODO Auto-generated method stub
						AppLog.i(TAG, "httpFrame updateHttpFinish UI线程     httpResponse:"+httpResponse.toString());
						if(isSameRequest){
							httpLinstener.onHttpFinish(httpResponse.createSameResponse(httpRequest));
						}else{
							httpLinstener.onHttpFinish(httpResponse);
						}
					}
				});
			}else{
				AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+"  updateHttpFinish  httpResponse:"+httpResponse.toString());
				try{
					if(isSameRequest){
						httpLinstener.onHttpFinish(httpResponse.createSameResponse(httpRequest));
					}else{
						httpLinstener.onHttpFinish(httpResponse);
					}
				}catch(Exception ex){
					throw new HttpOperateException(ex);
				}
			}
		}
	}
	
	
	
	/**
	 * 进度条反馈
	 * @param hasReadBytes		已经读取了多少数据
	 * @param fileContentLength	总共有多少数据等待读取
	 * @throws HttpOperateException 
	 */
	public static void postUploadProgress(final HttpRequest httpRequest,long hasReadBytes,long fileContentLength) throws HttpOperateException{
		
		final float percent = ((hasReadBytes / (float) fileContentLength) * 100f);
		final long sumLength = fileContentLength;
		final long downloadLength = hasReadBytes;
		
		HttpThread.updateUploadProgress(httpRequest, percent, downloadLength, sumLength);
		
		List<HttpRequest> sameRequestList = httpRequest.getSameRequestList();
		for(int i=0;i<sameRequestList.size();i++){
			AppLog.w(TAG, "httpFrame postUploadProgress 累加监听回调");
			HttpThread.updateUploadProgress(sameRequestList.get(i), percent, downloadLength, sumLength);
		}
	}
	
	/**
	 * 进度反馈
	 * @param percent			百分比
	 * @param downloadLength	下载了多少字节
	 * @param sumLength			总共需要下载的字节数
	 * @throws HttpOperateException 
	 */
	public static void updateUploadProgress(final HttpRequest httpRequest,
			final float percent,final long downloadLength,final long sumLength) throws HttpOperateException{
		AppLog.i(TAG, "httpFrame updateProgress 正在处理回调  Length:"+downloadLength+"  sumLength:"+sumLength);
		if(httpRequest.getHttpListener() instanceof HttpProgressListener){
			Handler handler = httpRequest.getHandler();
			final HttpProgressListener httpLinstener = (HttpProgressListener) httpRequest.getHttpListener();
			//如果需要UI线程
			if(handler!=null){
				handler.post(new Runnable() {
					
					@Override
					public void run() {
						// TODO Auto-generated method stub
						AppLog.i(TAG, "httpFrame updateProgress 回调 UI线程   Length:"+downloadLength+"  sumLength:"+sumLength);
						httpLinstener.onProgress(httpRequest, percent, downloadLength, sumLength);
					}
				});
			}else{
				AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" updateProgress 回调 非UI线程  Length:"+downloadLength+"  sumLength:"+sumLength);
				try{
					httpLinstener.onProgress(httpRequest, percent, downloadLength, sumLength);
				}catch(Exception ex){
					throw new HttpOperateException(ex);
				}
			}
		}
	}

	/**
	 * Http链接
	 * @throws Exception
	 */
	private HttpResponse httpConnect(HttpRequest httpRequest) throws Exception {
		// 打开连接
		openConnection(httpRequest);

//		// 设置请求头部属性
		setHttpProperty(httpRequest);
//
//		// 处理POST或GET参数
		handleParam(httpRequest);

		AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" HttpThread  准备开始建立连接");
		urlConnection.connect();
		AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" HttpThread  已经成功建立连接");
		// 响应头部信息
		if(handleResponseHead()){
			// 获得响应头
			HttpCookie.getResponseCookies(urlConnection);

			// 响应数据信息
			return handleResponseData(httpRequest);
		}
		return null;
	}

	/**
	 * 打开链接
	 * 
	 * @throws IOException
	 */
	private void openConnection(HttpRequest httpRequest) throws Exception {
		String urlString = "";
		if (HttpRequest.REQUEST_METHOD_POST.equals(httpRequest
				.getRequestMethod())) {
			// 处理POST请求操作
			// 拼接URL protocol
			urlString = HttpHelper.initURL(httpRequest.getUrl(),httpRequest.getPostUrlParamData());
			AppLog.d(TAG,"httpFrame  threadName:"+Thread.currentThread().getName()+" POST 打开连接：");
		} else {
			// 处理GET请求操作
			// 拼接URL protocol 和 参数
			urlString = HttpHelper.initURL(httpRequest.getUrl(),
					httpRequest.getParamData());
			AppLog.d(TAG,"httpFrame  threadName:"+Thread.currentThread().getName()+" GET 打开连接：");
		}
		
		if(urlString==null){
			throw new Exception("请求url地址错误  url:"+urlString);
		}
		
		URL url = new URL(urlString);

		if (urlString.startsWith("https")) {

			if(!hasTrustAllHosts){
				// 使用自己的证书，信任所有服务器证书
				HttpHelper.trustAllHosts();
				hasTrustAllHosts = true;
			}
			urlConnection = (HttpsURLConnection) url.openConnection();
			((HttpsURLConnection)urlConnection).setHostnameVerifier(HttpHelper.DO_NOT_VERIFY);
		} else {
			urlConnection = (HttpURLConnection) url.openConnection();

		}

//		urlConnection.setDoOutput(true);
		urlConnection.setDoInput(true);
	}

	/**
	 * 设置请求头部属性
	 * 
	 * @throws IOException
	 */
	private void setHttpProperty(HttpRequest httpRequest) throws Exception {
		// 设置连接主机超时（单位：毫秒）
		urlConnection.setConnectTimeout((int) httpRequest.getConnectTimeout());
		// 设置从主机读取数据超时（单位：毫秒）
		urlConnection.setReadTimeout((int) httpRequest.getReadTimeout());

		String cookie = null;
		Object obj = HttpCookie.getRequestCookies(httpRequest.getUrl());
		if (obj != null)
			cookie = obj.toString();
		urlConnection.setRequestProperty("Cookie", cookie);
		urlConnection.setRequestProperty("connection", "keep-alive");
		urlConnection.setRequestProperty(
						"Accept",
						"image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
		urlConnection.setRequestProperty("Accept-Language", "zh-CN");
		urlConnection.setRequestProperty("Charset", "UTF-8");
		
		httpRequest.onPreExecute(urlConnection);
		HashMap<String, Object> paramMap = httpRequest.getHeaderMap();
		
		if(paramMap != null){
			Iterator<String> it = paramMap.keySet().iterator();
			while (it.hasNext()) {
				String key = it.next();
				obj = paramMap.get(key);
				String valuse = "";
				if(obj instanceof byte[]){
					valuse = new String((byte[])obj);
				}else{
					valuse = ""+obj;
				}
				urlConnection.setRequestProperty(key, valuse);
			}
		}
		
	}

	/**
	 * 处理POST 或 GET 参数
	 * 
	 * @throws IOException
	 */
	private void handleParam(HttpRequest httpRequest) throws Exception {
		if (HttpRequest.REQUEST_METHOD_POST.equals(httpRequest
				.getRequestMethod())) {
			AppLog.d(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleParam  POST 正在设置参数");
			urlConnection.setDoOutput(true);
			// 处理POST请求操作

			urlConnection.setRequestMethod("POST");
			
			Object paramData = httpRequest.getParamData();
			
			if(paramData==null){
				return;
			}
			if(paramData instanceof byte[]){
				byte[] bytes = (byte[])paramData;
				OutputStream out = new DataOutputStream(urlConnection.getOutputStream());
				out.write(bytes, 0, bytes.length);
				out.close();
				AppLog.d(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleParam  POST paramData 二进制数据");
			}
			else if(paramData instanceof JSONObject){
				JSONObject paramJson = (JSONObject) paramData;
				String jsonStr = paramJson.toString();
				PrintStream send = new PrintStream(urlConnection.getOutputStream());
				send.print(httpRequest.getParamData());
				send.close();
				AppLog.d(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleParam  POST JsonParam :"+jsonStr);
			}
			else if(paramData instanceof HashMap){
				String paramMap = HttpHelper.getRequestURLParam(paramData);
				PrintStream send = new PrintStream(urlConnection.getOutputStream());
				send.print(paramMap);
				send.close();
				AppLog.d(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleParam  POST mapParam :"+paramMap);
			}
			else if(paramData instanceof HttpWriteParamCallback){
				((HttpWriteParamCallback)paramData).writeParam(urlConnection);
				AppLog.d(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleParam  POST paramData 自定义格式  ");
			}
			else{
				PrintStream send = new PrintStream(urlConnection.getOutputStream());
				send.print(httpRequest.getParamData());
				send.close();
				AppLog.d(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleParam  POST paramData ：" + httpRequest.getParamData());
			}
			
			AppLog.d(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleParam  POST 设置参数完毕");
		} else {
			// 处理GET请求操作
			AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" HttpThread  本次请求是GET");
			urlConnection.setRequestMethod("GET");
		}
	}

	/**
	 * 处理响应头部
	 * 
	 * @throws IOException
	 */
	private boolean handleResponseHead() throws Exception {

		// 获得响应码
		int reponseCode = urlConnection.getResponseCode();
		
		
		
		
		AppLog.w(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleResponseHead reponseCode = "+reponseCode);
		if (reponseCode != 200) {
			// 响应码不是200时关闭连接
			String responseMessage = urlConnection.getResponseMessage();
			String errorMsg = Tools.inputStream2String(urlConnection.getErrorStream());
			AppLog.e(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" handleResponseHead reponseCode = "+reponseCode+ "   responseMessage:"+responseMessage+"  errorMsg:"+errorMsg);
			urlConnection.disconnect();
			throw new Exception("网络请求错误");
		} else {
			// 成功响应
//			httpResponse.setResponseCode(HttpResponse.RESPONSE_CODE_SUCCESS);
//			httpResponse.setContentLength(urlConnection.getContentLength());
//			httpResponse.setContentType(urlConnection.getContentType());
//			httpResponse.setContentEncoding(urlConnection.getContentEncoding());
			return true;
		}
	}

	/**
	 * 处理响应数据
	 * 
	 * @throws IOException
	 */
	private HttpResponse handleResponseData(HttpRequest httpRequest) throws Exception {

		return httpRequest.onDoingExecute(urlConnection);
	}

	public HttpThreadListener getHttpThreadListener() {
		return mHttpThreadListener;
	}
	
	
}

/**
 * HttpThread线程监听器，用于获取HttpRequest对象
 * 
 * @author LiJinHua
 * @version [Android 1.0.0, 2012-5-8]
 */
interface HttpThreadListener {
	/**
	 * 获取HttpRequest对象
	 * 
	 * @return
	 */
	public HttpRequest getHttpRequest();

	/**
	 * 完成一个HttpRequest处理
	 * 
	 * @param httpRequest
	 */
	public void finishHttpRequest(HttpRequest httpRequest);
	
	/**
	 * 请求等待
	 * [一句话功能简述]<BR>
	 * [功能详细描述]
	 * @param httpThread
	 */
	public void requestWait(HttpThread httpThread);
}
