package com.pingan.frame.http.action;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.HashMap;

import org.json.JSONObject;

import android.R.integer;
import android.text.TextUtils;

import com.pingan.frame.datahandle.PADataHandler;
import com.pingan.frame.http.HttpRequest;
import com.pingan.frame.http.HttpResponse;
import com.pingan.frame.util.AppFluxLog;
import com.pingan.frame.util.AppLog;
import com.pingan.frame.util.JZlibUtil;
import com.pingan.frame.util.PA3DesCoder;
import com.pingan.frame.util.PAHashMap;
import com.pingan.frame.util.Tools;

public class HttpActionRequest extends HttpRequest {
	
	

	private final String TAG = "HttpActionRequest";
	/**
	 * 数据传参
	 */
	private Object mParamData;
	
	private int mResultType = RESULT_TYLE_NORMAL;
	
	private String mFriendSession = null;
	/**
	 * 默认值为RESULT_TYLE_NORMAL
	 * 返回结果集  String
	 */
	public static final int RESULT_TYLE_STRING = 100;
	/**
	 * 默认值
	 * 返回结果集  如果是xml 返回hashmap 
	 * 			 如果是jason 返回JSONOBJECT 
	 */
	public static final int RESULT_TYLE_NORMAL = 200;
	/**
	 * byte数组  为垃圾嘉建提供
	 */
	public static final int RESULT_TYPE_UNCOMPRESS_STRING = 300;
	
	/**
	 * 
	 * @param url			请求地址
	 * @param requestMethod	
	 */
	public HttpActionRequest(String url, String requestMethod) {
		super(url, requestMethod);
	}

	@Override
	public int getFirstLevel() {
		return FIRST_LEVEL_BOTTOM;
	}

	@Override
	public long getReadTimeout() {
		return 40000;
	}

	@Override
	public long getConnectTimeout() {
		return 40000;
	}
	
	/**
	 * 设置传参   POST 会使用此方法进行传参
	 * 封装的outputStream 里面的数据就会变成 
	 * {aaa:"aaa",bbb:"bbb", ccc:"ccc"，ddd:"ddd"}
	 * @param paramData
	 */
	public void setParamData(JSONObject paramData){
		this.mParamData = paramData;
	}
	
	/**
	 * 设置传参 GET POST 都可以使用此方法进行传参
	 * 如果是GET:
	 * 	会将参数封装在URL当中
	 * 如果是POST:
	 * 	封装的outputStream 里面的数据就会变成 
	 * 	appId=value&userID=value&timestamp=value
	 * @param paramData
	 */
	public void setParamData(HashMap<String, String> paramData){
		this.mParamData = paramData;
	}
	
	@Override
	public Object getParamData() {
		return mParamData;
	}

	@Override
	public HttpResponse onPreExecute() throws Exception {
		return null;
	}

	@Override
	public HttpResponse onDoingExecute(HttpURLConnection connection)
			throws Exception {
		InputStream is = connection.getInputStream();
		//为嘉建个垃圾提供，如遇问题他负责
		if(mResultType == RESULT_TYPE_UNCOMPRESS_STRING){
			String length = connection.getHeaderField("ucLength");
			byte[] bytes = Tools.inputStream2ByteArrary(is);
			byte[] compressBytes = JZlibUtil.uncompressfile(bytes,Integer.parseInt(length));
			String key = Tools.buildSessionKey(mFriendSession);
			String data = PA3DesCoder.decryptThreeDESECB(compressBytes, key);
			return new HttpActionResponse(HttpResponse.STATE_SUCCESS, this,data);
		}
		else if(mResultType == RESULT_TYLE_STRING){
			String dataStr = Tools.inputStream2String(is);
			return new HttpActionResponse(HttpResponse.STATE_SUCCESS, this,dataStr);
		}
		else{
			String dataStr = Tools.inputStream2String(is);
			JSONObject jsonObject = null;
			try{
				jsonObject = new JSONObject(dataStr);
				return new HttpActionResponse(HttpResponse.STATE_SUCCESS, this,jsonObject);
			}catch(Exception ex){
				AppLog.w(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+"  服务器返回的不是json数据");
				ex.printStackTrace();
			}
			try{
				PADataHandler parse = new PADataHandler();
				parse.parseData(dataStr.getBytes());
				PAHashMap<String, Object> maps = parse.getObjectMap();
				if(maps!=null){
					return new HttpActionResponse(HttpResponse.STATE_SUCCESS, this,maps);
				}
			}catch(Exception ex){
				ex.printStackTrace();
				AppLog.w(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+"  服务器返回的不是XML数据");
			}
			return new HttpActionResponse(HttpResponse.STATE_SUCCESS, this,dataStr);
		}
		
	}

	@Override
	public void onPostExecute(boolean isSuccess) {
		
	}

	@Override
	public HttpResponse createErrorResponse(int state, HttpRequest httpTask) {
		return new HttpActionResponse(state, httpTask);
	}
	
	
	
	@Override
	public boolean isComplete() {
		// TODO Auto-generated method stub
		if(Tools.isEmpty(getUrl())){
			AppLog.e(TAG, "httpFrame 访问的地址不能为空");
			return false;
		}
		if(mResultType==RESULT_TYPE_UNCOMPRESS_STRING && Tools.isEmpty(mFriendSession)){
			AppLog.e(TAG, "httpFrame 没有传递friendSession无法做网络请求操作");
			return false;
		}
		
		return true;
	}
	
	public void setResultType(int resultType){
		this.mResultType = resultType;
	}

	public void setResultType(int resultType,String friendSession){
		this.mResultType = resultType;
		this.mFriendSession = friendSession;
	}
	
	@Override
	public int getRequestType() {
		return REQUEST_TYPE_ACTION;
	}

	@Override
	public void onPreExecute(HttpURLConnection connection) throws Exception {
		
	}

}
