package com.pingan.frame.http.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.text.TextUtils;

import com.pingan.frame.http.BitmapManager;
import com.pingan.frame.http.HttpRequest;
import com.pingan.frame.http.HttpResponse;
import com.pingan.frame.http.download.HttpDownloadRequest;
import com.pingan.frame.http.listener.TokenCallback;
import com.pingan.frame.util.AppLog;
import com.pingan.frame.util.BitmapUtils;
import com.pingan.frame.util.DownloadFileSaveUtil;
import com.pingan.frame.util.DownloadFileSaveUtil.DownloadFileSave;
import com.pingan.frame.util.FileUtil;
import com.pingan.frame.util.Tools;

/**
 * 图片请求相关逻辑代码
 * @author ex-luochun001
 */
public class HttpBitmapRequest extends HttpDownloadRequest {
	/**
	 * 默认高度
	 */
	public static final int DEFAULT_MEASURE_HEIGHT = 960;
	/**
	 * 默认宽度
	 */
	public static final int DEFAULT_MEASURE_WIDTH = 960;
	
	/**
	 * TAG
	 */
	private final String TAG = "HttpBitmapRequest";
	
	/**
	 * 图片是否需要缓存到内存
	 */
	private boolean isNeedCache = true;
	
	/**
	 * 压缩最大高度
	 */
	private int mMaxMeasureHeight = -1;
	/**
	 * 压缩最大宽度
	 */
	private int mMaxMeasureWidth = -1;
	/**
	 * options
	 */
	private BitmapFactory.Options mOptions = null;
	
	/**
	 * 图片缩略图 100*100 
	 */
	public static final String STYLE_NAME_IMAGE_SMALL = "small";
	/**
	 * 视频缩略图 100*100 
	 */
	public static final String STYLE_NAME_VIDEO_IMAGE_SMALL = "vset_small";
	
	public static final String STYLE_NAME_IMAGE_SMALL_160 = "small160";
	
	public static final String STYLE_NAME_IMAGE_SMALL_360 = "small360";
	
	public static final String STYLE_NAME_IMAGE_SMALL_480 = "small480";
	
	public static final String STYLE_NAME_IMAGE_SMALL_600 = "small600";
	
	public static final String STYLE_NAME_IMAGE_SMALL_810 = "small810";
	
	public static final String STYLE_NAME_CLIP_IMAGE_SMALL_80 = "smallj80";
	
	public static final String STYLE_NAME_CLIP_IMAGE_SMALL_120 = "smallj120";
	
	public static final String STYLE_NAME_CLIP_IMAGE_SMALL_160 = "smallj160";
	
	public static final String STYLE_NAME_CLIP_IMAGE_SMALL_200 = "smallj200";
	
	public static final String STYLE_NAME_CLIP_IMAGE_SMALL_270 = "smallj270";
	
	
	
	public HttpBitmapRequest(Context context,String downloadUrl,String requestMethod){
		super(context,downloadUrl, null,null);
		setRequestMethod(requestMethod);
	}
	
	/**
	 * 原图片下载构造函数
	 * @param downloadUrl	图片下载地址
	 * @param filePath		图片本地缓存地址(可以为null,当不为null时代表曾经下载过，并且保存到了本地)
	 * @param savePath		下载完图片保存的路径
	 * @param tokenCallback	token获取回调
	 */
	public HttpBitmapRequest(Context context,String downloadUrl,String savePath,TokenCallback tokenCallback) {
		super(context,downloadUrl, savePath,tokenCallback);
	}
	
	/**
	 * 带样式(缩略图)的图片下载构造函数
	 * @param downloadUrl	图片下载地址
	 * @param styleName		图片样式缩略图相关
	 * @param filePath		图片本地缓存地址(可以为null,当不为null时代表曾经下载过，并且保存到了本地)
	 * @param savePath		下载完图片保存的路径
	 * @param tokenCallback	token获取回调
	 */
	public HttpBitmapRequest(Context context,String downloadUrl,String styleName, String savePath,TokenCallback tokenCallback) {
		super(context,downloadUrl, savePath,styleName,tokenCallback);
	}
	
	public void setOptions(BitmapFactory.Options options){
		this.mOptions = options;
	}

	@Override
	public HttpResponse onPreExecute() throws Exception {
		// TODO Auto-generated method stub
		//try代码快    判断是否能从本地取  如果能从本地取 则没不要访问网络
		boolean isNeedSave = false;
		String filePath = (String) DownloadFileSaveUtil.getUsableCachePath(mContext, mCacheXmlUrl);
		if(TextUtils.isEmpty(filePath)){
			filePath = (String) DownloadFileSaveUtil.getUsableCachePath(mContext, getFileName());
			isNeedSave = true;
			AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" 拿不到缩略图  尝试获取大图  filePath:"+filePath);
		}
		try{
			if(!TextUtils.isEmpty(filePath)){
				Bitmap bm = null;
				if(mMaxMeasureHeight>0&&mMaxMeasureWidth>0){
					bm = BitmapUtils.getBitmap(filePath, mMaxMeasureWidth,mMaxMeasureHeight,mOptions);
				}else{
					bm = BitmapUtils.getBitmap(filePath, DEFAULT_MEASURE_WIDTH,DEFAULT_MEASURE_HEIGHT,mOptions);
				}
				if(bm!=null&&!bm.isRecycled()){
					if(isNeedCache){
//						BitmapManager.getInstance().cacheNetworkBitmap(getBitmapCacheUrl(), bm);
					}
					if(isNeedSave&&!Tools.isEmpty(getSavePath())){
						
						String imagePath = saveImageFile(FileUtil.getExtensionName(filePath), bm,
								DownloadFileSave.FIXED_LENGTH,DownloadFileSave.FIXED_LENGTH);
						
						if(!Tools.isEmpty(imagePath)){
							filePath = imagePath;
						}
					}
					AppLog.i(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" 已经从内存卡中获取到相应的图片  mFilePath:"+filePath);
					return new HttpBitmapResponse(HttpResponse.STATE_SUCCESS, this, bm, filePath);
				}
				
			}
		}catch(Exception ex){
			ex.printStackTrace();
			AppLog.w(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" 图片转换失败   路径不是可用的一张图片  mFilePath:"+filePath);
		}
		//如果下载地址不存在,并且又没从本地取到图片,则报错
		if(TextUtils.isEmpty(getFileName())){
			AppLog.e(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" 没有在sdcard中找到相应的图片  mFilePath:"+filePath);
			return new HttpBitmapResponse(HttpResponse.STATE_FAILED, this);
		}
		return super.onPreExecute();
	}

	@Override
	public HttpResponse executeContent(byte[] content,String extension,long fileLength) {
		// TODO Auto-generated method stub
		//得到图片
		Bitmap downloadBitmap = BitmapFactory.decodeByteArray(content, 0, content.length);
		if(mMaxMeasureHeight>0&&mMaxMeasureWidth>0){
			downloadBitmap = BitmapUtils.getBitmap(content,mMaxMeasureWidth,mMaxMeasureHeight,mOptions);
		}else{
			downloadBitmap = BitmapUtils.getBitmap(content,DEFAULT_MEASURE_WIDTH,DEFAULT_MEASURE_HEIGHT,mOptions);
		}
		//如果是可用的图片
		return excuteBitmap(downloadBitmap,null,extension);
	}
	
	
	
	@Override
	protected HttpResponse executeContent(String filePath,String extension,long fileLength) {
		Bitmap downloadBitmap = null;
		Bitmap saveBitmap = null;
		String imagePath = null;
		if(mMaxMeasureHeight>0&&mMaxMeasureWidth>0){
			downloadBitmap = BitmapUtils.getBitmap(filePath,mMaxMeasureWidth,mMaxMeasureHeight,mOptions);
			//如果需要保存图片
			if(!Tools.isEmpty(getSavePath())){
				saveBitmap =  BitmapUtils.getBitmap(filePath,DEFAULT_MEASURE_WIDTH,DEFAULT_MEASURE_HEIGHT,mOptions);
			}
		}else{
			downloadBitmap = BitmapUtils.getBitmap(filePath,DEFAULT_MEASURE_WIDTH,DEFAULT_MEASURE_HEIGHT,mOptions);
			//如果需要保存图片
			if(!Tools.isEmpty(getSavePath())){
				saveBitmap =  downloadBitmap;
			}
		}
		
		if(saveBitmap!=null){
			imagePath = saveImageFile(extension, saveBitmap,fileLength,mContentLength);
		}
		
		if(filePath!=null){
			FileUtil.deleteFile(filePath);
		}
		
		return excuteBitmap(downloadBitmap,imagePath,extension);
	}
	
	private HttpResponse excuteBitmap(Bitmap downloadBitmap,String imagePath,String extension){
		
		if(downloadBitmap!=null&&!downloadBitmap.isRecycled()){
			if(isNeedCache){
//				BitmapManager.getInstance().cacheNetworkBitmap(this.getBitmapCacheUrl(), downloadBitmap);
			}
			
			return new HttpBitmapResponse(HttpResponse.STATE_SUCCESS, this, downloadBitmap, imagePath);
		}
		return new HttpBitmapResponse(HttpResponse.STATE_HTTP_FALSE, this, null, null);
	}
	
	private String saveImageFile(String extension,Bitmap saveBitmap,long fileLength,long contentLength){
		String imagePath = null;
		CompressFormat format = CompressFormat.PNG;
		
		if(BitmapUtils.EXTENSION_IMG_JPEG.equalsIgnoreCase(extension)){
			format = CompressFormat.JPEG;
		}else{
			format = CompressFormat.PNG;
		}
		
		if(!Tools.isEmpty(getSavePath())){
			imagePath = FileUtil.saveBitmap(getSavePath(), saveBitmap, format, extension);
			
			if(!Tools.isEmpty(imagePath)){
				DownloadFileSaveUtil.saveFile(mContext, mCacheXmlUrl, 
						new DownloadFileSave(imagePath));
			}
			
		}
		return imagePath;
	}

	public void setMaxMeasureSize(int maxMeasureWidth,int maxMeasureHeight){
		mMaxMeasureWidth = maxMeasureWidth;
		mMaxMeasureHeight = maxMeasureHeight;
	}
	
	@Override
	public HttpResponse createErrorResponse(int state, HttpRequest httpTask) {
		// TODO Auto-generated method stub
		return new HttpBitmapResponse(state,httpTask);
	}
	
	/**
	 * 设置是否需要缓存的内存当中
	 * @param isCache	true为缓存 默认为需要缓存
	 */
	public void changeIsCache(boolean isCache){
		this.isNeedCache = isCache;
	}
	
	@Override
	public boolean isComplete() {
		
		if(Tools.isEmpty(getFileName())){
			AppLog.e(TAG, "httpFrame 图片下载时  下载地址  不能为null");
			return false; 
		}
		return true;
	}

	@Override
	public boolean equals(Object o) {
		if(o instanceof HttpBitmapRequest){
			HttpBitmapRequest tempRequest = (HttpBitmapRequest)o;
			String curdownloadUrl = getFileName()+getStyleName();
			String equalsDownloadUrl = tempRequest.getFileName()+tempRequest.getStyleName();
			if(!Tools.equals(curdownloadUrl, equalsDownloadUrl)){
				return false;
			}
		}
		return super.equals(o);
	}
	
	public String getBitmapCacheUrl(){
		return mCacheXmlUrl+mMaxMeasureWidth+mMaxMeasureHeight;
	}
	
}
