package com.pingan.frame.http.bitmap;

import android.graphics.Bitmap;

import com.pingan.frame.http.HttpRequest;
import com.pingan.frame.http.HttpResponse;

/**
 * 图片请求返回
 * @author ex-luochun001
 */
public class HttpBitmapResponse extends HttpResponse {
	
	/**
	 * 视频高清  libx264	mp4	480x320	700k	libfaac	128k	48k
	 */
	public static final String STYLE_NAME_VIDEO_HIGHT = "android_high";
	/**
	 * 视频低清  libx264	mp4	480x320	96k		libfaac	64k		48k
	 */
	public static final String STYLE_NAME_VIDEO_LOW = "android_low";
	/**
	 * 视频标准  libx264	mp4	480x320	512k	libfaac	128k	48k
	 */
	public static final String STYLE_NAME_VIDEO_NORMAL = "android";
	/**
	 * bitmap
	 */
	private Bitmap mBitmap;
	/**
	 * 图片保存的地址
	 */
	private String mImagePath;
	/**
	 * 如果请求存在会使用此构造函数
	 * @param state			网络状态
	 * @param httpRequest	request
	 */
	protected HttpBitmapResponse(int state, HttpRequest httpRequest) {
		super(state, httpRequest);
	}
	
	/**
	 * 图片请求处理成功会使用 此构造函数
	 * @param state			网络访问状态码 
	 * @param httpRequest	httpRequest
	 * @param bitmap		图片
	 * @param imagePath		图片保存路径
	 */
	protected HttpBitmapResponse(int state, HttpRequest httpRequest,
			Bitmap bitmap,String imagePath) {
		super(state, httpRequest);
		this.mBitmap =  bitmap;
		this.mImagePath = imagePath;
	}

	/**
	 * 获取图片
	 * @return
	 */
	public Bitmap getBitmap() {
		return mBitmap;
	}
	/**
	 * 获取图片缓存本地的路径
	 * @return
	 */
	public String getImageLocalPath() {
		return mImagePath;
	}
	
	


	@Override
	public String toString() {
		if(getStateCode()==STATE_SUCCESS){
			return "图片下载成功     保存到地址:"+mImagePath;
		}else{
			return "图片下载失败";
		}
	}

	@Override
	public HttpResponse createSameResponse(HttpRequest httpRequest) {
		// TODO Auto-generated method stub
		return new HttpBitmapResponse(getStateCode(), httpRequest, mBitmap, mImagePath);
	}
}
