package com.pingan.frame.http.download;

import com.pingan.frame.http.HttpResponse;
import com.pingan.frame.http.HttpRequest;

public class HttpDownloadResponse extends HttpResponse{
	/**
	 * fileName
	 */
	private String mFilePath;
	
	/**
	 * 如果请求存在问题会使用此构造函数
	 * @param state			网络状态
	 * @param httpRequest	request
	 */
	protected HttpDownloadResponse(int state,HttpRequest httpRequest) {
		super(state,httpRequest);
	}
	
	/**
	 * 下载请求处理成功会使用 此构造函数
	 * @param state			网络状态
	 * @param httpRequest	request
	 * @param filePath		将资源保存在的路径
	 */
	protected HttpDownloadResponse(int state,HttpRequest httpRequest, String filePath) {
		super(state,httpRequest);
		this.mFilePath = filePath;
	}
	/**
	 * GET
	 * @return	将资源下载保存的路径
	 */
	public String getFilePath() {
		return mFilePath;
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		if(getStateCode()==STATE_SUCCESS){
			return "文件下载成功     保存到地址:"+mFilePath;
		}else{
			return "文件下载失败";
		}
	}

	@Override
	public HttpResponse createSameResponse(HttpRequest httpRequest) {
		// TODO Auto-generated method stub
		return new HttpDownloadResponse(getStateCode(), httpRequest, mFilePath);
	}
	
}
