package com.pingan.frame.http.upload;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import org.json.JSONException;
import org.json.JSONStringer;

import com.pingan.frame.http.listener.TokenCallback;

public class AuthPolicy {
	public String scope;
	public String callbackUrl;
	public String returnUrl;
	public long deadline;
	
	public AuthPolicy(String scope, long expires) {
		this.scope = scope;
		this.deadline = System.currentTimeMillis() / 1000 + expires;
	}

	public void setCallbackUrl(String callbackUrl) {
		this.callbackUrl = callbackUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String marshal() throws JSONException {

		JSONStringer stringer = new JSONStringer();
		
		stringer.object();
		stringer.key("scope").value(this.scope);
		if (this.callbackUrl != null) {
			stringer.key("callbackUrl").value(this.callbackUrl);
		}
		if (this.returnUrl != null) {
			stringer.key("returnUrl").value(this.returnUrl);
		}
		stringer.key("deadline").value(this.deadline);
		stringer.endObject();

		return stringer.toString();
	}

	public byte[] makeAuthToken() {

		String ACCESS_KEY = "xTkgBPqYztp0F2I47txhAknL15_FW0sNsoz8ZdPp";
		String SECRET_KEY = "x7GA0d9nrPcnSMVkA_k-ux76uM-cEKlYvkajij3r";
		
		byte[] accessKey = ACCESS_KEY.getBytes();
		byte[] secretKey = SECRET_KEY.getBytes();
		try {
			String policyJson = this.marshal();
			byte[] policyBase64 = HttpUploadUtil.urlsafeEncodeBytes(policyJson.getBytes());

			Mac mac = Mac.getInstance("HmacSHA1");
			SecretKeySpec keySpec = new SecretKeySpec(secretKey, "HmacSHA1");
			mac.init(keySpec);

			byte[] digest = mac.doFinal(policyBase64);
			byte[] digestBase64 = HttpUploadUtil.urlsafeEncodeBytes(digest);			
			byte[] token = new byte[accessKey.length + 30 + policyBase64.length];

			System.arraycopy(accessKey, 0, token, 0, accessKey.length);
			token[accessKey.length] = ':';
			System.arraycopy(digestBase64, 0, token, accessKey.length + 1, digestBase64.length);
			token[accessKey.length + 29] = ':';
			System.arraycopy(policyBase64, 0, token, accessKey.length + 30, policyBase64.length);

			return token;
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (InvalidKeyException e) {
			e.printStackTrace();
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}

	
	public static HashMap<String, String> getDefaultToken(){
		String bucketName = "luochun";
        AuthPolicy policy = new AuthPolicy(bucketName, 3600);
        String tokenStr = policy.makeAuthTokenString();
        
        HashMap<String, String> hashMap = new HashMap<String, String>();
        
        hashMap.put(TokenCallback.KEY_TOKEN, tokenStr);
        hashMap.put(TokenCallback.KEY_ETC, "http://luochun.u.qiniudn.com/");
        
        return hashMap;
	}
	
	/**
	 * 
	 * 根据{@link #com.pingan.frame.http.listener.TokenCallback.KEY_TOKEN}获取空间名
	 * @param hostUrl	 TokenCallback.KEY_TOKEN
	 * @return	BucketName
	 */
	public static String getBucketName(String hostUrl){
		//http://pingantxt.qiniudn.com  
		//http://pinganimg.qiniudn.com  
		int startIndex = hostUrl.indexOf("//");
		int endIndex = hostUrl.indexOf(".");
		return hostUrl.substring(startIndex+2,endIndex);
	}
	
	public String makeAuthTokenString() {
		byte[] authToken = this.makeAuthToken();
		return new String(authToken);
	}
}
