package com.pingan.frame.http.upload;

import org.json.JSONException;
import org.json.JSONObject;

import android.graphics.Bitmap;

import com.pingan.frame.http.HttpRequest;
import com.pingan.frame.http.HttpResponse;

public class HttpUploadResponse extends HttpResponse {
	/**
	 * 七牛返回的文件hash值
	 */
	public static final String KEY_HASH = "hash";
	/**
	 * 七牛返回的上传成功后的文件名
	 */
	public static final String KEY_FILE_NAME = "key";
	/**
	 * 文件名
	 */
	private String mFileName = "";
	/**
	 * hash
	 */
	private String mHash = "";
	/**
	 * 下载地址
	 */
	private String mDownloadUrl = "";
	
	private String mImageLocalPath = "";
	
	/**
	 * 如果请求存在问题会使用此构造函数
	 * @param state			状态马
	 * @param httpRequest	request
	 */
	protected HttpUploadResponse(int state, HttpRequest httpRequest) {
		super(state, httpRequest);
	}
	/**
	 * 上传请求处理成功会使用 此构造函数
	 * @param state				状态码
	 * @param httpRequest		httpRequest
	 * @param responseObject	responseObject
	 * @param hostUrl			hostUrl
	 */
	protected HttpUploadResponse(int state, HttpRequest httpRequest,JSONObject responseObject,String hostUrl) {
		super(state, httpRequest);
		try {
			this.mFileName = responseObject.getString(KEY_FILE_NAME);
			if(hostUrl!=null){
				this.mDownloadUrl = hostUrl + "/"+this.mFileName;
			}else{
				this.mDownloadUrl = this.mFileName;
			}
			this.mHash = responseObject.getString(KEY_HASH);
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * 上传请求处理成功会使用 此构造函数
	 * @param state				状态码
	 * @param httpRequest		httpRequest
	 * @param responseObject	responseObject
	 * @param hostUrl			hostUrl
	 */
	protected HttpUploadResponse(int state, HttpRequest httpRequest,String smallImagePath,
			JSONObject responseObject,String hostUrl) {
		super(state, httpRequest);
		try {
			this.mFileName = responseObject.getString(KEY_FILE_NAME);
			if(hostUrl!=null){
				this.mDownloadUrl = hostUrl + "/"+this.mFileName;
			}else{
				this.mDownloadUrl = this.mFileName;
			}
			
			this.mImageLocalPath = smallImagePath;
			
			this.mHash = responseObject.getString(KEY_HASH);
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * 处理累加监听会用到此构造函数
	 * @param state			状态码
	 * @param httpRequest	httpRequest
	 * @param fileName		上传成功后的文件名
	 * @param hash			上传成功后的文件的hash
	 * @param downloadUrl	下载地址
	 */
	private HttpUploadResponse(int state, HttpRequest httpRequest,String fileName,
			String hash,String downloadUrl){
		super(state, httpRequest);
		this.mFileName = fileName;
		this.mHash = hash;
		this.mDownloadUrl = downloadUrl;
	}
	

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		if(getStateCode()==STATE_SUCCESS){
			return "文件上传成功     文件名称:"+mFileName+"  mHash:"+mHash+"  文件地址:"+mDownloadUrl+"  mImageLocalPath:"+mImageLocalPath;
		}else{
			return "文件上传失败";
		}
		
	}
	/**
	 * GET
	 * @return	上传成功后的文件名
	 */
	public String getFileName() {
		return mFileName;
	}
	/**
	 * GET
	 * @return	上传成功后的文件的hash
	 */
	public String getHash() {
		return mHash;
	}

	/**
	 * 只有公有资源才会有下载地址
	 * 私有资源必须通过FileName进行获取下载地址
	 * @return
	 */
	public String getDownloadUrl() {
		return mDownloadUrl;
	}

	@Override
	public HttpResponse createSameResponse(HttpRequest httpRequest) {
		
		return new HttpUploadResponse(getStateCode(), httpRequest, getFileName(), mHash, mDownloadUrl);
	}
	
	/**
	 * 获取压缩后的图片的路径
	 * @return
	 */
	public String getImageLocalPath() {
		return mImageLocalPath;
	}
}
