package com.pingan.frame.http.upload;

import java.io.RandomAccessFile;

import android.util.Base64;

import com.pingan.frame.util.AppLog;


public class HttpUploadUtil {
	/**
	 * TAG
	 */
	private static final String TAG = "HttpUploadUtil";
	/**
	 * 每大块的字节数
	 */
	public static int BLOCK_SIZE = 4 * 1024 * 1024;	 // 4M
	/**
	 * 每大块中的小块字节数
	 */
	public static int PUT_CHUNK_SIZE = 20 * 1024;	 // 256K
	/**
	 * 上传HOST
	 */
	public static String UP_HOST = "http://up.qbox.me";
	
	public static String UP_HOST_URL = "http://up.qbox.me/upload";
	/**
	 * 认证token key
	 */
	public static final String REQEUST_HEADER_AUTHORIZTION = "Authorization";
	
	/**
	 * 当前是否是大块的结束
	 * @param hasUploadBytes	已经上传字节数
	 * @param fileLength		总共字节数
	 * @param blockCount		总共有多少大块
	 * @param blockIndex		当前处于那个大块
	 * @return	boolean 返回true代表当前是大块的结束
	 */
	public static boolean isBlockEnd(long hasUploadBytes,long fileLength,int blockCount,int blockIndex){
		//如果是最后一个大块
		if((blockIndex+1) == blockCount){
			return (fileLength == hasUploadBytes);
		}else{
			return (hasUploadBytes % HttpUploadUtil.BLOCK_SIZE == 0);
		}
	}
	/**
	 * 获取下一个要上传的字节数组
	 * @param fileIO			IO流
	 * @param hasUploadBytes	已经上传字节数
	 * @param fileLength		总共字节数
	 * @param blockIndex		当前处于那个大块
	 * @param blockCount		总共有多少大块
	 * @return	本次要上传的字节数组
	 * @throws Exception
	 */
	public static byte[] nextChunk(RandomAccessFile fileIO,long hasUploadBytes,
			long fileLength,int blockIndex,int blockCount) throws Exception{
		
		//当前快剩余没有上传得字节数
		long blockRemain = getBlockRemain(hasUploadBytes, fileLength, blockIndex, blockCount);
		
		//当前快剩余未上传得字节数
		if(blockRemain>0){
			fileIO.seek(hasUploadBytes);
			
			int curChunkbyteLength =  (int) (blockRemain > HttpUploadUtil.PUT_CHUNK_SIZE ? 
					 HttpUploadUtil.PUT_CHUNK_SIZE : blockRemain);
			byte[] bytes = new byte[curChunkbyteLength];
			
			int readByteLength = fileIO.read(bytes, 0, curChunkbyteLength);
			if(readByteLength == curChunkbyteLength){
				return bytes;
			}
			AppLog.e(TAG, "httpFrame  threadName:"+Thread.currentThread().getName()+" nextChunk  读取字节数失败  hasReadBytes:"+hasUploadBytes+"  fileLength:"+fileLength+"  blockIndex:"+blockIndex+"  blockCount:"+blockCount);
			throw new Exception("nextChunk  读取字节数失败  hasReadBytes:"+hasUploadBytes+"  fileLength:"+fileLength+"  blockIndex:"+blockIndex+"  blockCount:"+blockCount);
		}
		
		return null;
	}
	
	/**
	 * 获取当前大块还剩余多少没上传
	 * @param hasUploadBytes	已经上传字节数
	 * @param fileLength		总共字节数
	 * @param blockIndex		当前处于那个大块
	 * @param blockCount		总共有多少大块
	 * @return	当前大块还剩余多少没上传
	 */
	private static long getBlockRemain(long hasUploadBytes,
			long fileLength,int blockIndex,int blockCount){
		//如果是最后一个大块
		if((blockIndex+1) == blockCount){
			return fileLength - hasUploadBytes;
		}else{
			return (HttpUploadUtil.BLOCK_SIZE * (blockIndex+1)) - hasUploadBytes;
		}
	}
	
	/**
	 * 获取当前大块已经上传的多少
	 * @param hasUploadBytes	已经上传字节数
	 * @param fileLength		总共字节数
	 * @param blockIndex		当前处于那个大块
	 * @param blockCount		总共有多少大块
	 * @return 当前大块已经上传的多少
	 */
	public static long getBlockOffset(long hasUploadBytes,
			long fileLength,int blockIndex,int blockCount){
		//如果是最后一个大块
		if((blockIndex+1) == blockCount){
			return (fileLength - blockIndex * HttpUploadUtil.BLOCK_SIZE) - getBlockRemain(hasUploadBytes, fileLength, blockIndex, blockCount);
		}else{
			return HttpUploadUtil.BLOCK_SIZE - getBlockRemain(hasUploadBytes, fileLength, blockIndex, blockCount);
		}
		
	}
	/**
	 * 获取总共需要多少大块
	 * @param fileLength	总共字节数
	 * @return 总共需要多少大块
	 */
	public static int getBlockCount(long fileLength) {
		int blockCount = (int) (fileLength / HttpUploadUtil.BLOCK_SIZE);
		
		if(fileLength % HttpUploadUtil.BLOCK_SIZE >0){
			blockCount++;
		}
		
		return blockCount;
	}
	/**
	 * 创建下一大块
	 * @param hasUploadBytes	已经上传字节数
	 * @param fileLength		总共字节数
	 * @param blockIndex		当前处于那个大块
	 * @param blockCount		总共有多少大块
	 * @return	本次大块有多少字节
	 */
	public static long makeBlockLength(long hasUploadBytes,
			long fileLength,int blockIndex,int blockCount){
		//如果是最后一个大块
		if((blockIndex+1) == blockCount){
			return fileLength - hasUploadBytes;
		}else{
			return HttpUploadUtil.BLOCK_SIZE;
		}
	}
	
	/**
	 * 合并大块
	 * @param checkSumArrary	所有大块的checkSum数组  这个chekcSum是七云每次上传一块都会返回的
	 * @return 
	 */
	public static byte[] getCheckSums(String[] checkSumArrary){
		byte[] body = new byte[20 * checkSumArrary.length];
		
		for (int i = 0; i < checkSumArrary.length; i++) {
			
			byte[] buf = urlsafeDecode(checkSumArrary[i]) ;
			
			System.arraycopy(buf,  0, body, i * 20, buf.length);
		}
		return body;
	}
	
	/**
	 * 转码
	 * @param src
	 * @return
	 */
	public static String urlsafeEncodeString(byte[] src) {
		return new String(urlsafeEncodeBytes(src));
	}
	/**
	 * 转码
	 * @param text
	 * @return
	 */
	public static String urlsafeEncode(String text) {
		return new String(urlsafeEncodeBytes(text.getBytes()));
	}
	/**
	 * 转码
	 * @param src
	 * @return
	 */
	public static byte[] urlsafeEncodeBytes(byte[] src) {
		if (src.length % 3 == 0) {
			return Base64.encode(src, Base64.URL_SAFE | Base64.NO_WRAP);
		}
		
		byte[] b = Base64.encode(src, Base64.URL_SAFE | Base64.NO_WRAP);
		if (b.length % 4 == 0) {
			return b;
		}
		
		int pad = 4 - b.length % 4;
		byte[] b2 = new byte[b.length + pad];
		System.arraycopy(b, 0, b2, 0, b.length);
		b2[b.length] = '=';
		if (pad > 1) {
			b2[b.length+1] = '=';
		}
		return b2;
	}
	/**
	 * 转码
	 * @param text
	 * @return
	 */
	public static byte[] urlsafeDecode(String text) {
		byte[] buf = Base64.decode(text, Base64.URL_SAFE | Base64.NO_WRAP);
		return buf ;
	}
	
	
}
