package com.pingan.frame.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * SharedPreferences工具类
 * @date 2013-9-10
 * @time 下午2:30:33
 * @author 
 * @where
 */
public class DownloadFileSaveUtil {
	
	private static final String TAG ="DownloadFileSaveUtil";
	
	// SharedPreferences文件的名字
	public static final String NAME_DOWNLOAD = "name_download";
	
	public static final String VERSION_CODE_XML = "versionCode";
	
	/**
	 * 老代码XINXIN   版本号请越写越大
	 * 没有版本号 就肯定是老版本
	 * 结构：
	 * 	public String mFilePath;
	 */
	public static final int VERSION_CODE_XINXIN = -1;
	/**
	 * 1.2.1版本
	 * 新架构  版本号请越写越大
	 * 结构：
	 * 	public String mFilePath;
	 *	public final long mFileLength;
	 *	public final long mLastReadTime;
	 *	public boolean isUpload
	 */
	public static final int VERSION_CODE_P3A = 2;
	/**
	 * version code
	 * @param ctx
	 * @return
	 */
	public static int getVersionCode(Context ctx){
		SharedPreferences spf = ctx.getSharedPreferences(NAME_DOWNLOAD, Context.MODE_WORLD_WRITEABLE);
		int versionCode = spf.getInt(VERSION_CODE_XML, VERSION_CODE_XINXIN);
		return versionCode;
	}
	
	public static boolean refreshVersionCode(Context ctx){
		boolean status = false;
		SharedPreferences spf = ctx.getSharedPreferences(NAME_DOWNLOAD, Context.MODE_WORLD_WRITEABLE);
		SharedPreferences.Editor editor = spf.edit();
		if (spf!=null) {
			editor.putInt(VERSION_CODE_XML, VERSION_CODE_P3A);
			status = editor.commit();
		}
		return status;
	}
	
	/**
	 * 保存文件
	 * @param ctx		context
	 * @param url		url
	 * @param fileSave	文件保存详情
	 * @return	是否保存成功
	 */
	public static boolean saveFile(Context ctx,String url,DownloadFileSave fileSave) {
		boolean status = false;
		SharedPreferences spf = ctx.getSharedPreferences(NAME_DOWNLOAD, Context.MODE_WORLD_WRITEABLE);
		SharedPreferences.Editor editor = spf.edit();
		if (spf!=null) {
			editor.putString(url, fileSave.getGather());
			status = editor.commit();
		}
		return status;
	}

	/**
	 * 获取下载的文件
	 * @param ctx	context
	 * @param url	url
	 * @return	文件相关
	 */
	public static DownloadFileSave getFile(Context ctx,String url) {
		SharedPreferences spf = ctx.getSharedPreferences(NAME_DOWNLOAD, Context.MODE_WORLD_WRITEABLE);
		String gather = spf.getString(url, null);
		if(gather!=null){
			DownloadFileSave downloadFile = DownloadFileSave.parser(gather,url);
			if(downloadFile!=null&&downloadFile.getDownloaStatus() != 
					DownloadFileSave.DOWNLOAD_STATUS_BAD){
				return downloadFile;
			}else{
				deleteFile(ctx, url);
			}
		}
		return null;
	}
	
	public static boolean deleteCacheXml(Context context){
		boolean status = false;
		SharedPreferences spf = context.getSharedPreferences(NAME_DOWNLOAD, Context.MODE_WORLD_WRITEABLE);
		SharedPreferences.Editor editor = spf.edit();
		if (spf!=null) {
			editor.clear();
			status = editor.commit();
		}
		return status;
	}

	/**
	 * 获取可用的下载完成的路径 
	 * @param ctx
	 * @param cacheUrl
	 * @return
	 */
	public static String getUsableCachePath(Context ctx,String cacheUrl){
		DownloadFileSave downloadFile = getFile(ctx, cacheUrl);
		if(downloadFile!=null&&downloadFile.getDownloaStatus()==DownloadFileSave.DOWNLOAD_STATUS_FINISH){
			return downloadFile.getFilePath();
		}
		return null;
	}
	
	/**
	 * 
	 * @param ctx
	 * @param key
	 * @param defValue
	 * @return
	 */
	public static boolean deleteFile(Context ctx,String key) {
		SharedPreferences spf = ctx.getSharedPreferences(NAME_DOWNLOAD, Context.MODE_WORLD_WRITEABLE);
		SharedPreferences.Editor editor = spf.edit();
		editor.remove(key);
		return editor.commit();
	}
	
	private static List<DownloadFileSave> getAllDownloadFile(Context context){
		List<DownloadFileSave> downloadFileList = new ArrayList<DownloadFileSaveUtil.DownloadFileSave>();
		try{
			SharedPreferences spf = context.getSharedPreferences(NAME_DOWNLOAD, Context.MODE_WORLD_WRITEABLE);
			Map<String, String> mapArraryMap = (Map<String, String>) spf.getAll();
			Iterator<String> iterator = mapArraryMap.keySet().iterator();
			while(iterator.hasNext()){
				String urlKey =  iterator.next();
				String downloadContent = mapArraryMap.get(urlKey);
				DownloadFileSave downloadFile = DownloadFileSave.parser(downloadContent,urlKey);
				if(downloadFile!=null){
					downloadFileList.add(downloadFile);
				}
			}
			
		}catch(Exception ex){
			ex.printStackTrace();
		}
		return downloadFileList;
	}
	
	public static class DownloadFileSave{
		public static final long FIXED_LENGTH = 10086;
		
		public static final int DOWNLOAD_STATUS_FINISH = 100;
		
		public static final int DOWNLOAD_STATUS_BAD = 200;
		
		public static final int DOWNLOAD_STATUS_DOWNLOADING = 300;
		
		public String mUrl;
		/**
		 * 本地文件路径
		 */
		public String mFilePath;
		/**
		 * 网路文件大小
		 */
		public final long mNetworkFileLength;
		/**
		 * 本地文件大小
		 */
		public final long mFileLength;
		/**
		 * 
		 */
		public final long mLastReadTime;
		/**
		 * 是否通过上传触发保存（这类资源基本不需要删除）
		 */
		public boolean isUpload = false;
		
		public static final String COMPART = ",luochun";
		
		
		/**
		 * 保存使用此构造函数
		 * @param filePath
		 */
		public DownloadFileSave(String filePath){
			mFilePath = filePath;
			mNetworkFileLength = FileUtil.getFileLength(filePath);
			mFileLength = mNetworkFileLength;
			mLastReadTime = System.currentTimeMillis();
		}
		
		/**
		 * 保存使用此构造函数
		 * @param filePath
		 */
		public DownloadFileSave(String filePath,boolean isUpload){
			mFilePath = filePath;
			mNetworkFileLength = FileUtil.getFileLength(filePath);
			mFileLength = mNetworkFileLength;
			mLastReadTime = System.currentTimeMillis();
			this.isUpload = isUpload;
		}
		/**
		 * 保存并且需要断点续传使用此构造函数
		 * @param filePath
		 * @param networkFileLength
		 */
		public DownloadFileSave(String filePath,long networkFileLength){
			mFilePath = filePath;
			mNetworkFileLength = networkFileLength;
			mFileLength = FileUtil.getFileLength(filePath);
			mLastReadTime = System.currentTimeMillis();
		}
		
		/**
		 * 解析得到的构造函数
		 * @param filePath
		 * @param networkFileLength
		 */
		public DownloadFileSave(String filePath,long networkFileLength,long lastReadTime,String url,boolean isUpload){
			mFilePath = filePath;
			mNetworkFileLength = networkFileLength;
			mFileLength = FileUtil.getFileLength(filePath);
			mLastReadTime = lastReadTime;
			mUrl = url;
		}
		
		public String getFilePath(){
			return mFilePath;
		}
		
		private static DownloadFileSave parser(String gather,String urlKey){
			try{
				//新版本
				if(gather.contains(COMPART)){
					String[] gatherArrary = gather.split(COMPART);
					try{
						if(gatherArrary.length==2){
							String filePath = gatherArrary[0];
							long networkFileLength = Long.parseLong(gatherArrary[1]);
							return new DownloadFileSave(filePath, networkFileLength);
						}
						else if(gatherArrary.length==4){
							String filePath = gatherArrary[0];
							long networkFileLength = Long.parseLong(gatherArrary[1]);
							long lastReadTime = Long.parseLong(gatherArrary[2]);
							boolean isUpload = Boolean.parseBoolean(gatherArrary[3]);
							return new DownloadFileSave(filePath, networkFileLength,lastReadTime,urlKey,isUpload);
						}
						else{
							return null;
						}
					}catch(Exception ex){
						return null;
					}
				}
				//旧版本
				else{
					String filePath = gather;
					return new DownloadFileSave(filePath);
				}
			}catch(Exception ex){
				ex.printStackTrace();
				AppLog.e(TAG, "httpframe 无法解析xml对应的资源文件  urlKey："+urlKey+"  gather:"+gather);
				return null;
			}
		}
		
		private String getGather(){
			return mFilePath+COMPART+mNetworkFileLength+COMPART+mLastReadTime+COMPART+isUpload;
		}
		
		
		public int getDownloaStatus(){
			//如果不存在
			if(mFilePath==null||!new File(mFilePath).isFile()||mFileLength>mNetworkFileLength){
				return DOWNLOAD_STATUS_BAD;
			}
			else if(mNetworkFileLength == mFileLength){
				return DOWNLOAD_STATUS_FINISH;
			}
			else {
				return DOWNLOAD_STATUS_DOWNLOADING;
			}
		}
		
	}
}
